/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.ui.state;

import java.util.HashMap;
import org.chiba.xml.dom.DOMUtil;
import org.chiba.xml.ns.NamespaceResolver;
import org.chiba.xml.xforms.Container;
import org.chiba.xml.xforms.core.ModelItem;
import org.chiba.xml.xforms.core.StateChangeView;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xforms.ui.BoundElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.events.EventTarget;

public class UIElementStateUtil {
    public static final short VALID = 0;
    public static final short READONLY = 1;
    public static final short REQUIRED = 2;
    public static final short ENABLED = 3;

    public static Element createStateElement(Element parent) {
        Element state = DOMUtil.findFirstChildNS(parent, "http://chiba.sourceforge.net/xforms", "data");
        if (state != null) {
            return state;
        }
        Document document = parent.getOwnerDocument();
        state = document.createElementNS("http://chiba.sourceforge.net/xforms", "chiba:data");
        parent.appendChild(state);
        return state;
    }

    public static void setStateAttribute(Element element, String name, String value) {
        if (value != null) {
            element.setAttributeNS("http://chiba.sourceforge.net/xforms", "chiba:" + name, value);
        } else {
            element.removeAttributeNS("http://chiba.sourceforge.net/xforms", name);
        }
    }

    public static boolean hasPropertyChanged(boolean[] currentProperties, boolean[] newProperties, short index) {
        return currentProperties == null && newProperties != null || currentProperties != null && newProperties == null || currentProperties != null && currentProperties[index] != newProperties[index];
    }

    public static boolean hasValueChanged(String currentValue, String newValue) {
        return currentValue == null && newValue != null || currentValue != null && newValue == null || currentValue != null && !currentValue.equals(newValue);
    }

    public static boolean hasTypeChanged(String currentType, String newType) {
        return UIElementStateUtil.hasValueChanged(currentType, newType);
    }

    public static ModelItem getModelItem(BoundElement owner) {
        if (owner.isBound()) {
            return owner.getModel().getInstance(owner.getInstanceId()).getModelItem(owner.getLocationPath());
        }
        return null;
    }

    public static boolean[] getModelItemProperties(ModelItem modelItem) {
        boolean[] properties = new boolean[]{true, false, false, false};
        if (modelItem != null) {
            properties[0] = modelItem.isValid();
            properties[1] = modelItem.isReadonly();
            properties[2] = modelItem.isRequired();
            properties[3] = modelItem.isEnabled();
        }
        return properties;
    }

    public static String getDefaultDatatype(Element element) {
        String prefix = NamespaceResolver.getPrefix(element, "http://www.w3.org/2001/XMLSchema");
        return prefix != null ? prefix + ":string" : "string";
    }

    public static String getDatatype(ModelItem modelItem, Element element) {
        String datatype = modelItem.getDeclarationView().getDatatype();
        if (datatype == null && (datatype = modelItem.getXSIType()) == null) {
            datatype = UIElementStateUtil.getDefaultDatatype(element);
        }
        return datatype;
    }

    public static void dispatchXFormsEvents(BoundElement boundElement, ModelItem modelItem, boolean[] properties) throws XFormsException {
        if (modelItem != null) {
            StateChangeView stateChangeView = modelItem.getStateChangeView();
            Container container = boundElement.getContainerObject();
            EventTarget eventTarget = boundElement.getTarget();
            if (stateChangeView.hasValueChanged()) {
                container.dispatch(eventTarget, "xforms-value-changed", null);
                container.dispatch(eventTarget, properties[0] ? "xforms-valid" : "xforms-invalid", null);
                container.dispatch(eventTarget, properties[1] ? "xforms-readonly" : "xforms-readwrite", null);
                container.dispatch(eventTarget, properties[2] ? "xforms-required" : "xforms-optional", null);
                container.dispatch(eventTarget, properties[3] ? "xforms-enabled" : "xforms-disabled", null);
            } else {
                if (stateChangeView.hasValidChanged()) {
                    container.dispatch(eventTarget, properties[0] ? "xforms-valid" : "xforms-invalid", null);
                }
                if (stateChangeView.hasReadonlyChanged()) {
                    container.dispatch(eventTarget, properties[1] ? "xforms-readonly" : "xforms-readwrite", null);
                }
                if (stateChangeView.hasRequiredChanged()) {
                    container.dispatch(eventTarget, properties[2] ? "xforms-required" : "xforms-optional", null);
                }
                if (stateChangeView.hasEnabledChanged()) {
                    container.dispatch(eventTarget, properties[3] ? "xforms-enabled" : "xforms-disabled", null);
                }
            }
        }
    }

    public static void dispatchChibaEvents(BoundElement boundElement, boolean[] currentProperties, boolean[] newProperties) throws XFormsException {
        UIElementStateUtil.dispatchChibaEvents(boundElement, currentProperties, null, null, newProperties, null, null);
    }

    public static void dispatchChibaEvents(BoundElement boundElement, String currentValue, String newValue) throws XFormsException {
        UIElementStateUtil.dispatchChibaEvents(boundElement, null, currentValue, null, null, newValue, null);
    }

    public static void dispatchChibaEvents(BoundElement boundElement, boolean[] currentProperties, String currentValue, boolean[] newProperties, String newValue) throws XFormsException {
        UIElementStateUtil.dispatchChibaEvents(boundElement, currentProperties, currentValue, null, newProperties, newValue, null);
    }

    public static void dispatchChibaEvents(BoundElement boundElement, boolean[] currentProperties, String currentValue, String currentType, boolean[] newProperties, String newValue, String newType) throws XFormsException {
        HashMap<String, String> context = new HashMap<String, String>();
        if (UIElementStateUtil.hasPropertyChanged(currentProperties, newProperties, (short)0)) {
            context.put("valid", String.valueOf(newProperties[0]));
        }
        if (UIElementStateUtil.hasPropertyChanged(currentProperties, newProperties, (short)1)) {
            context.put("readonly", String.valueOf(newProperties[1]));
        }
        if (UIElementStateUtil.hasPropertyChanged(currentProperties, newProperties, (short)2)) {
            context.put("required", String.valueOf(newProperties[2]));
        }
        if (UIElementStateUtil.hasPropertyChanged(currentProperties, newProperties, (short)3)) {
            context.put("enabled", String.valueOf(newProperties[3]));
        }
        if (UIElementStateUtil.hasValueChanged(currentValue, newValue)) {
            context.put("value", newValue);
        }
        if (UIElementStateUtil.hasTypeChanged(currentType, newType)) {
            context.put("type", newType);
        }
        if (!context.isEmpty()) {
            Container container = boundElement.getContainerObject();
            EventTarget eventTarget = boundElement.getTarget();
            container.dispatch(eventTarget, "chiba-state-changed", context);
        }
    }
}

