/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.xpath;

import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.jxpath.ExpressionContext;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.NodeSet;
import org.apache.commons.jxpath.Pointer;
import org.chiba.xml.xforms.Container;
import org.chiba.xml.xforms.XFormsElement;
import org.chiba.xml.xforms.XFormsElementFactory;
import org.chiba.xml.xforms.core.Instance;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xforms.ui.Repeat;
import org.chiba.xml.xforms.xpath.ExtensionFunctionsHelper;
import org.w3c.dom.Element;

public class XFormsExtensionFunctions {
    private XFormsExtensionFunctions() {
    }

    public static boolean boolean_from_string(String value) {
        if ("true".equalsIgnoreCase(value) || "1".equals(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value) || "0".equals(value)) {
            return false;
        }
        return false;
    }

    public static String IF(boolean bool, String s1, String s2) {
        return bool ? s1 : s2;
    }

    public static double avg(ExpressionContext expressionContext, NodeSet nodeset) {
        if (nodeset.getPointers().size() == 0) {
            return Double.NaN;
        }
        JXPathContext rootContext = expressionContext.getJXPathContext();
        rootContext.getVariables().declareVariable("nodeset", (Object)nodeset.getPointers());
        Double value = (Double)rootContext.getValue("sum($nodeset) div count($nodeset)");
        return value;
    }

    public static double min(ExpressionContext expressionContext, NodeSet nodeset) {
        if (nodeset.getPointers().size() == 0) {
            return Double.NaN;
        }
        JXPathContext rootContext = expressionContext.getJXPathContext();
        List nodes = nodeset.getNodes();
        Object min = nodes.get(0);
        Double nan = new Double(Double.NaN);
        for (int index = 0; index < nodes.size(); ++index) {
            Object current = nodes.get(index);
            rootContext.getVariables().declareVariable("min", min);
            rootContext.getVariables().declareVariable("current", current);
            if (rootContext.getValue("number($current)").equals(nan)) {
                return Double.NaN;
            }
            if (!rootContext.getValue("number($current) < number($min)").equals(Boolean.TRUE)) continue;
            min = current;
        }
        return Double.valueOf(min.toString());
    }

    public static double max(ExpressionContext expressionContext, NodeSet nodeset) {
        if (nodeset.getPointers().size() == 0) {
            return Double.NaN;
        }
        JXPathContext rootContext = expressionContext.getJXPathContext();
        List nodes = nodeset.getNodes();
        Object max = nodes.get(0);
        Double nan = new Double(Double.NaN);
        for (int index = 0; index < nodes.size(); ++index) {
            Object current = nodes.get(index);
            rootContext.getVariables().declareVariable("max", max);
            rootContext.getVariables().declareVariable("current", current);
            if (rootContext.getValue("number($current)").equals(nan)) {
                return Double.NaN;
            }
            if (!rootContext.getValue("number($current) > number($max)").equals(Boolean.TRUE)) continue;
            max = current;
        }
        return Double.valueOf(max.toString());
    }

    public static double count_non_empty(NodeSet nodeset) {
        if (nodeset.getPointers().size() == 0) {
            return 0.0;
        }
        double count = 0.0;
        Iterator iterator = nodeset.getValues().iterator();
        while (iterator.hasNext()) {
            String value = iterator.next().toString();
            if (value.length() <= 0) continue;
            count += 1.0;
        }
        return count;
    }

    public static double index(ExpressionContext expressionContext, String idref) {
        Element element;
        Container container = ExtensionFunctionsHelper.getChibaContainer(expressionContext);
        if (container == null) {
            return Double.NaN;
        }
        XFormsElement object = container.lookup(idref);
        if (object != null && object instanceof Repeat) {
            return ((Repeat)object).getIndex();
        }
        Pointer pointer = container.getRootContext().getPointer("//*[@id='" + idref + "']");
        if (pointer != null && pointer.getNode() != null && ("http://www.w3.org/2002/xforms".equals((element = (Element)pointer.getNode()).getNamespaceURI()) && "repeat".equals(element.getLocalName()) || XFormsElementFactory.hasRepeatAttributes(element))) {
            return 1.0;
        }
        return Double.NaN;
    }

    public static String property(String name) {
        if ("version".equals(name)) {
            return "1.0";
        }
        if ("conformance-level".equals(name)) {
            return "full";
        }
        return null;
    }

    public static String now() {
        return ExtensionFunctionsHelper.formatISODate(new Date());
    }

    public static double days_from_date(String date) {
        try {
            double days = ExtensionFunctionsHelper.parseISODate(date).getTime() / 86400000L;
            return days > 0.0 ? Math.ceil(days) : Math.floor(days);
        }
        catch (ParseException e) {
            return Double.NaN;
        }
    }

    public static double seconds_from_dateTime(String dateTime) {
        try {
            double seconds = ExtensionFunctionsHelper.parseISODate(dateTime).getTime() / 1000L;
            return seconds;
        }
        catch (ParseException e) {
            return Double.NaN;
        }
    }

    public static double seconds(String duration) {
        try {
            float[] values = ExtensionFunctionsHelper.parseISODuration(duration);
            double seconds = values[6] + 60.0f * values[5] + 3600.0f * values[4] + 86400.0f * values[3];
            return seconds *= (double)values[0];
        }
        catch (ParseException e) {
            return Double.NaN;
        }
    }

    public static double months(String duration) {
        try {
            float[] values = ExtensionFunctionsHelper.parseISODuration(duration);
            double months = values[2] + 12.0f * values[1];
            return months *= (double)values[0];
        }
        catch (ParseException e) {
            return Double.NaN;
        }
    }

    public static Pointer instance(ExpressionContext expressionContext, String idref) {
        Container container = ExtensionFunctionsHelper.getChibaContainer(expressionContext);
        if (container == null) {
            return null;
        }
        XFormsElement object = container.lookup(idref);
        if (object != null && object instanceof Instance) {
            return ((Instance)object).getPointer("/*[1]");
        }
        return null;
    }

    public static Pointer current(ExpressionContext expressionContext) throws XFormsException {
        JXPathContext rootContext = expressionContext.getJXPathContext();
        if (rootContext.getVariables().isDeclaredVariable("currentContextPath")) {
            String currentContextPath = (String)rootContext.getVariables().getVariable("currentContextPath");
            return rootContext.getPointer(currentContextPath);
        }
        return expressionContext.getJXPathContext().getPointer(".");
    }
}

