/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xpath.impl;

import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.log4j.Logger;
import org.chiba.xml.ns.NamespaceResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JXPathDOMFactory
extends AbstractFactory {
    private static final Logger LOGGER = Logger.getLogger(JXPathDOMFactory.class);
    private Element namespaceContext = null;

    public void setNamespaceContext(Element namespaceContext) {
        this.namespaceContext = namespaceContext;
    }

    public boolean createObject(JXPathContext context, Pointer pointer, Object parent, String name, int index) {
        if (parent instanceof Element) {
            return this.createChildElement((Element)parent, name, index);
        }
        if (parent instanceof Document) {
            return this.createRootElement((Document)parent, name, index);
        }
        LOGGER.error((Object)("wrong object model: " + parent.getClass().getName()));
        return false;
    }

    public boolean declareVariable(JXPathContext context, String name) {
        return false;
    }

    private boolean createRootElement(Document parent, String name, int index) {
        String nsPrefix;
        if (index != 0) {
            LOGGER.error((Object)"exactly one root element allowed");
            return false;
        }
        if (this.namespaceContext == null) {
            LOGGER.error((Object)"no instance element specified");
            return false;
        }
        int nsSeparator = name.indexOf(58);
        String nsUri = null;
        if (nsSeparator > -1 && (nsUri = NamespaceResolver.getNamespaceURI(this.namespaceContext, nsPrefix = name.substring(0, nsSeparator))) == null) {
            LOGGER.error((Object)("namespace prefix unknown: " + nsPrefix));
            return false;
        }
        Element root = parent.createElementNS(nsUri, name);
        NamespaceResolver.applyNamespaces(this.namespaceContext, root);
        parent.appendChild(root);
        return true;
    }

    private boolean createChildElement(Element parent, String name, int index) {
        String nsPrefix;
        if (index > parent.getChildNodes().getLength()) {
            LOGGER.error((Object)("child position too big: " + (index + 1)));
            return false;
        }
        int nsSeparator = name.indexOf(58);
        String nsUri = null;
        if (nsSeparator > -1 && (nsUri = NamespaceResolver.getNamespaceURI(parent, nsPrefix = name.substring(0, nsSeparator))) == null) {
            LOGGER.error((Object)("namespace prefix unknown: " + nsPrefix));
            return false;
        }
        Element child = parent.getOwnerDocument().createElementNS(nsUri, name);
        parent.appendChild(child);
        return true;
    }
}

