/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.sandbox;

import com.sun.star.lib.sandbox.AudioProxy;
import com.sun.star.lib.sandbox.Cachable;
import com.sun.star.lib.sandbox.Holder;
import com.sun.star.lib.sandbox.ProtectionDomain;
import com.sun.star.lib.sandbox.Resource;
import com.sun.star.lib.sandbox.ResourceImpl;
import com.sun.star.lib.sandbox.WeakRef;
import com.sun.star.lib.sandbox.WeakTable;
import java.applet.AudioClip;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class ResourceProxy
implements Resource,
Cachable {
    private static final boolean DEBUG = false;
    private static int instances;
    private Resource resource;
    private WeakRef weakRef;

    static boolean isResource(URL uRL) {
        boolean bl;
        block3: {
            bl = false;
            ResourceProxy resourceProxy = (ResourceProxy)WeakTable.get(uRL);
            boolean bl2 = bl = resourceProxy != null;
            if (bl) break block3;
            try {
                URLConnection uRLConnection = uRL.openConnection();
                if (uRLConnection instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    int n = httpURLConnection.getResponseCode();
                    bl = n == 200 || n < 400;
                    break block3;
                }
                InputStream inputStream = uRL.openStream();
                inputStream.close();
                bl = true;
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    public static ResourceProxy load(URL uRL, ProtectionDomain protectionDomain) {
        ResourceProxy resourceProxy = (ResourceProxy)WeakTable.get(uRL);
        if (resourceProxy == null) {
            resourceProxy = new ResourceProxy(uRL, null, protectionDomain);
            WeakTable.put(uRL, resourceProxy);
        }
        return resourceProxy;
    }

    public static ResourceProxy create(URL uRL, byte[] byArray, ProtectionDomain protectionDomain) {
        ResourceProxy resourceProxy = (ResourceProxy)WeakTable.get(uRL);
        if (resourceProxy == null) {
            resourceProxy = new ResourceProxy(uRL, byArray, protectionDomain);
            WeakTable.put(uRL, resourceProxy);
        } else {
            System.err.println("WARNING! ResourceProxy.create - resource already loaded:" + resourceProxy);
        }
        return resourceProxy;
    }

    public ResourceProxy() {
        ++instances;
    }

    public Object getHardObject() {
        return this.resource;
    }

    public void setWeakRef(WeakRef weakRef) {
        this.resource = (Resource)weakRef.getRef();
        this.weakRef = weakRef;
        weakRef.incRefCnt();
    }

    public void finalize() {
        this.weakRef.decRefCnt();
        --instances;
    }

    private ResourceProxy(URL uRL, byte[] byArray, ProtectionDomain protectionDomain) {
        this();
        this.resource = new ResourceImpl(uRL, byArray, protectionDomain);
    }

    public ProtectionDomain getProtectionDomain() {
        return this.resource.getProtectionDomain();
    }

    public synchronized URL getURL() {
        return this.resource.getURL();
    }

    public synchronized InputStream getInputStream() throws IOException {
        return this.resource.getInputStream();
    }

    public synchronized byte[] getBytes() throws IOException {
        return this.resource.getBytes();
    }

    public synchronized ImageProducer getImageProducer() {
        ImageProducer imageProducer = this.resource.getImageProducer();
        return imageProducer;
    }

    public synchronized AudioClip getAudioClip() {
        AudioClip audioClip = this.resource.getAudioClip();
        if ((audioClip = new AudioProxy(audioClip)) instanceof Holder) {
            Holder holder = (Holder)((Object)audioClip);
            holder.addCargo(this);
        }
        return audioClip;
    }

    public Object getContent() throws IOException {
        Object object = this.resource.getContent();
        if (object instanceof Holder) {
            ((Holder)object).addCargo(this);
        }
        return object;
    }

    public void loadJar(URL uRL) throws IOException {
        this.resource.loadJar(uRL);
    }
}

