/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.sandbox;

import com.sun.star.lib.sandbox.ClassContextImpl;
import com.sun.star.lib.sandbox.RecursionCounter;
import com.sun.star.lib.sandbox.SandboxSecurityException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AllPermission;
import java.security.IdentityScope;
import java.security.Permission;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.security.provider.IdentityDatabase;

public class SandboxSecurity
extends SecurityManager {
    private static boolean debug = false;
    public static final int NETWORK_NONE = 1;
    public static final int NETWORK_HOST = 2;
    public static final int NETWORK_UNRESTRICTED = 3;
    private static final int PRIVELEGED_PORT = 1024;
    boolean bNoExit;
    boolean initACL;
    String[] readACL;
    String[] writeACL;
    int networkMode;
    boolean bCheckSecurity;
    RecursionCounter InCheck = new RecursionCounter();
    RecursionCounter InIsSecureLoader = new RecursionCounter();
    RecursionCounter InInClassLoader = new RecursionCounter();
    RecursionCounter InClassLoaderDepth = new RecursionCounter();
    AllPermission allPerm = new AllPermission();
    IdentityScope scope;
    Hashtable loadedClasses;

    public int getNetworkMode() {
        return this.networkMode;
    }

    public SandboxSecurity() {
        this.reset();
    }

    public SandboxSecurity(boolean bl) {
        this.reset();
        this.bNoExit = bl;
    }

    public void reset() {
        String string = System.getProperty("appletviewer.security.mode");
        this.networkMode = string == null ? 2 : (string.equals("unrestricted") ? 3 : (string.equals("none") ? 1 : 2));
        this.bCheckSecurity = !Boolean.getBoolean("stardiv.security.disableSecurity");
        IdentityScope identityScope = IdentityScope.getSystemScope();
        if (identityScope instanceof IdentityDatabase) {
            this.scope = (IdentityDatabase)identityScope;
            this.debug("installing " + identityScope + " as the scope for signers.");
        } else {
            this.debug("no signer scope found.");
        }
        this.loadedClasses = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean inApplet() {
        boolean bl = false;
        try {
            this.InCheck.acquire();
            bl = this.inClassLoader();
            Object var3_2 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.InCheck.release();
            throw throwable;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object getSecurityContext() {
        URL uRL = null;
        try {
            this.InCheck.acquire();
            ClassLoader classLoader = this.currentClassLoader();
            if (classLoader != null) {
                if (classLoader instanceof ClassContextImpl) {
                    ClassContextImpl classContextImpl = (ClassContextImpl)classLoader;
                    uRL = classContextImpl.getBase();
                } else {
                    throw new SandboxSecurityException("getsecuritycontext.unknown");
                }
            }
            Object var5_4 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.InCheck.release();
            throw throwable;
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkCreateClassLoader() {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && !this.isSecureLoader() && this.classLoaderDepth() == 2) {
                throw new SandboxSecurityException("checkcreateclassloader");
            }
            Object var2_1 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.InCheck.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean inThreadGroup(ThreadGroup threadGroup) {
        boolean bl = false;
        try {
            this.InCheck.acquire();
            ClassLoader classLoader = this.currentClassLoader();
            if (classLoader instanceof ClassContextImpl) {
                ClassContextImpl classContextImpl = (ClassContextImpl)classLoader;
                ThreadGroup threadGroup2 = classContextImpl.getThreadGroup();
                bl = threadGroup2.parentOf(threadGroup);
            }
            Object var7_6 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.InCheck.release();
            throw throwable;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean inThreadGroup(Thread thread) {
        boolean bl = false;
        try {
            this.InCheck.acquire();
            bl = this.inThreadGroup(thread.getThreadGroup());
            Object var4_3 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.InCheck.release();
            throw throwable;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkAccess(Thread thread) {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && !this.isSecureLoader() && this.classLoaderDepth() == 3 && !this.inThreadGroup(thread)) {
                throw new SandboxSecurityException("checkaccess.thread");
            }
            Object var3_2 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.InCheck.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkAccess(ThreadGroup threadGroup) {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && !this.isSecureLoader() && this.classLoaderDepth() == 4 && !this.inThreadGroup(threadGroup)) {
                throw new SandboxSecurityException("checkaccess.threadgroup", threadGroup.toString());
            }
            Object var3_2 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.InCheck.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkExit(int n) {
        try {
            this.InCheck.acquire();
            if (this.bNoExit) {
                throw new SandboxSecurityException("checkexit", String.valueOf(n));
            }
            if (this.bCheckSecurity && !this.isSecureLoader() && this.inApplet()) {
                throw new SandboxSecurityException("checkexit", String.valueOf(n));
            }
            Object var3_2 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.InCheck.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkExec(String string) {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && !this.isSecureLoader() && this.inApplet()) {
                throw new SandboxSecurityException("checkexec", string);
            }
            Object var3_2 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.InCheck.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkLink(String string) {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && !this.isSecureLoader()) {
                switch (this.classLoaderDepth()) {
                    case 2: 
                    case 3: {
                        throw new SandboxSecurityException("checklink", string);
                    }
                }
            }
            Object var3_2 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.InCheck.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkPropertiesAccess() {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && !this.isSecureLoader() && this.classLoaderDepth() == 2) {
                throw new SandboxSecurityException("checkpropsaccess");
            }
            Object var2_1 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.InCheck.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkPropertyAccess(String string) {
        try {
            String string2;
            boolean bl;
            this.InCheck.acquire();
            if (this.bCheckSecurity && !this.isSecureLoader() && this.classLoaderDepth() == 2 && !(bl = new Boolean(string2 = System.getProperty(string + ".applet")).booleanValue())) {
                throw new SandboxSecurityException("checkpropsaccess.key", string2);
            }
            Object var5_4 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.InCheck.release();
            throw throwable;
        }
    }

    void parseACL(Vector vector, String string, String string2) {
        String string3 = System.getProperty("path.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.startsWith("~")) {
                vector.addElement(System.getProperty("user.home") + string4.substring(1));
                continue;
            }
            if (string4.equals("+")) {
                if (string2 == null) continue;
                this.parseACL(vector, string2, null);
                continue;
            }
            vector.addElement(string4);
        }
    }

    String[] parseACL(String string, String string2) {
        if (string == null) {
            return new String[0];
        }
        if (string.equals("*")) {
            return null;
        }
        Vector vector = new Vector();
        this.parseACL(vector, string, string2);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    void initializeACLs() {
        this.readACL = this.parseACL(System.getProperty("acl.read"), System.getProperty("acl.read.default"));
        this.writeACL = this.parseACL(System.getProperty("acl.write"), System.getProperty("acl.write.default"));
        this.initACL = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkRead(String string) {
        try {
            ClassLoader classLoader;
            this.InCheck.acquire();
            if (this.bCheckSecurity && !this.isSecureLoader() && (classLoader = this.currentClassLoader()) != null) {
                if (!(classLoader instanceof ClassContextImpl)) {
                    throw new SandboxSecurityException("checkread.unknown", string);
                }
                ClassContextImpl classContextImpl = (ClassContextImpl)classLoader;
                URL uRL = classContextImpl.getBase();
                this.checkRead(string, uRL);
            }
            Object var6_5 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.InCheck.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void checkRead(String string, URL uRL) {
        block12: {
            block15: {
                block14: {
                    try {
                        String string2;
                        String string3;
                        block13: {
                            this.InCheck.acquire();
                            if (!this.bCheckSecurity || uRL == null || this.isSecureLoader()) break block12;
                            if (!this.initACL) {
                                this.initializeACLs();
                            }
                            if (this.readACL == null) {
                                this.InCheck.release();
                                Object var13_3 = null;
                                this.InCheck.release();
                                return;
                            }
                            string3 = null;
                            try {
                                string3 = new File(string).getCanonicalPath();
                            }
                            catch (IOException iOException) {
                                throw new SandboxSecurityException("checkread.exception1", iOException.getMessage(), string);
                            }
                            int n = this.readACL.length;
                            do {
                                if (n-- > 0) continue;
                                if (!uRL.getProtocol().equals("file")) throw new SandboxSecurityException("checkread", string, string3);
                                string2 = null;
                                try {
                                    StringBuffer stringBuffer = new StringBuffer(256);
                                    String string4 = "%20";
                                    String string5 = uRL.getFile();
                                    int n2 = 0;
                                    int n3 = 0;
                                    while (true) {
                                        if ((n3 = string5.indexOf(string4, n2)) == -1) {
                                            stringBuffer.append(string5.substring(n2));
                                            String string6 = stringBuffer.toString();
                                            string2 = new File(string6).getCanonicalPath();
                                            break block13;
                                        }
                                        stringBuffer.append(string5.substring(n2, n3));
                                        stringBuffer.append(" ");
                                        n2 = n3 + string4.length();
                                    }
                                }
                                catch (IOException iOException) {
                                    throw new SandboxSecurityException("checkread.exception2", iOException.toString());
                                }
                            } while (!string3.startsWith(this.readACL[n]));
                            this.InCheck.release();
                            break block14;
                        }
                        if (!string3.startsWith(string2)) throw new SandboxSecurityException("checkread", string, string3);
                        this.InCheck.release();
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var13_7 = null;
                        this.InCheck.release();
                        throw throwable;
                    }
                }
                Object var13_4 = null;
                this.InCheck.release();
                return;
            }
            Object var13_5 = null;
            this.InCheck.release();
            return;
        }
        Object var13_6 = null;
        this.InCheck.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkRead(String string, Object object) {
        try {
            this.InCheck.acquire();
            this.checkRead(string);
            if (object != null) {
                this.checkRead(string, (URL)object);
            }
            Object var4_3 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.InCheck.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void checkWrite(String string) {
        block7: {
            try {
                this.InCheck.acquire();
                if (!this.bCheckSecurity || !this.inApplet() || this.isSecureLoader()) break block7;
                if (!this.initACL) {
                    this.initializeACLs();
                }
                if (this.writeACL == null) {
                    this.InCheck.release();
                    Object var5_2 = null;
                    this.InCheck.release();
                    return;
                }
                String string2 = null;
                try {
                    string2 = new File(string).getCanonicalPath();
                }
                catch (IOException iOException) {
                    throw new SandboxSecurityException("checkwrite.exception", iOException.getMessage(), string);
                }
                int n = this.writeACL.length;
                do {
                    if (n-- > 0) continue;
                    throw new SandboxSecurityException("checkwrite", string, string2);
                } while (!string2.startsWith(this.writeACL[n]));
                this.InCheck.release();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.InCheck.release();
                throw throwable;
            }
            Object var5_3 = null;
            this.InCheck.release();
            return;
        }
        Object var5_4 = null;
        this.InCheck.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkRead(FileDescriptor fileDescriptor) {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && !this.isSecureLoader() && (this.inApplet() && !this.inClass("java.net.SocketInputStream") || !fileDescriptor.valid())) {
                throw new SandboxSecurityException("checkread.fd");
            }
            Object var3_2 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.InCheck.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkWrite(FileDescriptor fileDescriptor) {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && !this.isSecureLoader() && (this.inApplet() && !this.inClass("java.net.SocketOutputStream") || !fileDescriptor.valid())) {
                throw new SandboxSecurityException("checkwrite.fd");
            }
            Object var3_2 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.InCheck.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkListen(int n) {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && !this.isSecureLoader() && this.inApplet() && n > 0 && n < 1024) {
                throw new SandboxSecurityException("checklisten", String.valueOf(n));
            }
            Object var3_2 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.InCheck.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkAccept(String string, int n) {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && !this.isSecureLoader()) {
                if (this.inApplet() && n < 1024) {
                    throw new SandboxSecurityException("checkaccept", string, String.valueOf(n));
                }
                this.checkConnect(string, n);
            }
            Object var4_3 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.InCheck.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void checkConnect(String string, int n) {
        block5: {
            block7: {
                block6: {
                    try {
                        this.InCheck.acquire();
                        if (!this.bCheckSecurity || this.isSecureLoader()) break block5;
                        ClassLoader classLoader = this.currentClassLoader();
                        if (classLoader == null) {
                            this.InCheck.release();
                            Object var7_4 = null;
                            this.InCheck.release();
                            return;
                        }
                        int n2 = this.classDepth("sun.net.www.http.HttpClient");
                        if (n2 > 1) {
                            this.InCheck.release();
                            break block6;
                        }
                        if (this.getInCheck()) {
                            this.InCheck.release();
                            break block7;
                        }
                        if (!(classLoader instanceof ClassContextImpl)) throw new SandboxSecurityException("checkconnect.unknown");
                        ClassContextImpl classContextImpl = (ClassContextImpl)classLoader;
                        this.checkConnect(classContextImpl.getBase().getHost(), string);
                        break block5;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        this.InCheck.release();
                        throw throwable;
                    }
                }
                Object var7_5 = null;
                this.InCheck.release();
                return;
            }
            Object var7_6 = null;
            this.InCheck.release();
            return;
        }
        Object var7_7 = null;
        this.InCheck.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkConnect(String string, int n, Object object) {
        try {
            this.InCheck.acquire();
            this.checkConnect(string, n);
            if (object != null) {
                this.checkConnect(((URL)object).getHost(), string);
            }
            Object var5_4 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.InCheck.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void checkConnect(String var1_1, String var2_2, boolean var3_3) {
        try {
            block18: {
                this.InCheck.acquire();
                if (!this.bCheckSecurity || this.isSecureLoader()) break block18;
                if (var1_1 == null) {
                    this.InCheck.release();
                    var10_4 = null;
                    this.InCheck.release();
                    return;
                }
                switch (this.networkMode) {
                    case 1: {
                        throw new SandboxSecurityException("checkconnect.networknone", var1_1, var2_2);
                    }
                    case 2: {
                        this.inCheck = true;
                        if (var1_1.equals(var2_2)) ** GOTO lbl-1000
                        var4_11 = InetAddress.getByName(var2_2);
                        var5_13 = InetAddress.getByName(var1_1);
                        if (!var5_13.equals(var4_11)) ** GOTO lbl33
                        this.InCheck.release();
                        {
                            catch (UnknownHostException var6_18) {
                                throw new SecurityException("checkconnect.networkhost2" + var2_2 + var1_1);
                            }
                        }
                        var8_14 = null;
                        this.inCheck = false;
                        var10_5 = null;
                        this.InCheck.release();
                        return;
lbl33:
                        // 3 sources

                        throw new SandboxSecurityException("checkconnect.networkhost1", var2_2, var1_1);
                        {
                            catch (Throwable var7_20) {
                                var8_17 = null;
                                this.inCheck = false;
                                throw var7_20;
                            }
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                var4_12 = InetAddress.getByName(var2_2);
                                this.InCheck.release();
                            }
                            catch (UnknownHostException var6_19) {
                                if (!var3_3) ** GOTO lbl54
                                this.InCheck.release();
                                var8_16 = null;
                                this.inCheck = false;
                                var10_7 = null;
                                this.InCheck.release();
                                return;
lbl54:
                                // 2 sources

                                throw new SandboxSecurityException("checkconnect.networkhost3", var2_2);
                            }
                            var8_15 = null;
                            this.inCheck = false;
                            var10_6 = null;
                            this.InCheck.release();
                            return;
                        }
                    }
                    case 3: {
                        this.InCheck.release();
                        var10_8 = null;
                        this.InCheck.release();
                        return;
                    }
                }
                throw new SandboxSecurityException("checkconnect", var1_1, var2_2);
            }
            var10_9 = null;
            this.InCheck.release();
            return;
        }
        catch (Throwable var9_21) {
            var10_10 = null;
            this.InCheck.release();
            throw var9_21;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkConnect(String string, String string2) {
        try {
            this.InCheck.acquire();
            this.checkConnect(string, string2, Boolean.getBoolean("trustProxy"));
            Object var4_3 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.InCheck.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean checkTopLevelWindow(Object object) {
        boolean bl = true;
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && this.inClassLoader() && !this.isSecureLoader()) {
                bl = false;
            }
            Object var4_3 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.InCheck.release();
            throw throwable;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkPackageAccess(String string) {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && this.inClassLoader() && !this.isSecureLoader()) {
                if (string.equals("stardiv.applet") || string.equals("stardiv.look") || string.equals("netscape.javascript")) {
                    this.InCheck.release();
                    Object var7_2 = null;
                    this.InCheck.release();
                    return;
                }
                String[] stringArray = new String[]{"com.sun.star.uno", "com.sun.star.lib.uno", "com.sun.star.comp.connections", "com.sun.star.comp.loader", "com.sun.star.comp.servicemanager"};
                int n = 0;
                while (n < stringArray.length) {
                    if (string.startsWith(stringArray[n])) {
                        throw new SandboxSecurityException("checkpackageaccess2", string);
                    }
                    ++n;
                }
                int n2 = string.indexOf(46);
                while (n2 > 0) {
                    String string2 = string.substring(0, n2);
                    if (Boolean.getBoolean("package.restrict.access." + string2)) {
                        throw new SandboxSecurityException("checkpackageaccess", string);
                    }
                    n2 = string.indexOf(46, n2 + 1);
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_4 = null;
            this.InCheck.release();
            throw throwable;
        }
        Object var7_3 = null;
        this.InCheck.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkPackageDefinition(String string) {
        try {
            this.InCheck.acquire();
            Object var3_2 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.InCheck.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkSetFactory() {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && this.inApplet() && !this.isSecureLoader()) {
                throw new SandboxSecurityException("cannotsetfactory");
            }
            Object var2_1 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.InCheck.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkMemberAccess(Class clazz, int n) {
        try {
            ClassLoader classLoader;
            this.InCheck.acquire();
            if (this.bCheckSecurity && !this.isSecureLoader() && n != 0 && (classLoader = this.currentClassLoader()) != null && this.classLoaderDepth() <= 3 && classLoader != clazz.getClassLoader()) {
                throw new SandboxSecurityException("checkmemberaccess");
            }
            Object var5_4 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.InCheck.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkPrintJobAccess() {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && this.inApplet() && !this.isSecureLoader()) {
                throw new SandboxSecurityException("checkgetprintjob");
            }
            Object var2_1 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.InCheck.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkSystemClipboardAccess() {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && this.inApplet() && !this.isSecureLoader()) {
                throw new SandboxSecurityException("checksystemclipboardaccess");
            }
            Object var2_1 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.InCheck.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkAwtEventQueueAccess() {
        try {
            this.InCheck.acquire();
            if (!(this.bCheckSecurity && this.inClassLoader() && this.isSecureLoader())) {
                // empty if block
            }
            Object var2_1 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.InCheck.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkSecurityAccess(String string) {
        try {
            this.InCheck.acquire();
            if (this.bCheckSecurity && this.inApplet() && !this.isSecureLoader()) {
                throw new SandboxSecurityException("checksecurityaccess", string);
            }
            Object var3_2 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.InCheck.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ThreadGroup getThreadGroup() {
        ThreadGroup threadGroup = null;
        try {
            this.InCheck.acquire();
            ClassLoader classLoader = this.currentClassLoader();
            if (classLoader != null && classLoader instanceof ClassContextImpl) {
                if (this.inThreadGroup(Thread.currentThread())) {
                    threadGroup = Thread.currentThread().getThreadGroup();
                } else {
                    ClassContextImpl classContextImpl = (ClassContextImpl)classLoader;
                    threadGroup = classContextImpl.getThreadGroup();
                }
            } else {
                threadGroup = super.getThreadGroup();
            }
            Object var5_4 = null;
            this.InCheck.release();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.InCheck.release();
            throw throwable;
        }
        return threadGroup;
    }

    public void debug(String string) {
        if (debug) {
            System.err.println(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean isSecureLoader() {
        this.InIsSecureLoader.acquire();
        try {
            boolean bl = false;
            ClassLoader classLoader = this.currentClassLoader();
            bl = classLoader != null ? (classLoader instanceof ClassContextImpl ? !((ClassContextImpl)classLoader).checkSecurity() : true) : true;
            boolean bl2 = bl;
            Object var5_4 = null;
            this.InIsSecureLoader.release();
            return bl2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.InIsSecureLoader.release();
            throw throwable;
        }
    }

    public synchronized void checkPermission(Permission permission) {
        if ((this.InIsSecureLoader.inRecursion() || this.InInClassLoader.inRecursion() || this.InClassLoaderDepth.inRecursion()) && permission.implies(this.allPerm)) {
            throw new SandboxSecurityException("checkPermission ", permission.toString());
        }
        if (!this.InCheck.inRecursion() && !this.isSecureLoader()) {
            throw new SandboxSecurityException("checkPermission ", permission.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean inClassLoader() {
        this.InInClassLoader.acquire();
        try {
            boolean bl = super.inClassLoader();
            Object var3_2 = null;
            this.InInClassLoader.release();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.InInClassLoader.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int classLoaderDepth() {
        this.InClassLoaderDepth.acquire();
        try {
            int n = super.classLoaderDepth();
            Object var3_2 = null;
            this.InClassLoaderDepth.release();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.InClassLoaderDepth.release();
            throw throwable;
        }
    }
}

