/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.reference;

import org.alfresco.cmis.CMISObjectReference;
import org.alfresco.cmis.CMISRepositoryReference;
import org.alfresco.cmis.CMISServiceException;
import org.alfresco.cmis.CMISServices;
import org.alfresco.repo.cmis.reference.AbstractRepositoryReference;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.springframework.extensions.webscripts.WebScriptException;

public class ObjectIdReference
implements CMISObjectReference {
    private CMISServices cmisServices;
    private String objectId;

    public ObjectIdReference(CMISServices cmisServices, String objectId) {
        this.cmisServices = cmisServices;
        this.objectId = objectId;
    }

    public NodeRef getNodeRef() {
        try {
            return (NodeRef)this.cmisServices.getReadableObject(this.objectId, NodeRef.class);
        }
        catch (CMISServiceException e) {
            throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
        }
    }

    public CMISRepositoryReference getRepositoryReference() {
        return new AbstractRepositoryReference(this.cmisServices){

            public StoreRef getStoreRef() {
                return ObjectIdReference.this.getNodeRef().getStoreRef();
            }
        };
    }

    public String toString() {
        return "ObjectIdReference[objectId=" + this.objectId + "]";
    }
}

