/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.rest.test;

import java.util.HashMap;
import java.util.List;
import org.alfresco.repo.cmis.rest.test.BaseCMISTest;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.chemistry.abdera.ext.CMISConstants;
import org.apache.chemistry.abdera.ext.CMISTypeDefinition;
import org.junit.Assert;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class PolicyTest
extends BaseCMISTest {
    public void testPolicies() throws Exception {
        Link children = this.cmisClient.getChildrenLink(this.testCaseFolder);
        this.createObject(children.getHref(), this.getName(), "cmis:policy", 409);
        IRI typesHREF = this.cmisClient.getTypesChildrenCollection(this.cmisClient.getWorkspace(this.cmisService));
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("typeId", "cmis:policy");
        args.put("includePropertyDefinitions", "true");
        Feed types = (Feed)this.fetch(typesHREF, args);
        List entries = types.getEntries();
        PolicyTest.assertNotSame((Object)0, (Object)entries.size());
        for (Entry type : entries) {
            CMISTypeDefinition entryType = (CMISTypeDefinition)type.getExtension(CMISConstants.TYPE_DEFINITION);
            Assert.assertNotNull((Object)entryType);
            this.createObject(children.getHref(), this.getName(), entryType.getId(), 409);
        }
        Entry document = this.createObject(children.getHref(), this.getName(), "cmis:document");
        Link polsLink = document.getLink("http://docs.oasis-open.org/ns/cmis/link/200908/policies");
        PolicyTest.assertNotNull((Object)polsLink);
        Feed polsBefore = (Feed)this.fetch(polsLink.getHref(), null);
        PolicyTest.assertNotNull((Object)polsBefore);
        PolicyTest.assertEquals((int)0, (int)polsBefore.getEntries().size());
        String policyFile = this.localTemplates.load("PolicyTest.applyPolicy.atomentry.xml");
        policyFile = policyFile.replace("${OBJECTID}", "doesnotexist");
        TestWebScriptServer.PostRequest req = new TestWebScriptServer.PostRequest(polsLink.getHref().toString(), policyFile, "application/atom+xml;type=entry");
        this.sendRequest((TestWebScriptServer.Request)req, 409);
    }
}

