/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.ws;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.jws.WebService;
import org.alfresco.cmis.CMISInvalidArgumentException;
import org.alfresco.cmis.CMISRelationshipDirectionEnum;
import org.alfresco.cmis.CMISServiceException;
import org.alfresco.cmis.CMISTypesFilterEnum;
import org.alfresco.cmis.PropertyFilter;
import org.alfresco.repo.cmis.ws.CmisException;
import org.alfresco.repo.cmis.ws.CmisExtensionType;
import org.alfresco.repo.cmis.ws.CmisObjectInFolderContainerType;
import org.alfresco.repo.cmis.ws.CmisObjectInFolderListType;
import org.alfresco.repo.cmis.ws.CmisObjectInFolderType;
import org.alfresco.repo.cmis.ws.CmisObjectListType;
import org.alfresco.repo.cmis.ws.CmisObjectParentsType;
import org.alfresco.repo.cmis.ws.CmisObjectType;
import org.alfresco.repo.cmis.ws.DMAbstractServicePort;
import org.alfresco.repo.cmis.ws.EnumIncludeRelationships;
import org.alfresco.repo.cmis.ws.EnumServiceException;
import org.alfresco.repo.cmis.ws.NavigationServicePort;
import org.alfresco.repo.cmis.ws.utils.ExceptionUtil;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.util.paging.Cursor;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(name="NavigationServicePort", serviceName="NavigationService", portName="NavigationServicePort", targetNamespace="http://docs.oasis-open.org/ns/cmis/ws/200908/", endpointInterface="org.alfresco.repo.cmis.ws.NavigationServicePort")
public class DMNavigationServicePort
extends DMAbstractServicePort
implements NavigationServicePort {
    private static final int EQUALS_CONDITION_VALUE = 0;
    private static final BigInteger FULL_DESCENDANTS_HIERARCHY_CONDITION = BigInteger.valueOf(-1L);
    private static final String FILTER_TOKENS_DELIMETER = ", ";

    @Override
    public CmisObjectListType getCheckedOutDocs(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, CmisExtensionType extension) throws CmisException {
        this.checkRepositoryId(repositoryId);
        PropertyFilter propertyFilter = this.createPropertyFilter(filter);
        try {
            NodeRef folderRef = null;
            if (folderId != null && !folderId.equals("")) {
                folderRef = this.cmisService.getFolder(folderId);
            }
            NodeRef[] nodeRefs = this.cmisService.getCheckedOut(AuthenticationUtil.getFullyAuthenticatedUser(), folderRef, folderRef == null, orderBy);
            Cursor cursor = this.createCursor(nodeRefs.length, skipCount, maxItems);
            CmisObjectListType result = new CmisObjectListType();
            List<CmisObjectType> resultListing = result.getObjects();
            for (int index = cursor.getStartRow(); index <= cursor.getEndRow(); ++index) {
                resultListing.add(this.createCmisObject((Object)nodeRefs[index], propertyFilter, includeRelationships, includeAllowableActions, renditionFilter));
            }
            result.setHasMoreItems(new Boolean(cursor.getEndRow() < nodeRefs.length - 1));
            return result;
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
    }

    @Override
    public CmisObjectInFolderListType getChildren(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegments, BigInteger maxItems, BigInteger skipCount, CmisExtensionType extension) throws CmisException {
        this.checkRepositoryId(repositoryId);
        PropertyFilter propertyFilter = this.createPropertyFilter(filter);
        try {
            NodeRef folderNodeRef = this.cmisService.getFolder(folderId);
            NodeRef[] listing = this.cmisService.getChildren(folderNodeRef, CMISTypesFilterEnum.ANY, orderBy);
            CmisObjectInFolderListType result = new CmisObjectInFolderListType();
            Cursor cursor = this.createCursor(listing.length, skipCount, maxItems);
            for (int index = cursor.getStartRow(); index <= cursor.getEndRow(); ++index) {
                CmisObjectType cmisObject = this.createCmisObject((Object)listing[index], propertyFilter, includeRelationships, includeAllowableActions, renditionFilter);
                CmisObjectInFolderType cmisObjectInFolder = new CmisObjectInFolderType();
                cmisObjectInFolder.setObject(cmisObject);
                if (includePathSegments != null && includePathSegments.booleanValue()) {
                    cmisObjectInFolder.setPathSegment(this.propertiesUtil.getProperty(listing[index], "cmis:name", ""));
                }
                result.getObjects().add(cmisObjectInFolder);
            }
            result.setHasMoreItems(cursor.getEndRow() < listing.length - 1);
            result.setNumItems(BigInteger.valueOf(listing.length));
            return result;
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
    }

    @Override
    public List<CmisObjectInFolderContainerType> getDescendants(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegments, CmisExtensionType extension) throws CmisException {
        CmisObjectInFolderContainerType objectInFolderContainerType = this.getDescendantsTree(repositoryId, folderId, depth, filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegments, CMISTypesFilterEnum.ANY);
        return objectInFolderContainerType.getChildren();
    }

    @Override
    public List<CmisObjectInFolderContainerType> getFolderTree(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegments, CmisExtensionType extension) throws CmisException {
        CmisObjectInFolderContainerType objectInFolderContainerType = this.getDescendantsTree(repositoryId, folderId, depth, filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegments, CMISTypesFilterEnum.FOLDERS);
        return objectInFolderContainerType.getChildren();
    }

    @Override
    public CmisObjectType getFolderParent(String repositoryId, String folderId, String filter, CmisExtensionType extension) throws CmisException {
        NodeRef parentRef;
        this.checkRepositoryId(repositoryId);
        if (filter != null && !filter.equals("") && !filter.equals("*")) {
            if (!filter.contains("cmis:parentId")) {
                filter = "cmis:parentId, " + filter;
            }
            if (!filter.contains("cmis:objectId")) {
                filter = "cmis:objectId, " + filter;
            }
        }
        PropertyFilter propertyFilter = this.createPropertyFilter(filter);
        try {
            parentRef = this.cmisService.getFolderParent(folderId);
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
        CmisObjectType result = this.createCmisObject((Object)parentRef, propertyFilter, (CMISRelationshipDirectionEnum)null, false, (String)null);
        return result;
    }

    @Override
    public List<CmisObjectParentsType> getObjectParents(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includeRelativePathSegment, CmisExtensionType extension) throws CmisException {
        this.checkRepositoryId(repositoryId);
        PropertyFilter propertyFilter = this.createPropertyFilter(filter);
        try {
            NodeRef childNode = (NodeRef)this.cmisService.getReadableObject(objectId, NodeRef.class);
            List<NodeRef> parents = this.receiveObjectParents(childNode);
            ArrayList<CmisObjectParentsType> result = new ArrayList<CmisObjectParentsType>();
            String relativePathSegment = this.propertiesUtil.getProperty(childNode, "cmis:name", "");
            for (NodeRef objectNodeRef : parents) {
                CmisObjectType cmisObject = this.createCmisObject((Object)objectNodeRef, propertyFilter, includeRelationships, includeAllowableActions, renditionFilter);
                CmisObjectParentsType cmisObjectParentsType = new CmisObjectParentsType();
                cmisObjectParentsType.setObject(cmisObject);
                if (includeRelativePathSegment != null && includeRelativePathSegment.booleanValue()) {
                    cmisObjectParentsType.setRelativePathSegment(relativePathSegment);
                }
                result.add(cmisObjectParentsType);
            }
            return result;
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
    }

    private CmisObjectInFolderContainerType getDescendantsTree(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegments, CMISTypesFilterEnum types) throws CmisException {
        this.checkRepositoryId(repositoryId);
        PropertyFilter propertyFilter = this.createPropertyFilter(filter);
        depth = depth == null ? BigInteger.ONE.add(BigInteger.ONE) : depth;
        depth = depth.equals(BigInteger.valueOf(-1L)) ? BigInteger.valueOf(Integer.MAX_VALUE) : depth;
        long maxDepth = depth.longValue();
        this.checkDepthParameter(depth);
        try {
            NodeRef[] children;
            NodeRef folderNodeRef = this.cmisService.getFolder(folderId);
            Stack<RecursiveElement> descedantsStack = new Stack<RecursiveElement>();
            CmisObjectInFolderContainerType objectInFolderContainer = this.createObjectInFolderContainer(folderNodeRef, propertyFilter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegments);
            for (NodeRef childRef : children = this.cmisService.getChildren(folderNodeRef, types, null)) {
                descedantsStack.push(new RecursiveElement(objectInFolderContainer, 1, childRef));
            }
            while (!descedantsStack.isEmpty()) {
                RecursiveElement element = (RecursiveElement)descedantsStack.pop();
                CmisObjectInFolderContainerType currentContainer = this.createObjectInFolderContainer(element.getCurrentNodeRef(), propertyFilter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegments);
                element.getParentContainerType().getChildren().add(currentContainer);
                if ((long)element.getDepth() > maxDepth || (children = this.cmisService.getChildren(element.getCurrentNodeRef(), types, null)) == null) continue;
                for (NodeRef childRef : children) {
                    descedantsStack.push(new RecursiveElement(currentContainer, element.getDepth() + 1, childRef));
                }
            }
            return objectInFolderContainer;
        }
        catch (CMISServiceException e) {
            throw ExceptionUtil.createCmisException(e);
        }
    }

    private CmisObjectInFolderContainerType createObjectInFolderContainer(NodeRef nodeRef, PropertyFilter filter, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegments) throws CmisException {
        CmisObjectType cmisObject = this.createCmisObject((Object)nodeRef, filter, includeRelationships, includeAllowableActions, renditionFilter);
        CmisObjectInFolderType objectInFolderType = new CmisObjectInFolderType();
        objectInFolderType.setObject(cmisObject);
        if (includePathSegments != null && includePathSegments.booleanValue()) {
            String path;
            try {
                path = this.propertiesUtil.getProperty(nodeRef, "cmis:name", "");
            }
            catch (CMISInvalidArgumentException e) {
                throw ExceptionUtil.createCmisException((CMISServiceException)((Object)e));
            }
            objectInFolderType.setPathSegment(path);
        }
        CmisObjectInFolderContainerType result = new CmisObjectInFolderContainerType();
        result.setObjectInFolder(objectInFolderType);
        return result;
    }

    private void checkDepthParameter(BigInteger depth) throws CmisException {
        if (depth.equals(BigInteger.ZERO) || depth.compareTo(FULL_DESCENDANTS_HIERARCHY_CONDITION) < 0) {
            throw ExceptionUtil.createCmisException("The specified descendants depth is not valid. Valid depth values are: -1 (full hierarchy), N > 0", EnumServiceException.INVALID_ARGUMENT);
        }
    }

    private List<NodeRef> receiveObjectParents(NodeRef objectId) throws CmisException {
        LinkedList<NodeRef> parents = new LinkedList<NodeRef>();
        for (ChildAssociationRef childParentAssociation : this.nodeService.getParentAssocs(objectId)) {
            NodeRef parentRef = childParentAssociation.getParentRef();
            if (parentRef.equals((Object)this.nodeService.getRootNode(parentRef.getStoreRef()))) continue;
            parents.add(parentRef);
        }
        return parents;
    }

    private class RecursiveElement {
        private CmisObjectInFolderContainerType parentContainerType;
        private int depth;
        private NodeRef currentNodeRef;

        public RecursiveElement(CmisObjectInFolderContainerType parentContainerType, int depth, NodeRef currentNodeRef) {
            this.parentContainerType = parentContainerType;
            this.depth = depth;
            this.currentNodeRef = currentNodeRef;
        }

        public CmisObjectInFolderContainerType getParentContainerType() {
            return this.parentContainerType;
        }

        public int getDepth() {
            return this.depth;
        }

        public NodeRef getCurrentNodeRef() {
            return this.currentNodeRef;
        }
    }
}

