/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts;

import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.PropertyMap;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class LoginTest
extends BaseWebScriptTest {
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private PersonService personService;
    private static final String USER_ONE = "AuthenticationTestOne";

    protected void setUp() throws Exception {
        super.setUp();
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("authenticationComponent");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.createUser(USER_ONE, USER_ONE);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private void createUser(String userName, String password) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, password.toCharArray());
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
            ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
            ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
            ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
            this.personService.createPerson((Map)ppOne);
        }
    }

    private String parseTicket(String ticketResult) {
        int startTag = ticketResult.indexOf("<ticket>");
        int endTag = ticketResult.indexOf("</ticket>");
        if (startTag != -1 && endTag != -1) {
            return ticketResult.substring(startTag + "<ticket>".length(), endTag);
        }
        return "";
    }

    public void testAuthentication() throws Exception {
        String loginURL = "/api/login?u=AuthenticationTestOne&pw=AuthenticationTestOne";
        TestWebScriptServer.Response resp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(loginURL), 200);
        String xmlFragment = resp.getContentAsString();
        LoginTest.assertNotNull((Object)"xmlFragment");
        LoginTest.assertTrue((String)"xmlFragment contains ticket", (boolean)xmlFragment.contains("<ticket>"));
        String ticket = this.parseTicket(xmlFragment);
        String ticketURL = "/api/login/ticket/" + ticket;
        this.setDefaultRunAs(AuthenticationUtil.getAdminUserName());
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(ticketURL), 404);
        this.setDefaultRunAs(USER_ONE);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(ticketURL), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(ticketURL), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(ticketURL), 404);
    }

    public void testAuthenticationGetJSON() throws Exception {
        String loginURL = "/api/login.json?u=AuthenticationTestOne&pw=AuthenticationTestOne";
        TestWebScriptServer.Response resp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(loginURL), 200);
        JSONObject result = new JSONObject(resp.getContentAsString());
        JSONObject data = result.getJSONObject("data");
        String ticket = data.getString("ticket");
        LoginTest.assertNotNull((String)"ticket is null", (Object)ticket);
        String login2URL = "/api/login?u=AuthenticationTestOne&pw=AuthenticationTestOne&format=json";
        TestWebScriptServer.Response resp2 = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(login2URL), 200);
        JSONObject result2 = new JSONObject(resp2.getContentAsString());
        JSONObject data2 = result2.getJSONObject("data");
        String ticket2 = data2.getString("ticket");
        LoginTest.assertNotNull((String)"ticket is null", (Object)ticket2);
    }

    public void testPostLogin() throws Exception {
        String loginURL = "/api/login";
        JSONObject req = new JSONObject();
        req.put("username", (Object)USER_ONE);
        req.put("password", (Object)USER_ONE);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(loginURL, req.toString(), "application/json"), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        JSONObject data = result.getJSONObject("data");
        String ticket = data.getString("ticket");
        LoginTest.assertNotNull((String)"ticket null", (Object)ticket);
        req = new JSONObject();
        req.put("username", (Object)USER_ONE);
        req.put("password", (Object)"blurb");
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(loginURL, req.toString(), "application/json"), 403);
        req = new JSONObject();
        req.put("password", (Object)USER_ONE);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(loginURL, req.toString(), "application/json"), 400);
        req = new JSONObject();
        req.put("username", (Object)USER_ONE);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(loginURL, req.toString(), "application/json"), 400);
    }

    public void testWrongPassword() throws Exception {
        String loginURL = "/api/login?u=AuthenticationTestOne&pw=crap";
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(loginURL), 403);
    }

    public void testMissingParameters() throws Exception {
        String loginURL = "/api/login?u=AuthenticationTestOne";
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(loginURL), 400);
        String login2URL = "/api/login?&pw=AuthenticationTestOne";
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(login2URL), 400);
    }
}

