/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.activities;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.SearchPath;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateWebScript
extends DeclarativeWebScript {
    protected static final Log logger = LogFactory.getLog(TemplateWebScript.class);
    private SearchPath searchPath;

    public void setSearchPath(SearchPath searchPath) {
        this.searchPath = searchPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        HashMap<String, Object> model;
        block9: {
            model = new HashMap<String, Object>();
            String path = req.getExtensionPath();
            if (path == null || path.length() == 0) {
                String msg = "Failed to getTemplate: missing {path}";
                logger.error((Object)msg);
                throw new AlfrescoRuntimeException(msg);
            }
            if (path.endsWith(".ftl")) {
                try {
                    InputStream is = this.searchPath.getDocument(path);
                    if (is == null) break block9;
                    BufferedReader br = null;
                    try {
                        br = new BufferedReader(new InputStreamReader(is));
                        String line = null;
                        StringBuffer sb = new StringBuffer();
                        while ((line = br.readLine()) != null) {
                            sb.append(line);
                        }
                        model.put("template", sb.toString());
                    }
                    finally {
                        if (br != null) {
                            br.close();
                        }
                    }
                }
                catch (IOException ioe) {
                    logger.error((Object)("Failed to getTemplate: " + ioe));
                }
            }
        }
        return model;
    }
}

