/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.content;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.cmis.CMISObjectReference;
import org.alfresco.cmis.CMISServiceException;
import org.alfresco.cmis.CMISServices;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cmis.reference.ObjectPathReference;
import org.alfresco.repo.cmis.reference.ReferenceFactory;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class ContentSet
extends AbstractWebScript {
    private static final Log logger = LogFactory.getLog(ContentSet.class);
    private ReferenceFactory referenceFactory;
    private DictionaryService dictionaryService;
    private NamespaceService namespaceService;
    private CMISServices cmisService;
    private MimetypeService mimetypeService;

    public void setReferenceFactory(ReferenceFactory referenceFactory) {
        this.referenceFactory = referenceFactory;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setCmisService(CMISServices cmisService) {
        this.cmisService = cmisService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        PropertyDefinition propertyDef;
        String[] names = req.getParameterNames();
        HashMap<String, String> args = new HashMap<String, String>(names.length, 1.0f);
        for (String name : names) {
            args.put(name, req.getParameter(name));
        }
        Map templateVars = req.getServiceMatch().getTemplateVars();
        CMISObjectReference reference = this.referenceFactory.createObjectReferenceFromUrl(args, templateVars);
        NodeRef nodeRef = reference.getNodeRef();
        if (nodeRef == null) {
            throw new WebScriptException(404, "Unable to find " + reference.toString());
        }
        QName propertyQName = ContentModel.PROP_CONTENT;
        String contentPart = (String)templateVars.get("property");
        if (contentPart.length() > 0 && contentPart.charAt(0) == ';') {
            if (contentPart.length() < 2) {
                throw new WebScriptException(400, "Content property malformed");
            }
            String propertyName = contentPart.substring(1);
            if (propertyName.length() > 0) {
                propertyQName = QName.createQName((String)propertyName, (NamespacePrefixResolver)this.namespaceService);
            }
        }
        if ((propertyDef = this.dictionaryService.getProperty(propertyQName)) == null) {
            throw new WebScriptException(404, "Unable to find content property " + propertyQName + " of " + reference.toString());
        }
        if (!propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT)) {
            throw new WebScriptException(404, "Content stream not found");
        }
        String overwrite = req.getParameter("overwriteFlag");
        String mimetype = req.getContentType();
        if (mimetype == null && reference instanceof ObjectPathReference) {
            mimetype = this.mimetypeService.guessMimetype(((ObjectPathReference)reference).getPath());
        }
        try {
            boolean isUpdate = this.cmisService.setContentStream((String)((Object)this.cmisService.getProperty(nodeRef, "cmis:objectId")), propertyQName, overwrite == null || overwrite.equals("true"), req.getContent().getInputStream(), mimetype);
            res.setStatus(isUpdate ? 200 : 201);
        }
        catch (CMISServiceException e) {
            throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
        }
    }
}

