/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.web.scripts.dictionary.DictionaryComparators;
import org.alfresco.repo.web.scripts.dictionary.DictionaryWebServiceBase;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesGet
extends DictionaryWebServiceBase {
    private static final String MODEL_PROP_KEY_PROPERTY_DETAILS = "propertydefs";
    private static final String DICTIONARY_CLASS_NAME = "classname";
    private static final String PARAM_NAME = "name";
    private static final String REQ_URL_TEMPL_VAR_NAMESPACE_PREFIX = "nsp";

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        QName classQName = null;
        String className = (String)req.getServiceMatch().getTemplateVars().get(DICTIONARY_CLASS_NAME);
        if (className != null && className.length() != 0 && (classQName = this.createClassQName(className)) == null) {
            throw new WebScriptException(404, "Check the className - " + className + " - parameter in the URL");
        }
        String[] names = req.getParameterValues(PARAM_NAME);
        String namespacePrefix = req.getParameter(REQ_URL_TEMPL_VAR_NAMESPACE_PREFIX);
        String namespaceURI = null;
        if (namespacePrefix != null) {
            namespaceURI = this.namespaceService.getNamespaceURI(namespacePrefix);
        }
        HashMap<QName, PropertyDefinition> propMap = null;
        if (classQName == null) {
            if (names != null) {
                propMap = new HashMap<QName, PropertyDefinition>(names.length);
                for (String name : names) {
                    QName propQName = QName.createQName((String)name, (NamespacePrefixResolver)this.namespaceService);
                    PropertyDefinition propDef = this.dictionaryservice.getProperty(propQName);
                    if (propDef == null) continue;
                    propMap.put(propQName, propDef);
                }
            } else {
                Collection propQNames = this.dictionaryservice.getAllProperties(null);
                propMap = new HashMap(propQNames.size());
                for (QName propQName : propQNames) {
                    propMap.put(propQName, this.dictionaryservice.getProperty(propQName));
                }
            }
        } else {
            propMap = this.dictionaryservice.getClass(classQName).getProperties();
        }
        ArrayList props = new ArrayList(propMap.size());
        for (Map.Entry entry : propMap.entrySet()) {
            if ((namespaceURI == null || !namespaceURI.equals(((QName)entry.getKey()).getNamespaceURI())) && namespaceURI != null) continue;
            props.add(entry.getValue());
        }
        Collections.sort(props, new DictionaryComparators.PropertyDefinitionComparator());
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(MODEL_PROP_KEY_PROPERTY_DETAILS, props);
        return model;
    }
}

