/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.web.scripts.dictionary.DictionaryComparators;
import org.alfresco.repo.web.scripts.dictionary.DictionaryWebServiceBase;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubClassesGet
extends DictionaryWebServiceBase {
    private static final String MODEL_PROP_KEY_CLASS_DEFS = "classdefs";
    private static final String MODEL_PROP_KEY_PROPERTY_DETAILS = "propertydefs";
    private static final String MODEL_PROP_KEY_ASSOCIATION_DETAILS = "assocdefs";
    private static final String REQ_URL_TEMPL_IMMEDIATE_SUB_TYPE_CHILDREN = "r";
    private static final String REQ_URL_TEMPL_VAR_NAMESPACE_PREFIX = "nsp";
    private static final String REQ_URL_TEMPL_VAR_NAME = "n";
    private static final String DICTIONARY_CLASS_NAME = "classname";

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        String name = req.getParameter(REQ_URL_TEMPL_VAR_NAME);
        String namespacePrefix = req.getParameter(REQ_URL_TEMPL_VAR_NAMESPACE_PREFIX);
        String className = (String)req.getServiceMatch().getTemplateVars().get(DICTIONARY_CLASS_NAME);
        String recursiveValue = this.getValidInput(req.getParameter(REQ_URL_TEMPL_IMMEDIATE_SUB_TYPE_CHILDREN));
        boolean recursive = true;
        HashMap<QName, ClassDefinition> classdef = new HashMap<QName, ClassDefinition>();
        HashMap propdef = new HashMap();
        HashMap assocdef = new HashMap();
        HashMap<String, Object> model = new HashMap<String, Object>();
        QName classQName = null;
        String namespaceUri = null;
        Collection qname = null;
        boolean isAspect = false;
        boolean ignoreCheck = false;
        if (recursiveValue == null) {
            recursive = true;
        } else if (recursiveValue.equalsIgnoreCase("true")) {
            recursive = true;
        } else if (recursiveValue.equalsIgnoreCase("false")) {
            recursive = false;
        } else {
            throw new WebScriptException(404, "Check the value for the parameter recursive=> " + recursiveValue + "  can only be either true or false");
        }
        if (this.isValidClassname(className)) {
            classQName = QName.createQName((String)this.getFullNamespaceURI(className));
            if (this.isValidTypeorAspect(className)) {
                isAspect = true;
            }
        } else {
            throw new WebScriptException(404, "Check the className - " + className + " parameter in the URL");
        }
        qname = isAspect ? this.dictionaryservice.getSubAspects(classQName, recursive) : this.dictionaryservice.getSubTypes(classQName, recursive);
        if (name != null && !this.isValidModelName(name)) {
            throw new WebScriptException(404, "Check the name parameter - " + name + " in the URL");
        }
        if (namespacePrefix == null && name != null) {
            namespaceUri = this.namespaceService.getNamespaceURI(this.getPrefixFromModelName(name));
        }
        if (namespacePrefix != null && name == null) {
            namespaceUri = this.namespaceService.getNamespaceURI(namespacePrefix);
        }
        if (namespacePrefix == null && name == null) {
            namespaceUri = null;
            ignoreCheck = true;
        }
        if (namespacePrefix != null && name != null) {
            if (!this.isValidClassname(namespacePrefix + "_" + name)) {
                throw new WebScriptException(404, "Check the namespacePrefix - " + namespacePrefix + " and name - " + name + " - parameter in the URL");
            }
            namespaceUri = this.namespaceService.getNamespaceURI(namespacePrefix);
        }
        for (QName qnameObj : qname) {
            if (!ignoreCheck && !qnameObj.getNamespaceURI().equals(namespaceUri)) continue;
            classdef.put(qnameObj, this.dictionaryservice.getClass(qnameObj));
            propdef.put(qnameObj, this.dictionaryservice.getClass(qnameObj).getProperties().values());
            assocdef.put(qnameObj, this.dictionaryservice.getClass(qnameObj).getAssociations().values());
        }
        ArrayList classDefinitions = new ArrayList(classdef.values());
        Collections.sort(classDefinitions, new DictionaryComparators.ClassDefinitionComparator());
        model.put(MODEL_PROP_KEY_CLASS_DEFS, classDefinitions);
        model.put(MODEL_PROP_KEY_PROPERTY_DETAILS, propdef.values());
        model.put(MODEL_PROP_KEY_ASSOCIATION_DETAILS, assocdef.values());
        return model;
    }
}

