/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.facebook;

import java.io.IOException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.facebook.FacebookServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Authenticator;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.servlet.ServletAuthenticatorFactory;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;
import org.springframework.extensions.webscripts.servlet.WebScriptServletResponse;

public class FacebookAuthenticatorFactory
implements ServletAuthenticatorFactory {
    private static final Log logger = LogFactory.getLog(FacebookAuthenticator.class);

    public Authenticator create(WebScriptServletRequest req, WebScriptServletResponse res) {
        if (!(req instanceof FacebookServletRequest)) {
            throw new WebScriptException("Facebook request is required; instead a " + req.getClass().getName() + " has been provided");
        }
        return new FacebookAuthenticator((FacebookServletRequest)req, res);
    }

    public class FacebookAuthenticator
    implements Authenticator {
        private static final String LOGIN_REDIRECT = "<fb:redirect url=\"http://www.facebook.com/login.php?api_key=%s&v=1.0%s\">";
        private FacebookServletRequest fbReq;
        private WebScriptServletResponse fbRes;
        private String sessionKey;
        private String user;

        public FacebookAuthenticator(FacebookServletRequest req, WebScriptServletResponse res) {
            this.fbReq = req;
            this.fbRes = res;
            this.sessionKey = this.fbReq.getSessionKey();
            this.user = this.fbReq.getUserId();
        }

        public boolean authenticate(Description.RequiredAuthentication required, boolean isGuest) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("fb_sig_session_key = '" + this.sessionKey + "'"));
                logger.debug((Object)("fb_sig_user = '" + this.user + "'"));
            }
            if (this.emptyCredentials()) {
                String canvas;
                String apiKey = this.fbReq.getApiKey();
                String string = canvas = this.fbReq.isInCanvas() ? "&canvas" : "";
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("fb_sig_api_key = '" + apiKey + "'"));
                    logger.debug((Object)("fb_sig_in_canvas = '" + canvas + "'"));
                }
                try {
                    String redirect = String.format(LOGIN_REDIRECT, apiKey, canvas);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Facebook session not established; redirecting via " + redirect));
                    }
                    this.fbRes.getWriter().write(redirect);
                }
                catch (IOException e) {
                    throw new WebScriptException("Redirect to login failed", (Throwable)e);
                }
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Facebook session established; authenticating as user " + this.user));
            }
            AuthenticationUtil.setFullyAuthenticatedUser((String)this.user);
            return true;
        }

        public boolean emptyCredentials() {
            return this.sessionKey == null || this.sessionKey.length() == 0 || this.user == null || this.user.length() == 0;
        }
    }
}

