/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.rule;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.action.ActionConditionImpl;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.CompositeActionImpl;
import org.alfresco.repo.web.scripts.rule.RulePost;
import org.alfresco.repo.web.scripts.rule.ruleset.RuleRef;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.rule.Rule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulePut
extends RulePost {
    private static Log logger = LogFactory.getLog(RulePut.class);

    @Override
    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        NodeRef nodeRef = this.parseRequestForNodeRef(req);
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String ruleId = (String)templateVars.get("rule_id");
        Rule ruleToUpdate = null;
        List rules = this.ruleService.getRules(nodeRef);
        for (Rule rule : rules) {
            if (!rule.getNodeRef().getId().equalsIgnoreCase(ruleId)) continue;
            ruleToUpdate = rule;
            break;
        }
        if (ruleToUpdate == null) {
            throw new WebScriptException(404, "Unable to find rule with id: " + ruleId);
        }
        JSONObject json = null;
        try {
            json = new JSONObject(new JSONTokener(req.getContent().getContent()));
            this.updateRuleFromJSON(json, ruleToUpdate);
            this.ruleService.saveRule(nodeRef, ruleToUpdate);
            RuleRef updatedRuleRef = new RuleRef(ruleToUpdate, this.fileFolderService.getFileInfo(this.ruleService.getOwningNodeRef(ruleToUpdate)));
            model.put("ruleRef", updatedRuleRef);
        }
        catch (IOException iox) {
            throw new WebScriptException(400, "Could not read content from req.", (Throwable)iox);
        }
        catch (JSONException je) {
            throw new WebScriptException(400, "Could not parse JSON from req.", (Throwable)je);
        }
        return model;
    }

    protected void updateRuleFromJSON(JSONObject jsonRule, Rule ruleToUpdate) throws JSONException {
        if (jsonRule.has("title")) {
            ruleToUpdate.setTitle(jsonRule.getString("title"));
        }
        if (jsonRule.has("description")) {
            ruleToUpdate.setDescription(jsonRule.getString("description"));
        }
        if (jsonRule.has("ruleType")) {
            JSONArray jsonTypes = jsonRule.getJSONArray("ruleType");
            ArrayList<String> types = new ArrayList<String>();
            for (int i = 0; i < jsonTypes.length(); ++i) {
                types.add(jsonTypes.getString(i));
            }
            ruleToUpdate.setRuleTypes(types);
        }
        if (jsonRule.has("applyToChildren")) {
            ruleToUpdate.applyToChildren(jsonRule.getBoolean("applyToChildren"));
        }
        if (jsonRule.has("executeAsynchronously")) {
            ruleToUpdate.setExecuteAsynchronously(jsonRule.getBoolean("executeAsynchronously"));
        }
        if (jsonRule.has("disabled")) {
            ruleToUpdate.setRuleDisabled(jsonRule.getBoolean("disabled"));
        }
        if (jsonRule.has("action")) {
            JSONObject jsonAction = jsonRule.getJSONObject("action");
            Action action = this.updateActionFromJson(jsonAction, (ActionImpl)ruleToUpdate.getAction());
            ruleToUpdate.setAction(action);
        }
    }

    protected Action updateActionFromJson(JSONObject jsonAction, ActionImpl actionToUpdate) throws JSONException {
        ActionImpl result = null;
        if (!jsonAction.has("id")) {
            result = this.parseJsonAction(jsonAction);
            return result;
        }
        result = actionToUpdate;
        if (jsonAction.has("description")) {
            result.setDescription(jsonAction.getString("description"));
        }
        if (jsonAction.has("title")) {
            result.setTitle(jsonAction.getString("title"));
        }
        if (jsonAction.has("parameterValues")) {
            JSONObject jsonParameterValues = jsonAction.getJSONObject("parameterValues");
            result.setParameterValues(this.parseJsonParameterValues(jsonParameterValues, result.getActionDefinitionName(), true));
        }
        if (jsonAction.has("executeAsync")) {
            result.setExecuteAsynchronously(jsonAction.getBoolean("executeAsync"));
        }
        if (jsonAction.has("runAsUser")) {
            result.setRunAsUser(jsonAction.getString("runAsUser"));
        }
        if (jsonAction.has("actions")) {
            JSONArray jsonActions = jsonAction.getJSONArray("actions");
            if (jsonActions.length() == 0) {
                ((CompositeActionImpl)result).getActions().clear();
            } else {
                List existingActions = ((CompositeActionImpl)result).getActions();
                ArrayList<Object> newActions = new ArrayList<Object>();
                for (int i = 0; i < jsonActions.length(); ++i) {
                    JSONObject jSONObject = jsonActions.getJSONObject(i);
                    if (jSONObject.has("id")) {
                        String actionId = jSONObject.getString("id");
                        Action existingAction = this.getAction(existingActions, actionId);
                        existingActions.remove(existingAction);
                        Action updatedAction = this.updateActionFromJson(jSONObject, (ActionImpl)existingAction);
                        newActions.add(updatedAction);
                        continue;
                    }
                    newActions.add(this.parseJsonAction(jSONObject));
                }
                existingActions.clear();
                for (Action action : newActions) {
                    existingActions.add(action);
                }
            }
        }
        if (jsonAction.has("conditions")) {
            JSONArray jsonConditions = jsonAction.getJSONArray("conditions");
            if (jsonConditions.length() == 0) {
                result.getActionConditions().clear();
            } else {
                List existingConditions = result.getActionConditions();
                ArrayList<Object> newConditions = new ArrayList<Object>();
                for (int i = 0; i < jsonConditions.length(); ++i) {
                    JSONObject jSONObject = jsonConditions.getJSONObject(i);
                    if (jSONObject.has("id")) {
                        String conditionId = jSONObject.getString("id");
                        ActionCondition existingCondition = this.getCondition(existingConditions, conditionId);
                        existingConditions.remove(existingCondition);
                        ActionCondition updatedActionCondition = this.updateActionConditionFromJson(jSONObject, (ActionConditionImpl)existingCondition);
                        newConditions.add(updatedActionCondition);
                        continue;
                    }
                    newConditions.add(this.parseJsonActionCondition(jSONObject));
                }
                existingConditions.clear();
                for (ActionCondition actionCondition : newConditions) {
                    existingConditions.add(actionCondition);
                }
            }
        }
        if (jsonAction.has("compensatingAction")) {
            JSONObject jsonCompensatingAction = jsonAction.getJSONObject("compensatingAction");
            Action compensatingAction = this.updateActionFromJson(jsonCompensatingAction, (ActionImpl)actionToUpdate.getCompensatingAction());
            actionToUpdate.setCompensatingAction(compensatingAction);
        }
        return result;
    }

    protected ActionCondition updateActionConditionFromJson(JSONObject jsonCondition, ActionConditionImpl conditionToUpdate) throws JSONException {
        ActionConditionImpl result = null;
        if (!jsonCondition.has("id")) {
            result = this.parseJsonActionCondition(jsonCondition);
            return result;
        }
        result = conditionToUpdate;
        if (jsonCondition.has("invertCondition")) {
            result.setInvertCondition(jsonCondition.getBoolean("invertCondition"));
        }
        if (jsonCondition.has("parameterValues")) {
            JSONObject jsonParameterValues = jsonCondition.getJSONObject("parameterValues");
            result.setParameterValues(this.parseJsonParameterValues(jsonParameterValues, result.getActionConditionDefinitionName(), false));
        }
        return result;
    }

    private Action getAction(List<Action> actions, String id) {
        Action result = null;
        for (Action action : actions) {
            if (!action.getId().equalsIgnoreCase(id)) continue;
            result = action;
            break;
        }
        return result;
    }

    private ActionCondition getCondition(List<ActionCondition> conditions, String id) {
        ActionCondition result = null;
        for (ActionCondition \u0441ondition : conditions) {
            if (!\u0441ondition.getId().equalsIgnoreCase(id)) continue;
            result = \u0441ondition;
            break;
        }
        return result;
    }
}

