/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.workflow;

import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.person.TestPersonManager;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowNode;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.cmr.workflow.WorkflowTransition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.util.ISO8601DateFormat;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class WorkflowRestApiTest
extends BaseWebScriptTest {
    private static final String USER1 = "Bob" + GUID.generate();
    private static final String USER2 = "Jane" + GUID.generate();
    private static final String USER3 = "Nick" + GUID.generate();
    private static final String URL_TASKS = "api/task-instances";
    private static final String URL_USER_TASKS = "api/task-instances?authority={0}";
    private static final String URL_WORKFLOW_TASKS = "api/workflow-instances/{0}/task-instances";
    private static final String URL_WORKFLOW_DEFINITIONS = "api/workflow-definitions";
    private static final String URL_WORKFLOW_INSTANCES = "api/workflow-instances";
    private static final String URL_WORKFLOW_INSTANCES_FOR_DEFINITION = "api/workflow-definitions/{0}/workflow-instances";
    private static final String URL_WORKFLOW_INSTANCES_FOR_NODE = "api/node/{0}/{1}/{2}/workflow-instances";
    private static final String COMPANY_HOME = "/app:company_home";
    private static final String TEST_CONTENT = "TestContent";
    private TestPersonManager personManager;
    private WorkflowService workflowService;
    private NodeService nodeService;
    private NamespaceService namespaceService;
    private NodeRef packageRef;
    private NodeRef contentNodeRef;

    public void testTaskInstancesGet() throws Exception {
        this.personManager.setUser(USER2);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_USER_TASKS, USER2)), 200);
        WorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        String jsonStr = response.getContentAsString();
        JSONObject json = new JSONObject(jsonStr);
        JSONArray results = json.getJSONArray("data");
        WorkflowRestApiTest.assertNotNull((Object)results);
        WorkflowRestApiTest.assertTrue((results.length() == 0 ? 1 : 0) != 0);
        this.personManager.setUser(USER1);
        WorkflowDefinition adhocDef = this.workflowService.getDefinitionByName("jbpm$wf:adhoc");
        HashMap<QName, Object> params = new HashMap<QName, Object>();
        params.put(WorkflowModel.ASSOC_ASSIGNEE, this.personManager.get(USER2));
        Date dueDate = new Date();
        params.put(WorkflowModel.PROP_DUE_DATE, dueDate);
        params.put(WorkflowModel.PROP_PRIORITY, 1);
        params.put(WorkflowModel.ASSOC_PACKAGE, this.packageRef);
        WorkflowPath adhocPath = this.workflowService.startWorkflow(adhocDef.id, params);
        WorkflowTask startTask = (WorkflowTask)this.workflowService.getTasksForWorkflowPath(adhocPath.id).get(0);
        this.workflowService.endTask(startTask.id, null);
        List tasks = this.workflowService.getAssignedTasks(USER2, WorkflowTaskState.IN_PROGRESS);
        WorkflowTask task = (WorkflowTask)tasks.get(0);
        HashMap<QName, Date> updateParams = new HashMap<QName, Date>(1);
        updateParams.put(WorkflowModel.PROP_DUE_DATE, new Date());
        this.workflowService.updateTask(task.getId(), updateParams, null, null);
        this.personManager.setUser(USER2);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_USER_TASKS, USER2)), 200);
        WorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        WorkflowRestApiTest.assertNotNull((Object)results);
        WorkflowRestApiTest.assertTrue((results.length() == tasks.size() ? 1 : 0) != 0);
        JSONObject result = results.getJSONObject(0);
        int totalItems = results.length();
        String expUrl = "api/task-instances/" + task.id;
        WorkflowRestApiTest.assertEquals((String)expUrl, (String)result.getString("url"));
        WorkflowRestApiTest.assertEquals((String)task.name, (String)result.getString("name"));
        WorkflowRestApiTest.assertEquals((String)task.title, (String)result.getString("title"));
        WorkflowRestApiTest.assertEquals((String)task.description, (String)result.getString("description"));
        WorkflowRestApiTest.assertEquals((String)task.state.name(), (String)result.getString("state"));
        WorkflowRestApiTest.assertEquals((String)("api/workflow-paths/" + adhocPath.getId()), (String)result.getString("path"));
        WorkflowRestApiTest.assertFalse((boolean)result.getBoolean("isPooled"));
        WorkflowRestApiTest.assertTrue((boolean)result.getBoolean("isEditable"));
        WorkflowRestApiTest.assertTrue((boolean)result.getBoolean("isReassignable"));
        WorkflowRestApiTest.assertFalse((boolean)result.getBoolean("isClaimable"));
        WorkflowRestApiTest.assertFalse((boolean)result.getBoolean("isReleasable"));
        JSONObject owner = result.getJSONObject("owner");
        WorkflowRestApiTest.assertEquals((String)USER2, (String)owner.getString("userName"));
        WorkflowRestApiTest.assertEquals((String)this.personManager.getFirstName(USER2), (String)owner.getString("firstName"));
        WorkflowRestApiTest.assertEquals((String)this.personManager.getLastName(USER2), (String)owner.getString("lastName"));
        JSONObject properties = result.getJSONObject("properties");
        WorkflowRestApiTest.assertNotNull((Object)properties);
        JSONObject instance = result.getJSONObject("workflowInstance");
        WorkflowRestApiTest.assertNotNull((Object)instance);
        this.checkFiltering("api/task-instances?priority=2");
        int maxItems = 3;
        for (int skipCount = 0; skipCount < totalItems; skipCount += maxItems) {
            this.checkPaging(MessageFormat.format(URL_USER_TASKS, USER2) + "&maxItems=" + maxItems + "&skipCount=" + skipCount, totalItems, maxItems, skipCount);
        }
        this.checkPaging(MessageFormat.format(URL_USER_TASKS, USER2) + "&maxItems=" + maxItems + "&skipCount=" + (totalItems + 1), totalItems, maxItems, totalItems + 1);
        String exclude = "wf:submitAdhocTask";
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/task-instances?exclude=" + exclude), 200);
        WorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        WorkflowRestApiTest.assertNotNull((Object)results);
        boolean adhocTasksPresent = false;
        for (int i = 0; i < results.length(); ++i) {
            JSONObject taskJSON = results.getJSONObject(i);
            String type = taskJSON.getString("name");
            if (!exclude.equals(type)) continue;
            adhocTasksPresent = true;
            break;
        }
        WorkflowRestApiTest.assertFalse((String)"Found wf:submitAdhocTask when they were supposed to be excluded", (boolean)adhocTasksPresent);
        String workflowInstanceId = adhocPath.getInstance().getId();
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_WORKFLOW_TASKS, workflowInstanceId)), 200);
        WorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        WorkflowRestApiTest.assertNotNull((Object)results);
        WorkflowRestApiTest.assertTrue((results.length() > 0 ? 1 : 0) != 0);
    }

    public void testTaskInstanceGet() throws Exception {
        this.personManager.setUser(USER1);
        WorkflowDefinition adhocDef = this.workflowService.getDefinitionByName("jbpm$wf:adhoc");
        HashMap<QName, Object> params = new HashMap<QName, Object>();
        params.put(WorkflowModel.ASSOC_ASSIGNEE, this.personManager.get(USER2));
        params.put(WorkflowModel.PROP_DUE_DATE, new Date());
        params.put(WorkflowModel.PROP_PRIORITY, 1);
        params.put(WorkflowModel.ASSOC_PACKAGE, this.packageRef);
        WorkflowPath adhocPath = this.workflowService.startWorkflow(adhocDef.id, params);
        WorkflowTask startTask = (WorkflowTask)this.workflowService.getTasksForWorkflowPath(adhocPath.id).get(0);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/task-instances/" + startTask.id), 200);
        WorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        String jsonStr = response.getContentAsString();
        JSONObject json = new JSONObject(jsonStr);
        JSONObject result = json.getJSONObject("data");
        WorkflowRestApiTest.assertNotNull((Object)result);
        WorkflowRestApiTest.assertEquals((String)startTask.id, (String)result.getString("id"));
        WorkflowRestApiTest.assertEquals((String)("api/task-instances/" + startTask.id), (String)result.getString("url"));
        WorkflowRestApiTest.assertEquals((String)startTask.name, (String)result.getString("name"));
        WorkflowRestApiTest.assertEquals((String)startTask.title, (String)result.getString("title"));
        WorkflowRestApiTest.assertEquals((String)startTask.description, (String)result.getString("description"));
        WorkflowRestApiTest.assertEquals((String)startTask.state.name(), (String)result.getString("state"));
        WorkflowRestApiTest.assertEquals((String)("api/workflow-paths/" + adhocPath.getId()), (String)result.getString("path"));
        WorkflowRestApiTest.assertFalse((boolean)result.getBoolean("isPooled"));
        WorkflowRestApiTest.assertTrue((boolean)result.getBoolean("isEditable"));
        WorkflowRestApiTest.assertTrue((boolean)result.getBoolean("isReassignable"));
        WorkflowRestApiTest.assertFalse((boolean)result.getBoolean("isClaimable"));
        WorkflowRestApiTest.assertFalse((boolean)result.getBoolean("isReleasable"));
        JSONObject owner = result.getJSONObject("owner");
        WorkflowRestApiTest.assertEquals((String)USER1, (String)owner.getString("userName"));
        WorkflowRestApiTest.assertEquals((String)this.personManager.getFirstName(USER1), (String)owner.getString("firstName"));
        WorkflowRestApiTest.assertEquals((String)this.personManager.getLastName(USER1), (String)owner.getString("lastName"));
        JSONObject properties = result.getJSONObject("properties");
        WorkflowRestApiTest.assertNotNull((Object)properties);
        WorkflowRestApiTest.assertTrue((boolean)properties.has("bpm_priority"));
        WorkflowRestApiTest.assertTrue((boolean)properties.has("bpm_description"));
        WorkflowRestApiTest.assertTrue((boolean)properties.has("bpm_reassignable"));
        JSONObject instance = result.getJSONObject("workflowInstance");
        WorkflowInstance startInstance = startTask.path.instance;
        WorkflowRestApiTest.assertNotNull((Object)instance);
        WorkflowRestApiTest.assertEquals((String)startInstance.id, (String)instance.getString("id"));
        WorkflowRestApiTest.assertTrue((boolean)instance.has("url"));
        WorkflowRestApiTest.assertEquals((String)startInstance.definition.name, (String)instance.getString("name"));
        WorkflowRestApiTest.assertEquals((String)startInstance.definition.title, (String)instance.getString("title"));
        WorkflowRestApiTest.assertEquals((String)startInstance.definition.description, (String)instance.getString("description"));
        WorkflowRestApiTest.assertEquals((boolean)startInstance.active, (boolean)instance.getBoolean("isActive"));
        WorkflowRestApiTest.assertTrue((boolean)instance.has("startDate"));
        JSONObject initiator = instance.getJSONObject("initiator");
        WorkflowRestApiTest.assertEquals((String)USER1, (String)initiator.getString("userName"));
        WorkflowRestApiTest.assertEquals((String)this.personManager.getFirstName(USER1), (String)initiator.getString("firstName"));
        WorkflowRestApiTest.assertEquals((String)this.personManager.getLastName(USER1), (String)initiator.getString("lastName"));
        JSONObject definition = result.getJSONObject("definition");
        WorkflowTaskDefinition startDefinitiont = startTask.definition;
        WorkflowRestApiTest.assertNotNull((Object)definition);
        WorkflowRestApiTest.assertEquals((String)startDefinitiont.id, (String)definition.getString("id"));
        WorkflowRestApiTest.assertTrue((boolean)definition.has("url"));
        JSONObject type = definition.getJSONObject("type");
        TypeDefinition startType = startDefinitiont.metadata;
        WorkflowRestApiTest.assertNotNull((Object)type);
        WorkflowRestApiTest.assertEquals((String)startType.getName().toPrefixString(), (String)type.getString("name"));
        WorkflowRestApiTest.assertEquals((String)startType.getTitle(), (String)type.getString("title"));
        WorkflowRestApiTest.assertEquals((String)startType.getDescription(), (String)type.getString("description"));
        WorkflowRestApiTest.assertTrue((boolean)type.has("url"));
        JSONObject node = definition.getJSONObject("node");
        WorkflowNode startNode = startDefinitiont.node;
        WorkflowRestApiTest.assertNotNull((Object)node);
        WorkflowRestApiTest.assertEquals((String)startNode.name, (String)node.getString("name"));
        WorkflowRestApiTest.assertEquals((String)startNode.title, (String)node.getString("title"));
        WorkflowRestApiTest.assertEquals((String)startNode.description, (String)node.getString("description"));
        WorkflowRestApiTest.assertEquals((boolean)startNode.isTaskNode, (boolean)node.getBoolean("isTaskNode"));
        JSONArray transitions = node.getJSONArray("transitions");
        WorkflowTransition[] startTransitions = startNode.transitions;
        WorkflowRestApiTest.assertNotNull((Object)transitions);
        WorkflowRestApiTest.assertEquals((int)startTransitions.length, (int)transitions.length());
        for (int i = 0; i < transitions.length(); ++i) {
            JSONObject transition = transitions.getJSONObject(i);
            WorkflowTransition startTransition = startTransitions[i];
            WorkflowRestApiTest.assertNotNull((Object)transition);
            WorkflowRestApiTest.assertEquals((String)startTransition.id, (String)transition.getString("id"));
            WorkflowRestApiTest.assertEquals((String)startTransition.title, (String)transition.getString("title"));
            WorkflowRestApiTest.assertEquals((String)startTransition.description, (String)transition.getString("description"));
            WorkflowRestApiTest.assertEquals((boolean)startTransition.isDefault, (boolean)transition.getBoolean("isDefault"));
            WorkflowRestApiTest.assertTrue((boolean)transition.has("isHidden"));
        }
    }

    public void testTaskInstancePut() throws Exception {
        this.personManager.setUser(USER1);
        WorkflowDefinition adhocDef = this.workflowService.getDefinitionByName("jbpm$wf:adhoc");
        HashMap<QName, Object> params = new HashMap<QName, Object>();
        params.put(WorkflowModel.ASSOC_ASSIGNEE, this.personManager.get(USER2));
        params.put(WorkflowModel.PROP_DUE_DATE, new Date());
        params.put(WorkflowModel.PROP_PRIORITY, 1);
        params.put(WorkflowModel.ASSOC_PACKAGE, this.packageRef);
        WorkflowPath adhocPath = this.workflowService.startWorkflow(adhocDef.id, params);
        WorkflowTask startTask = (WorkflowTask)this.workflowService.getTasksForWorkflowPath(adhocPath.id).get(0);
        TestWebScriptServer.Response getResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/task-instances/" + startTask.id), 200);
        JSONObject jsonProperties = new JSONObject(getResponse.getContentAsString()).getJSONObject("data").getJSONObject("properties");
        jsonProperties.remove(this.qnameToString(WorkflowModel.ASSOC_PACKAGE));
        jsonProperties.put(this.qnameToString(WorkflowModel.PROP_COMMENT), (Object)"Edited comment");
        jsonProperties.put(this.qnameToString(WorkflowModel.PROP_DUE_DATE), (Object)ISO8601DateFormat.format((Date)new Date()));
        jsonProperties.put(this.qnameToString(WorkflowModel.PROP_DESCRIPTION), (Object)"Edited description");
        jsonProperties.put(this.qnameToString(WorkflowModel.PROP_PRIORITY), 1);
        this.personManager.setUser(USER3);
        TestWebScriptServer.Response unauthResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("api/task-instances/" + startTask.id, jsonProperties.toString(), "application/json"), 401);
        WorkflowRestApiTest.assertEquals((int)401, (int)unauthResponse.getStatus());
        this.personManager.setUser(USER1);
        TestWebScriptServer.Response putResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("api/task-instances/" + startTask.id, jsonProperties.toString(), "application/json"), 200);
        WorkflowRestApiTest.assertEquals((int)200, (int)putResponse.getStatus());
        String jsonStr = putResponse.getContentAsString();
        JSONObject json = new JSONObject(jsonStr);
        JSONObject result = json.getJSONObject("data");
        WorkflowRestApiTest.assertNotNull((Object)result);
        JSONObject editedJsonProperties = result.getJSONObject("properties");
        this.compareProperties(jsonProperties, editedJsonProperties);
        this.workflowService.endTask(startTask.id, null);
        List paths = this.workflowService.getWorkflowPaths(adhocPath.getInstance().getId());
        WorkflowTask nextTask = (WorkflowTask)this.workflowService.getTasksForWorkflowPath(((WorkflowPath)paths.get(0)).getId()).get(0);
        putResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("api/task-instances/" + nextTask.id, jsonProperties.toString(), "application/json"), 200);
    }

    public void testWorkflowDefinitionsGet() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_WORKFLOW_DEFINITIONS), 200);
        WorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        JSONObject json = new JSONObject(response.getContentAsString());
        JSONArray results = json.getJSONArray("data");
        WorkflowRestApiTest.assertNotNull((Object)results);
        WorkflowRestApiTest.assertTrue((results.length() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < results.length(); ++i) {
            JSONObject workflowDefinitionJSON = results.getJSONObject(i);
            WorkflowRestApiTest.assertTrue((boolean)workflowDefinitionJSON.has("id"));
            WorkflowRestApiTest.assertTrue((workflowDefinitionJSON.getString("id").length() > 0 ? 1 : 0) != 0);
            WorkflowRestApiTest.assertTrue((boolean)workflowDefinitionJSON.has("url"));
            String url = workflowDefinitionJSON.getString("url");
            WorkflowRestApiTest.assertTrue((url.length() > 0 ? 1 : 0) != 0);
            WorkflowRestApiTest.assertTrue((boolean)url.startsWith("api/workflow-definitions/"));
            WorkflowRestApiTest.assertTrue((boolean)workflowDefinitionJSON.has("name"));
            WorkflowRestApiTest.assertTrue((workflowDefinitionJSON.getString("name").length() > 0 ? 1 : 0) != 0);
            WorkflowRestApiTest.assertTrue((boolean)workflowDefinitionJSON.has("title"));
            WorkflowRestApiTest.assertTrue((workflowDefinitionJSON.getString("title").length() > 0 ? 1 : 0) != 0);
            WorkflowRestApiTest.assertTrue((boolean)workflowDefinitionJSON.has("description"));
            WorkflowRestApiTest.assertTrue((workflowDefinitionJSON.getString("description").length() > 0 ? 1 : 0) != 0);
        }
        String exclude = "jbpm$wf:adhoc";
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/workflow-definitions?exclude=" + exclude), 200);
        WorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        json = new JSONObject(response.getContentAsString());
        results = json.getJSONArray("data");
        WorkflowRestApiTest.assertNotNull((Object)results);
        boolean adhocWorkflowPresent = false;
        for (int i = 0; i < results.length(); ++i) {
            JSONObject workflowDefinitionJSON = results.getJSONObject(i);
            String name = workflowDefinitionJSON.getString("name");
            if (!exclude.equals(name)) continue;
            adhocWorkflowPresent = true;
            break;
        }
        WorkflowRestApiTest.assertFalse((String)"Found adhoc workflow when it was supposed to be excluded", (boolean)adhocWorkflowPresent);
        exclude = "jbpm$wf:adhoc, jbpm$wcmwf:*";
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/workflow-definitions?exclude=" + exclude), 200);
        WorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        json = new JSONObject(response.getContentAsString());
        results = json.getJSONArray("data");
        WorkflowRestApiTest.assertNotNull((Object)results);
        adhocWorkflowPresent = false;
        boolean wcmWorkflowsPresent = false;
        for (int i = 0; i < results.length(); ++i) {
            JSONObject workflowDefinitionJSON = results.getJSONObject(i);
            String name = workflowDefinitionJSON.getString("name");
            if (name.equals("jbpm$wf:adhoc")) {
                adhocWorkflowPresent = true;
            }
            if (!name.startsWith("jbpm$wcmwf:")) continue;
            wcmWorkflowsPresent = true;
        }
        WorkflowRestApiTest.assertFalse((String)"Found adhoc workflow when it was supposed to be excluded", (boolean)adhocWorkflowPresent);
        WorkflowRestApiTest.assertFalse((String)"Found a WCM workflow when they were supposed to be excluded", (boolean)wcmWorkflowsPresent);
    }

    public void testWorkflowInstanceGet() throws Exception {
        this.personManager.setUser(USER1);
        WorkflowDefinition adhocDef = this.workflowService.getDefinitionByName("jbpm$wf:adhoc");
        HashMap<QName, Object> params = new HashMap<QName, Object>();
        params.put(WorkflowModel.ASSOC_ASSIGNEE, this.personManager.get(USER2));
        Date dueDate = new Date();
        params.put(WorkflowModel.PROP_WORKFLOW_DUE_DATE, dueDate);
        params.put(WorkflowModel.PROP_WORKFLOW_PRIORITY, 1);
        params.put(WorkflowModel.ASSOC_PACKAGE, this.packageRef);
        params.put(WorkflowModel.PROP_CONTEXT, this.packageRef);
        WorkflowPath adhocPath = this.workflowService.startWorkflow(adhocDef.id, params);
        WorkflowTask startTask = (WorkflowTask)this.workflowService.getTasksForWorkflowPath(adhocPath.id).get(0);
        startTask = this.workflowService.endTask(startTask.id, null);
        WorkflowInstance adhocInstance = startTask.path.instance;
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/workflow-instances/" + adhocInstance.id + "?includeTasks=true"), 200);
        WorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        String jsonStr = response.getContentAsString();
        JSONObject json = new JSONObject(jsonStr);
        JSONObject result = json.getJSONObject("data");
        WorkflowRestApiTest.assertNotNull((Object)result);
        WorkflowRestApiTest.assertEquals((String)adhocInstance.id, (String)result.getString("id"));
        WorkflowRestApiTest.assertTrue((boolean)result.opt("message").equals(JSONObject.NULL));
        WorkflowRestApiTest.assertEquals((String)adhocInstance.definition.name, (String)result.getString("name"));
        WorkflowRestApiTest.assertEquals((String)adhocInstance.definition.title, (String)result.getString("title"));
        WorkflowRestApiTest.assertEquals((String)adhocInstance.definition.description, (String)result.getString("description"));
        WorkflowRestApiTest.assertEquals((boolean)adhocInstance.active, (boolean)result.getBoolean("isActive"));
        WorkflowRestApiTest.assertEquals((String)ISO8601DateFormat.format((Date)adhocInstance.startDate), (String)result.getString("startDate"));
        WorkflowRestApiTest.assertNotNull((Object)result.getString("dueDate"));
        WorkflowRestApiTest.assertNotNull((Object)result.getString("endDate"));
        WorkflowRestApiTest.assertEquals((int)1, (int)result.getInt("priority"));
        JSONObject initiator = result.getJSONObject("initiator");
        WorkflowRestApiTest.assertEquals((String)USER1, (String)initiator.getString("userName"));
        WorkflowRestApiTest.assertEquals((String)this.personManager.getFirstName(USER1), (String)initiator.getString("firstName"));
        WorkflowRestApiTest.assertEquals((String)this.personManager.getLastName(USER1), (String)initiator.getString("lastName"));
        WorkflowRestApiTest.assertEquals((String)adhocInstance.context.toString(), (String)result.getString("context"));
        WorkflowRestApiTest.assertEquals((String)adhocInstance.workflowPackage.toString(), (String)result.getString("package"));
        WorkflowRestApiTest.assertNotNull((Object)result.getString("startTaskInstanceId"));
        JSONObject jsonDefinition = result.getJSONObject("definition");
        WorkflowDefinition adhocDefinition = adhocInstance.definition;
        WorkflowRestApiTest.assertNotNull((Object)jsonDefinition);
        WorkflowRestApiTest.assertEquals((String)adhocDefinition.id, (String)jsonDefinition.getString("id"));
        WorkflowRestApiTest.assertEquals((String)adhocDefinition.name, (String)jsonDefinition.getString("name"));
        WorkflowRestApiTest.assertEquals((String)adhocDefinition.title, (String)jsonDefinition.getString("title"));
        WorkflowRestApiTest.assertEquals((String)adhocDefinition.description, (String)jsonDefinition.getString("description"));
        WorkflowRestApiTest.assertEquals((String)adhocDefinition.version, (String)jsonDefinition.getString("version"));
        WorkflowRestApiTest.assertEquals((String)adhocDefinition.getStartTaskDefinition().metadata.getName().toPrefixString((NamespacePrefixResolver)this.namespaceService), (String)jsonDefinition.getString("startTaskDefinitionType"));
        WorkflowRestApiTest.assertTrue((boolean)jsonDefinition.has("taskDefinitions"));
        JSONArray tasks = result.getJSONArray("tasks");
        WorkflowRestApiTest.assertTrue((tasks.length() > 1 ? 1 : 0) != 0);
    }

    public void testWorkflowInstancesGet() throws Exception {
        this.personManager.setUser(USER1);
        WorkflowDefinition adhocDef = this.workflowService.getDefinitionByName("jbpm$wf:adhoc");
        HashMap<QName, Object> params = new HashMap<QName, Object>();
        params.put(WorkflowModel.ASSOC_ASSIGNEE, this.personManager.get(USER2));
        Date dueDate = new Date();
        params.put(WorkflowModel.PROP_WORKFLOW_DUE_DATE, dueDate);
        params.put(WorkflowModel.PROP_WORKFLOW_PRIORITY, 1);
        params.put(WorkflowModel.ASSOC_PACKAGE, this.packageRef);
        params.put(WorkflowModel.PROP_CONTEXT, this.packageRef);
        WorkflowPath adhocPath = this.workflowService.startWorkflow(adhocDef.getId(), params);
        WorkflowTask startTask = (WorkflowTask)this.workflowService.getTasksForWorkflowPath(adhocPath.getId()).get(0);
        WorkflowInstance adhocInstance = startTask.getPath().getInstance();
        this.workflowService.endTask(startTask.getId(), null);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_WORKFLOW_INSTANCES), 200);
        WorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        String jsonStr = response.getContentAsString();
        JSONObject json = new JSONObject(jsonStr);
        JSONArray result = json.getJSONArray("data");
        WorkflowRestApiTest.assertNotNull((Object)result);
        int totalItems = result.length();
        for (int i = 0; i < result.length(); ++i) {
            this.checkSimpleWorkflowInstanceResponse(result.getJSONObject(i));
        }
        TestWebScriptServer.Response forDefinitionResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_WORKFLOW_INSTANCES_FOR_DEFINITION, adhocDef.getId())), 200);
        WorkflowRestApiTest.assertEquals((int)200, (int)forDefinitionResponse.getStatus());
        String forDefinitionJsonStr = forDefinitionResponse.getContentAsString();
        JSONObject forDefinitionJson = new JSONObject(forDefinitionJsonStr);
        JSONArray forDefinitionResult = forDefinitionJson.getJSONArray("data");
        WorkflowRestApiTest.assertNotNull((Object)forDefinitionResult);
        for (int i = 0; i < forDefinitionResult.length(); ++i) {
            this.checkSimpleWorkflowInstanceResponse(forDefinitionResult.getJSONObject(i));
        }
        Date anHourAgo = new Date(dueDate.getTime());
        anHourAgo.setHours(anHourAgo.getHours() - 1);
        this.checkFiltering("api/workflow-instances?initiator=" + USER1);
        this.checkFiltering("api/workflow-instances?startedAfter=" + ISO8601DateFormat.format((Date)anHourAgo));
        this.checkFiltering("api/workflow-instances?startedBefore=" + ISO8601DateFormat.format((Date)adhocInstance.getStartDate()));
        this.checkFiltering("api/workflow-instances?dueAfter=" + ISO8601DateFormat.format((Date)anHourAgo));
        this.checkFiltering("api/workflow-instances?dueBefore=" + ISO8601DateFormat.format((Date)dueDate));
        if (adhocInstance.getEndDate() != null) {
            this.checkFiltering("api/workflow-instances?completedAfter=" + ISO8601DateFormat.format((Date)adhocInstance.getEndDate()));
            this.checkFiltering("api/workflow-instances?completedBefore=" + ISO8601DateFormat.format((Date)adhocInstance.getEndDate()));
        }
        this.checkFiltering("api/workflow-instances?priority=1");
        this.checkFiltering("api/workflow-instances?state=active");
        this.checkFiltering("api/workflow-instances?definitionName=jbpm$wf:adhoc");
        int maxItems = 3;
        for (int skipCount = 0; skipCount < totalItems; skipCount += maxItems) {
            this.checkPaging("api/workflow-instances?maxItems=" + maxItems + "&skipCount=" + skipCount, totalItems, maxItems, skipCount);
        }
        String exclude = "jbpm$wf:adhoc";
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/workflow-instances?exclude=" + exclude), 200);
        WorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        JSONArray results = json.getJSONArray("data");
        WorkflowRestApiTest.assertNotNull((Object)results);
        boolean adhocWorkflowPresent = false;
        for (int i = 0; i < results.length(); ++i) {
            JSONObject workflowInstanceJSON = results.getJSONObject(i);
            String type = workflowInstanceJSON.getString("name");
            if (!exclude.equals(type)) continue;
            adhocWorkflowPresent = true;
            break;
        }
        WorkflowRestApiTest.assertFalse((String)"Found adhoc workflows when they were supposed to be excluded", (boolean)adhocWorkflowPresent);
    }

    public void testWorkflowInstancesForNodeGet() throws Exception {
        this.personManager.setUser(USER1);
        WorkflowDefinition adhocDef = this.workflowService.getDefinitionByName("jbpm$wf:adhoc");
        HashMap<QName, Object> params = new HashMap<QName, Object>();
        params.put(WorkflowModel.ASSOC_ASSIGNEE, this.personManager.get(USER2));
        params.put(WorkflowModel.PROP_DUE_DATE, new Date());
        params.put(WorkflowModel.PROP_PRIORITY, 1);
        params.put(WorkflowModel.ASSOC_PACKAGE, this.packageRef);
        this.nodeService.addChild(this.packageRef, this.contentNodeRef, WorkflowModel.ASSOC_PACKAGE_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)((String)((Object)this.nodeService.getProperty(this.contentNodeRef, ContentModel.PROP_NAME))))));
        WorkflowPath adhocPath = this.workflowService.startWorkflow(adhocDef.id, params);
        String url = MessageFormat.format(URL_WORKFLOW_INSTANCES_FOR_NODE, this.contentNodeRef.getStoreRef().getProtocol(), this.contentNodeRef.getStoreRef().getIdentifier(), this.contentNodeRef.getId());
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        WorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        String jsonStr = response.getContentAsString();
        JSONObject json = new JSONObject(jsonStr);
        JSONArray result = json.getJSONArray("data");
        WorkflowRestApiTest.assertNotNull((Object)result);
        WorkflowRestApiTest.assertTrue((result.length() > 0 ? 1 : 0) != 0);
        this.workflowService.cancelWorkflow(adhocPath.getInstance().getId());
        TestWebScriptServer.Response afterCancelResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        WorkflowRestApiTest.assertEquals((int)200, (int)afterCancelResponse.getStatus());
        String afterCancelJsonStr = afterCancelResponse.getContentAsString();
        JSONObject afterCancelJson = new JSONObject(afterCancelJsonStr);
        JSONArray afterCancelResult = afterCancelJson.getJSONArray("data");
        WorkflowRestApiTest.assertNotNull((Object)afterCancelResult);
        WorkflowRestApiTest.assertTrue((afterCancelResult.length() == 0 ? 1 : 0) != 0);
    }

    public void testWorkflowInstanceDelete() throws Exception {
        this.personManager.setUser(USER1);
        WorkflowDefinition adhocDef = this.workflowService.getDefinitionByName("jbpm$wf:adhoc");
        HashMap<QName, Object> params = new HashMap<QName, Object>();
        params.put(WorkflowModel.ASSOC_ASSIGNEE, this.personManager.get(USER2));
        Date dueDate = new Date();
        params.put(WorkflowModel.PROP_DUE_DATE, dueDate);
        params.put(WorkflowModel.PROP_PRIORITY, 1);
        params.put(WorkflowModel.ASSOC_PACKAGE, this.packageRef);
        params.put(WorkflowModel.PROP_CONTEXT, this.packageRef);
        WorkflowPath adhocPath = this.workflowService.startWorkflow(adhocDef.getId(), params);
        WorkflowTask startTask = (WorkflowTask)this.workflowService.getTasksForWorkflowPath(adhocPath.getId()).get(0);
        startTask = this.workflowService.endTask(startTask.getId(), null);
        WorkflowInstance adhocInstance = startTask.getPath().getInstance();
        this.personManager.setUser(USER3);
        TestWebScriptServer.Response unauthResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("api/workflow-instances/" + adhocInstance.getId()), 403);
        WorkflowRestApiTest.assertEquals((int)403, (int)unauthResponse.getStatus());
        WorkflowRestApiTest.assertNotNull((Object)this.workflowService.getWorkflowById(adhocInstance.getId()));
        this.personManager.setUser(USER1);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("api/workflow-instances/" + adhocInstance.getId()), 200);
        WorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        WorkflowRestApiTest.assertNull((Object)this.workflowService.getWorkflowById(adhocInstance.getId()));
    }

    protected void setUp() throws Exception {
        super.setUp();
        ApplicationContext appContext = this.getServer().getApplicationContext();
        this.namespaceService = (NamespaceService)appContext.getBean("NamespaceService");
        this.workflowService = (WorkflowService)appContext.getBean("WorkflowService");
        MutableAuthenticationService authenticationService = (MutableAuthenticationService)appContext.getBean("AuthenticationService");
        PersonService personService = (PersonService)appContext.getBean("PersonService");
        SearchService searchService = (SearchService)appContext.getBean("SearchService");
        FileFolderService fileFolderService = (FileFolderService)appContext.getBean("FileFolderService");
        this.nodeService = (NodeService)appContext.getBean("NodeService");
        this.personManager = new TestPersonManager(authenticationService, personService, this.nodeService);
        this.personManager.createPerson(USER1);
        this.personManager.createPerson(USER2);
        this.personManager.createPerson(USER3);
        this.packageRef = this.workflowService.createPackage(null);
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        NodeRef companyHome = (NodeRef)searchService.selectNodes(this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE), COMPANY_HOME, null, (NamespacePrefixResolver)this.namespaceService, false).get(0);
        this.contentNodeRef = fileFolderService.create(companyHome, TEST_CONTENT + System.currentTimeMillis(), ContentModel.TYPE_CONTENT).getNodeRef();
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.personManager.clearPeople();
    }

    private String qnameToString(QName qName) {
        String separator = Character.toString(':');
        return qName.toPrefixString((NamespacePrefixResolver)this.namespaceService).replaceFirst(separator, "_");
    }

    private void compareProperties(JSONObject before, JSONObject after) throws JSONException {
        for (String name : JSONObject.getNames((JSONObject)after)) {
            if (!before.has(name)) continue;
            if (before.get(name) instanceof JSONArray) {
                for (int i = 0; i < before.getJSONArray(name).length(); ++i) {
                    WorkflowRestApiTest.assertEquals((Object)before.getJSONArray(name).get(i), (Object)after.getJSONArray(name).get(i));
                }
                continue;
            }
            WorkflowRestApiTest.assertEquals((Object)before.get(name), (Object)after.get(name));
        }
    }

    private void checkSimpleWorkflowInstanceResponse(JSONObject json) throws JSONException {
        WorkflowRestApiTest.assertTrue((boolean)json.has("id"));
        WorkflowRestApiTest.assertTrue((json.getString("id").length() > 0 ? 1 : 0) != 0);
        WorkflowRestApiTest.assertTrue((boolean)json.has("url"));
        WorkflowRestApiTest.assertTrue((boolean)json.getString("url").startsWith(URL_WORKFLOW_INSTANCES));
        WorkflowRestApiTest.assertTrue((boolean)json.has("name"));
        WorkflowRestApiTest.assertTrue((json.getString("name").length() > 0 ? 1 : 0) != 0);
        WorkflowRestApiTest.assertTrue((boolean)json.has("title"));
        WorkflowRestApiTest.assertTrue((json.getString("title").length() > 0 ? 1 : 0) != 0);
        WorkflowRestApiTest.assertTrue((boolean)json.has("description"));
        WorkflowRestApiTest.assertTrue((json.getString("description").length() > 0 ? 1 : 0) != 0);
        WorkflowRestApiTest.assertTrue((boolean)json.has("isActive"));
        WorkflowRestApiTest.assertTrue((boolean)json.has("startDate"));
        WorkflowRestApiTest.assertTrue((json.getString("startDate").length() > 0 ? 1 : 0) != 0);
        WorkflowRestApiTest.assertTrue((boolean)json.has("endDate"));
        WorkflowRestApiTest.assertTrue((boolean)json.has("initiator"));
        Object initiator = json.get("initiator");
        if (!initiator.equals(JSONObject.NULL)) {
            WorkflowRestApiTest.assertTrue((boolean)((JSONObject)initiator).has("userName"));
            WorkflowRestApiTest.assertTrue((boolean)((JSONObject)initiator).has("firstName"));
            WorkflowRestApiTest.assertTrue((boolean)((JSONObject)initiator).has("lastName"));
        }
        WorkflowRestApiTest.assertTrue((boolean)json.has("definitionUrl"));
        WorkflowRestApiTest.assertTrue((boolean)json.getString("definitionUrl").startsWith(URL_WORKFLOW_DEFINITIONS));
    }

    private void checkFiltering(String url) throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        WorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        String jsonStr = response.getContentAsString();
        JSONObject json = new JSONObject(jsonStr);
        JSONArray result = json.getJSONArray("data");
        WorkflowRestApiTest.assertNotNull((Object)result);
        WorkflowRestApiTest.assertTrue((result.length() > 0 ? 1 : 0) != 0);
    }

    private void checkPaging(String url, int totalItems, int maxItems, int skipCount) throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        WorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        String jsonStr = response.getContentAsString();
        JSONObject json = new JSONObject(jsonStr);
        JSONArray data = json.getJSONArray("data");
        JSONObject paging = json.getJSONObject("paging");
        WorkflowRestApiTest.assertNotNull((Object)data);
        WorkflowRestApiTest.assertNotNull((Object)paging);
        WorkflowRestApiTest.assertTrue((data.length() >= 0 ? 1 : 0) != 0);
        WorkflowRestApiTest.assertTrue((data.length() <= maxItems ? 1 : 0) != 0);
        WorkflowRestApiTest.assertEquals((int)totalItems, (int)paging.getInt("totalItems"));
        WorkflowRestApiTest.assertEquals((int)maxItems, (int)paging.getInt("maxItems"));
        WorkflowRestApiTest.assertEquals((int)skipCount, (int)paging.getInt("skipCount"));
    }
}

