/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.util;

import junit.framework.TestCase;
import org.alfresco.repo.web.util.PagingCursor;

public class PagingCursorTest
extends TestCase {
    protected PagingCursor pageCursor;

    protected void setUp() throws Exception {
        this.pageCursor = new PagingCursor();
    }

    public void testZeroBasedBooleans() {
        PagingCursorTest.assertFalse((boolean)this.pageCursor.isZeroBasedPage());
        this.pageCursor.setZeroBasedPage(true);
        PagingCursorTest.assertTrue((boolean)this.pageCursor.isZeroBasedPage());
        PagingCursorTest.assertTrue((boolean)this.pageCursor.isZeroBasedRow());
        this.pageCursor.setZeroBasedRow(false);
        PagingCursorTest.assertFalse((boolean)this.pageCursor.isZeroBasedRow());
    }

    public void testZeroRowsPageCursor() {
        PagingCursor.Page page = this.pageCursor.createPageCursor(0L, 10, 1);
        PagingCursorTest.assertNotNull((Object)page);
        PagingCursorTest.assertEquals((long)0L, (long)page.getTotalRows());
        PagingCursorTest.assertEquals((int)0, (int)page.getTotalPages());
        PagingCursorTest.assertEquals((int)10, (int)page.getRowsPerPage());
        PagingCursorTest.assertFalse((boolean)page.isInRange());
        PagingCursorTest.assertEquals((int)1, (int)page.getCurrentPage());
        PagingCursorTest.assertEquals((int)-1, (int)page.getFirstPage());
        PagingCursorTest.assertEquals((int)-1, (int)page.getLastPage());
        PagingCursorTest.assertEquals((int)-1, (int)page.getPreviousPage());
        PagingCursorTest.assertEquals((int)-1, (int)page.getNextPage());
        PagingCursorTest.assertEquals((long)-1L, (long)page.getStartRow());
        PagingCursorTest.assertEquals((long)-1L, (long)page.getEndRow());
    }

    public void testOutOfBoundsPageCursor() {
        PagingCursor.Page page1 = this.pageCursor.createPageCursor(1L, 1, 1);
        PagingCursorTest.assertNotNull((Object)page1);
        PagingCursorTest.assertTrue((boolean)page1.isInRange());
        PagingCursor.Page page2 = this.pageCursor.createPageCursor(1L, 1, 2);
        PagingCursorTest.assertNotNull((Object)page2);
        PagingCursorTest.assertFalse((boolean)page2.isInRange());
        PagingCursor.Page page3 = this.pageCursor.createPageCursor(1L, 2, 1);
        PagingCursorTest.assertNotNull((Object)page3);
        PagingCursorTest.assertTrue((boolean)page3.isInRange());
        PagingCursor.Page page4 = this.pageCursor.createPageCursor(10L, 2, 5);
        PagingCursorTest.assertNotNull((Object)page4);
        PagingCursorTest.assertTrue((boolean)page4.isInRange());
        PagingCursor.Page page5 = this.pageCursor.createPageCursor(10L, 2, 6);
        PagingCursorTest.assertNotNull((Object)page5);
        PagingCursorTest.assertFalse((boolean)page5.isInRange());
        PagingCursor.Page page6 = this.pageCursor.createPageCursor(11L, 2, 5);
        PagingCursorTest.assertNotNull((Object)page6);
        PagingCursorTest.assertTrue((boolean)page6.isInRange());
        PagingCursor.Page page7 = this.pageCursor.createPageCursor(11L, 2, 6);
        PagingCursorTest.assertNotNull((Object)page7);
        PagingCursorTest.assertTrue((boolean)page7.isInRange());
        PagingCursor.Page page8 = this.pageCursor.createPageCursor(11L, 2, 0);
        PagingCursorTest.assertNotNull((Object)page8);
        PagingCursorTest.assertFalse((boolean)page8.isInRange());
        this.pageCursor.setZeroBasedPage(true);
        PagingCursor.Page page10 = this.pageCursor.createPageCursor(1L, 1, 0);
        PagingCursorTest.assertNotNull((Object)page10);
        PagingCursorTest.assertTrue((boolean)page10.isInRange());
        PagingCursor.Page page11 = this.pageCursor.createPageCursor(1L, 1, 1);
        PagingCursorTest.assertNotNull((Object)page11);
        PagingCursorTest.assertFalse((boolean)page11.isInRange());
        PagingCursor.Page page12 = this.pageCursor.createPageCursor(1L, 2, 0);
        PagingCursorTest.assertNotNull((Object)page12);
        PagingCursorTest.assertTrue((boolean)page12.isInRange());
        PagingCursor.Page page13 = this.pageCursor.createPageCursor(10L, 2, 4);
        PagingCursorTest.assertNotNull((Object)page13);
        PagingCursorTest.assertTrue((boolean)page13.isInRange());
        PagingCursor.Page page14 = this.pageCursor.createPageCursor(10L, 2, 5);
        PagingCursorTest.assertNotNull((Object)page14);
        PagingCursorTest.assertFalse((boolean)page14.isInRange());
        PagingCursor.Page page15 = this.pageCursor.createPageCursor(11L, 2, 4);
        PagingCursorTest.assertNotNull((Object)page15);
        PagingCursorTest.assertTrue((boolean)page15.isInRange());
        PagingCursor.Page page16 = this.pageCursor.createPageCursor(11L, 2, 5);
        PagingCursorTest.assertNotNull((Object)page16);
        PagingCursorTest.assertTrue((boolean)page16.isInRange());
        PagingCursor.Page page17 = this.pageCursor.createPageCursor(11L, 2, -1);
        PagingCursorTest.assertNotNull((Object)page17);
        PagingCursorTest.assertFalse((boolean)page17.isInRange());
    }

    public void testTotalPageCursor() {
        PagingCursor.Page page1 = this.pageCursor.createPageCursor(10L, 1, 1);
        PagingCursorTest.assertEquals((long)10L, (long)page1.getTotalRows());
        PagingCursorTest.assertEquals((int)10, (int)page1.getTotalPages());
        PagingCursor.Page page2 = this.pageCursor.createPageCursor(10L, 10, 1);
        PagingCursorTest.assertEquals((long)10L, (long)page2.getTotalRows());
        PagingCursorTest.assertEquals((int)1, (int)page2.getTotalPages());
        PagingCursor.Page page3 = this.pageCursor.createPageCursor(9L, 10, 1);
        PagingCursorTest.assertEquals((long)9L, (long)page3.getTotalRows());
        PagingCursorTest.assertEquals((int)1, (int)page3.getTotalPages());
        PagingCursor.Page page4 = this.pageCursor.createPageCursor(11L, 10, 1);
        PagingCursorTest.assertEquals((long)11L, (long)page4.getTotalRows());
        PagingCursorTest.assertEquals((int)2, (int)page4.getTotalPages());
        PagingCursor.Page page5 = this.pageCursor.createPageCursor(20L, 10, 1);
        PagingCursorTest.assertEquals((long)20L, (long)page5.getTotalRows());
        PagingCursorTest.assertEquals((int)2, (int)page5.getTotalPages());
    }

    public void testPagingPageCursor() {
        PagingCursor.Page page1 = this.pageCursor.createPageCursor(10L, 1, 1);
        PagingCursorTest.assertEquals((int)1, (int)page1.getCurrentPage());
        PagingCursorTest.assertEquals((int)1, (int)page1.getFirstPage());
        PagingCursorTest.assertEquals((int)10, (int)page1.getLastPage());
        PagingCursorTest.assertEquals((int)-1, (int)page1.getPreviousPage());
        PagingCursorTest.assertEquals((int)2, (int)page1.getNextPage());
        PagingCursorTest.assertEquals((long)0L, (long)page1.getStartRow());
        PagingCursorTest.assertEquals((long)0L, (long)page1.getEndRow());
        PagingCursor.Page page2 = this.pageCursor.createPageCursor(10L, 1, 2);
        PagingCursorTest.assertEquals((int)2, (int)page2.getCurrentPage());
        PagingCursorTest.assertEquals((int)1, (int)page2.getFirstPage());
        PagingCursorTest.assertEquals((int)10, (int)page2.getLastPage());
        PagingCursorTest.assertEquals((int)1, (int)page2.getPreviousPage());
        PagingCursorTest.assertEquals((int)3, (int)page2.getNextPage());
        PagingCursorTest.assertEquals((long)1L, (long)page2.getStartRow());
        PagingCursorTest.assertEquals((long)1L, (long)page2.getEndRow());
        PagingCursor.Page page3 = this.pageCursor.createPageCursor(10L, 10, 1);
        PagingCursorTest.assertEquals((int)1, (int)page3.getCurrentPage());
        PagingCursorTest.assertEquals((int)1, (int)page3.getFirstPage());
        PagingCursorTest.assertEquals((int)1, (int)page3.getLastPage());
        PagingCursorTest.assertEquals((int)-1, (int)page3.getPreviousPage());
        PagingCursorTest.assertEquals((int)-1, (int)page3.getNextPage());
        PagingCursorTest.assertEquals((long)0L, (long)page3.getStartRow());
        PagingCursorTest.assertEquals((long)9L, (long)page3.getEndRow());
        PagingCursor.Page page4 = this.pageCursor.createPageCursor(9L, 10, 1);
        PagingCursorTest.assertEquals((int)1, (int)page4.getCurrentPage());
        PagingCursorTest.assertEquals((int)1, (int)page4.getFirstPage());
        PagingCursorTest.assertEquals((int)1, (int)page4.getLastPage());
        PagingCursorTest.assertEquals((int)-1, (int)page4.getPreviousPage());
        PagingCursorTest.assertEquals((int)-1, (int)page4.getNextPage());
        PagingCursorTest.assertEquals((long)0L, (long)page4.getStartRow());
        PagingCursorTest.assertEquals((long)8L, (long)page4.getEndRow());
        PagingCursor.Page page5 = this.pageCursor.createPageCursor(11L, 10, 1);
        PagingCursorTest.assertEquals((int)1, (int)page5.getCurrentPage());
        PagingCursorTest.assertEquals((int)1, (int)page5.getFirstPage());
        PagingCursorTest.assertEquals((int)2, (int)page5.getLastPage());
        PagingCursorTest.assertEquals((int)-1, (int)page5.getPreviousPage());
        PagingCursorTest.assertEquals((int)2, (int)page5.getNextPage());
        PagingCursorTest.assertEquals((long)0L, (long)page5.getStartRow());
        PagingCursorTest.assertEquals((long)9L, (long)page5.getEndRow());
        PagingCursor.Page page6 = this.pageCursor.createPageCursor(20L, 10, 1);
        PagingCursorTest.assertEquals((int)1, (int)page6.getCurrentPage());
        PagingCursorTest.assertEquals((int)1, (int)page6.getFirstPage());
        PagingCursorTest.assertEquals((int)2, (int)page6.getLastPage());
        PagingCursorTest.assertEquals((int)-1, (int)page6.getPreviousPage());
        PagingCursorTest.assertEquals((int)2, (int)page6.getNextPage());
        PagingCursorTest.assertEquals((long)0L, (long)page6.getStartRow());
        PagingCursorTest.assertEquals((long)9L, (long)page6.getEndRow());
        PagingCursor.Page page7 = this.pageCursor.createPageCursor(20L, 10, 2);
        PagingCursorTest.assertEquals((int)2, (int)page7.getCurrentPage());
        PagingCursorTest.assertEquals((int)1, (int)page7.getFirstPage());
        PagingCursorTest.assertEquals((int)2, (int)page7.getLastPage());
        PagingCursorTest.assertEquals((int)1, (int)page7.getPreviousPage());
        PagingCursorTest.assertEquals((int)-1, (int)page7.getNextPage());
        PagingCursorTest.assertEquals((long)10L, (long)page7.getStartRow());
        PagingCursorTest.assertEquals((long)19L, (long)page7.getEndRow());
        PagingCursor.Page page8 = this.pageCursor.createPageCursor(11L, 10, 2);
        PagingCursorTest.assertEquals((int)2, (int)page8.getCurrentPage());
        PagingCursorTest.assertEquals((int)1, (int)page8.getFirstPage());
        PagingCursorTest.assertEquals((int)2, (int)page8.getLastPage());
        PagingCursorTest.assertEquals((int)1, (int)page8.getPreviousPage());
        PagingCursorTest.assertEquals((int)-1, (int)page8.getNextPage());
        PagingCursorTest.assertEquals((long)10L, (long)page8.getStartRow());
        PagingCursorTest.assertEquals((long)10L, (long)page8.getEndRow());
    }

    public void testUnlimitedPageCursor() {
        PagingCursor.Page page1 = this.pageCursor.createPageCursor(100L, 0, 1);
        PagingCursorTest.assertTrue((boolean)page1.isInRange());
        PagingCursorTest.assertEquals((int)1, (int)page1.getCurrentPage());
        PagingCursorTest.assertEquals((int)1, (int)page1.getFirstPage());
        PagingCursorTest.assertEquals((int)1, (int)page1.getLastPage());
        PagingCursorTest.assertEquals((int)-1, (int)page1.getPreviousPage());
        PagingCursorTest.assertEquals((int)-1, (int)page1.getNextPage());
        PagingCursorTest.assertEquals((long)0L, (long)page1.getStartRow());
        PagingCursorTest.assertEquals((long)99L, (long)page1.getEndRow());
        PagingCursor.Page page2 = this.pageCursor.createPageCursor(100L, 0, 2);
        PagingCursorTest.assertFalse((boolean)page2.isInRange());
    }

    public void testScrollPageCursor() {
        int count = 0;
        long[] coll = new long[100];
        PagingCursor.Page page = this.pageCursor.createPageCursor(100L, 10, 1);
        while (page.isInRange()) {
            for (long i = page.getStartRow(); i <= page.getEndRow(); ++i) {
                coll[(int)i] = i;
                ++count;
            }
            page = this.pageCursor.createPageCursor(100L, 10, page.getNextPage());
        }
        PagingCursorTest.assertEquals((int)100, (int)count);
        for (int test = 0; test < count; ++test) {
            PagingCursorTest.assertEquals((long)test, (long)coll[test]);
        }
    }

    public void testZeroRowsIndexCursor() {
        PagingCursor.Rows rows = this.pageCursor.createRowsCursor(0L, 10L, 0L);
        PagingCursorTest.assertNotNull((Object)rows);
        PagingCursorTest.assertEquals((long)0L, (long)rows.getTotalRows());
        PagingCursorTest.assertFalse((boolean)rows.isInRange());
        PagingCursorTest.assertEquals((long)10L, (long)rows.getMaxRows());
        PagingCursorTest.assertEquals((long)-1L, (long)rows.getStartRow());
        PagingCursorTest.assertEquals((long)-1L, (long)rows.getEndRow());
        PagingCursorTest.assertEquals((long)-1L, (long)rows.getNextSkipRows());
    }

    public void testOutOfBoundsRowsCursor() {
        PagingCursor.Rows rows1 = this.pageCursor.createRowsCursor(1L, 1L, 0L);
        PagingCursorTest.assertNotNull((Object)rows1);
        PagingCursorTest.assertTrue((boolean)rows1.isInRange());
        PagingCursor.Rows rows2 = this.pageCursor.createRowsCursor(1L, 1L, 1L);
        PagingCursorTest.assertNotNull((Object)rows2);
        PagingCursorTest.assertFalse((boolean)rows2.isInRange());
        PagingCursor.Rows rows3 = this.pageCursor.createRowsCursor(1L, -1L, 0L);
        PagingCursorTest.assertNotNull((Object)rows3);
        PagingCursorTest.assertTrue((boolean)rows3.isInRange());
    }

    public void testTotalRowsCursor() {
        PagingCursor.Rows rows1 = this.pageCursor.createRowsCursor(10L, 1L, 1L);
        PagingCursorTest.assertEquals((long)10L, (long)rows1.getTotalRows());
    }

    public void testPagingRowsCursor() {
        PagingCursor.Rows rows1 = this.pageCursor.createRowsCursor(10L, 1L, 0L);
        PagingCursorTest.assertEquals((long)0L, (long)rows1.getStartRow());
        PagingCursorTest.assertEquals((long)0L, (long)rows1.getEndRow());
        PagingCursorTest.assertEquals((long)1L, (long)rows1.getNextSkipRows());
        PagingCursor.Rows rows2 = this.pageCursor.createRowsCursor(10L, 7L, 0L);
        PagingCursorTest.assertEquals((long)0L, (long)rows2.getStartRow());
        PagingCursorTest.assertEquals((long)6L, (long)rows2.getEndRow());
        PagingCursorTest.assertEquals((long)7L, (long)rows2.getNextSkipRows());
        PagingCursor.Rows rows3 = this.pageCursor.createRowsCursor(10L, 7L, 7L);
        PagingCursorTest.assertEquals((long)7L, (long)rows3.getStartRow());
        PagingCursorTest.assertEquals((long)9L, (long)rows3.getEndRow());
        PagingCursorTest.assertEquals((long)-1L, (long)rows3.getNextSkipRows());
        PagingCursor.Rows rows4 = this.pageCursor.createRowsCursor(10L, 10L, 0L);
        PagingCursorTest.assertEquals((long)0L, (long)rows4.getStartRow());
        PagingCursorTest.assertEquals((long)9L, (long)rows4.getEndRow());
        PagingCursorTest.assertEquals((long)-1L, (long)rows4.getNextSkipRows());
        PagingCursor.Rows rows5 = this.pageCursor.createRowsCursor(10L, 11L, 0L);
        PagingCursorTest.assertEquals((long)0L, (long)rows5.getStartRow());
        PagingCursorTest.assertEquals((long)9L, (long)rows5.getEndRow());
        PagingCursorTest.assertEquals((long)-1L, (long)rows5.getNextSkipRows());
    }

    public void testUnlimitedRowsCursor() {
        PagingCursor.Rows rows1 = this.pageCursor.createRowsCursor(100L, 0L, 0L);
        PagingCursorTest.assertTrue((boolean)rows1.isInRange());
        PagingCursorTest.assertEquals((long)0L, (long)rows1.getStartRow());
        PagingCursorTest.assertEquals((long)99L, (long)rows1.getEndRow());
        PagingCursorTest.assertEquals((long)-1L, (long)rows1.getNextSkipRows());
    }

    public void testScrollRowsCursor() {
        int count = 0;
        long[] coll = new long[100];
        PagingCursor.Rows rows = this.pageCursor.createRowsCursor(100L, 10L, 0L);
        while (rows.isInRange()) {
            for (long i = rows.getStartRow(); i <= rows.getEndRow(); ++i) {
                coll[(int)i] = i;
                ++count;
            }
            rows = this.pageCursor.createRowsCursor(100L, 10L, rows.getNextSkipRows());
        }
        PagingCursorTest.assertEquals((int)100, (int)count);
        for (int test = 0; test < count; ++test) {
            PagingCursorTest.assertEquals((long)test, (long)coll[test]);
        }
    }
}

