/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.webdav.WebDAVMethod;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;

public class MkcolMethod
extends WebDAVMethod {
    protected void parseRequestHeaders() throws WebDAVServerException {
    }

    protected void parseRequestBody() throws WebDAVServerException {
        if (this.m_request.getContentLength() > 0) {
            throw new WebDAVServerException(415);
        }
    }

    protected void executeImpl() throws WebDAVServerException, Exception {
        FileFolderService fileFolderService = this.getFileFolderService();
        try {
            this.getDAVHelper().getNodeForPath(this.getRootNodeRef(), this.getPath(), this.getServletPath());
            throw new WebDAVServerException(405);
        }
        catch (FileNotFoundException e) {
            String parentPath = this.getPath();
            int lastPos = parentPath.lastIndexOf("/");
            NodeRef parentNodeRef = null;
            if (lastPos == 0) {
                parentPath = "/";
                parentNodeRef = this.getRootNodeRef();
            } else if (lastPos != -1) {
                parentPath = parentPath.substring(0, lastPos + 1);
                try {
                    FileInfo parentFileInfo = this.getDAVHelper().getNodeForPath(this.getRootNodeRef(), parentPath, this.m_request.getServletPath());
                    parentNodeRef = parentFileInfo.getNodeRef();
                }
                catch (FileNotFoundException e2) {
                    throw new WebDAVServerException(409);
                }
            } else {
                throw new WebDAVServerException(405);
            }
            String folderName = this.getPath().substring(lastPos + 1);
            fileFolderService.create(parentNodeRef, folderName, ContentModel.TYPE_FOLDER);
            this.m_response.setStatus(201);
            return;
        }
    }
}

