/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

public class WebDAVServerException
extends Exception {
    private static final long serialVersionUID = -2949418282738082368L;
    private int m_httpStatusCode = 500;
    private Throwable m_cause = null;

    public WebDAVServerException(int httpStatusCode) {
        this(httpStatusCode, null);
    }

    public WebDAVServerException(int httpStatusCode, Throwable cause) {
        super(Integer.toString(httpStatusCode));
        this.m_httpStatusCode = httpStatusCode;
        this.m_cause = cause;
    }

    public int getHttpStatusCode() {
        return this.m_httpStatusCode;
    }

    public Throwable getCause() {
        return this.m_cause;
    }

    public String toString() {
        String strErrorMsg = "HTTP Status Code: " + this.m_httpStatusCode;
        if (this.m_cause != null) {
            strErrorMsg = strErrorMsg + " caused by: " + this.m_cause.toString();
        }
        return strErrorMsg;
    }
}

