/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webservice.action;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.action.ActionConditionImpl;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.CompositeActionImpl;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionServiceImpl;
import org.alfresco.repo.webservice.AbstractWebService;
import org.alfresco.repo.webservice.Utils;
import org.alfresco.repo.webservice.action.Action;
import org.alfresco.repo.webservice.action.ActionExecutionResult;
import org.alfresco.repo.webservice.action.ActionFault;
import org.alfresco.repo.webservice.action.ActionFilter;
import org.alfresco.repo.webservice.action.ActionItemDefinition;
import org.alfresco.repo.webservice.action.ActionItemDefinitionType;
import org.alfresco.repo.webservice.action.ActionServiceSoapPort;
import org.alfresco.repo.webservice.action.Condition;
import org.alfresco.repo.webservice.action.ParameterDefinition;
import org.alfresco.repo.webservice.action.Rule;
import org.alfresco.repo.webservice.action.RuleFilter;
import org.alfresco.repo.webservice.action.RuleType;
import org.alfresco.repo.webservice.types.NamedValue;
import org.alfresco.repo.webservice.types.Predicate;
import org.alfresco.repo.webservice.types.Reference;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ActionConditionDefinition;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.CompositeAction;
import org.alfresco.service.cmr.action.ParameterizedItem;
import org.alfresco.service.cmr.action.ParameterizedItemDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionWebService
extends AbstractWebService
implements ActionServiceSoapPort {
    private static Log logger = LogFactory.getLog(ActionWebService.class);
    private ActionService actionService;
    private RuleService ruleService;
    private DictionaryService dictionaryService;
    private TransactionServiceImpl transactionService;

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setTransactionService(TransactionServiceImpl transactionService) {
        this.transactionService = transactionService;
    }

    public ActionItemDefinition[] getConditionDefinitions() throws RemoteException, ActionFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<ActionItemDefinition[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<ActionItemDefinition[]>(){

                public ActionItemDefinition[] execute() throws Exception {
                    return ActionWebService.this.getConditionDefintionsImpl();
                }
            };
            return (ActionItemDefinition[])this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable exception) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", exception);
            }
            throw new ActionFault(0, exception.getMessage());
        }
    }

    private ActionItemDefinition[] getConditionDefintionsImpl() throws RemoteException {
        List definitions = this.actionService.getActionConditionDefinitions();
        ActionItemDefinition[] result = new ActionItemDefinition[definitions.size()];
        int index = 0;
        for (ActionConditionDefinition definition : definitions) {
            result[index] = this.convertToActionItemDefintion((ParameterizedItemDefinition)definition, ActionItemDefinitionType.condition);
            ++index;
        }
        return result;
    }

    public ActionItemDefinition[] getActionDefinitions() throws RemoteException, ActionFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<ActionItemDefinition[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<ActionItemDefinition[]>(){

                public ActionItemDefinition[] execute() throws Exception {
                    return ActionWebService.this.getActionDefinitionsImpl();
                }
            };
            return (ActionItemDefinition[])this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable exception) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", exception);
            }
            throw new ActionFault(0, exception.getMessage());
        }
    }

    private ActionItemDefinition[] getActionDefinitionsImpl() throws RemoteException {
        List definitions = this.actionService.getActionDefinitions();
        ActionItemDefinition[] result = new ActionItemDefinition[definitions.size()];
        int index = 0;
        for (ActionDefinition definition : definitions) {
            result[index] = this.convertToActionItemDefintion((ParameterizedItemDefinition)definition, ActionItemDefinitionType.action);
            ++index;
        }
        return result;
    }

    public ActionItemDefinition getActionItemDefinition(final String name, final ActionItemDefinitionType definitionType) throws RemoteException, ActionFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<ActionItemDefinition> callback = new RetryingTransactionHelper.RetryingTransactionCallback<ActionItemDefinition>(){

                public ActionItemDefinition execute() throws Exception {
                    return ActionWebService.this.getActionItemDefinitionImpl(name, definitionType);
                }
            };
            return (ActionItemDefinition)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable exception) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", exception);
            }
            throw new ActionFault(0, exception.getMessage());
        }
    }

    public ActionItemDefinition getActionItemDefinitionImpl(String name, ActionItemDefinitionType definitionType) throws RemoteException, ActionFault {
        ActionItemDefinition result = null;
        if (definitionType.equals(ActionItemDefinitionType.action)) {
            ActionDefinition actionDefinition = this.actionService.getActionDefinition(name);
            if (actionDefinition != null) {
                result = this.convertToActionItemDefintion((ParameterizedItemDefinition)actionDefinition, definitionType);
            }
        } else {
            ActionConditionDefinition conditionDefinition = this.actionService.getActionConditionDefinition(name);
            if (conditionDefinition != null) {
                result = this.convertToActionItemDefintion((ParameterizedItemDefinition)conditionDefinition, definitionType);
            }
        }
        return result;
    }

    private ActionItemDefinition convertToActionItemDefintion(ParameterizedItemDefinition definition, ActionItemDefinitionType type) {
        ActionItemDefinition actionItemType = new ActionItemDefinition();
        actionItemType.setName(definition.getName());
        actionItemType.setType(type);
        actionItemType.setTitle(definition.getTitle());
        actionItemType.setDescription(definition.getDescription());
        actionItemType.setAdHocPropertiesAllowed(definition.getAdhocPropertiesAllowed());
        List params = definition.getParameterDefinitions();
        ParameterDefinition[] parameterDefinitions = new ParameterDefinition[params.size()];
        int index = 0;
        for (org.alfresco.service.cmr.action.ParameterDefinition paramDef : params) {
            ParameterDefinition parameterDefinition;
            parameterDefinitions[index] = parameterDefinition = new ParameterDefinition(paramDef.getName(), paramDef.getType().toString(), paramDef.isMandatory(), paramDef.getDisplayLabel());
            ++index;
        }
        actionItemType.setParameterDefinition(parameterDefinitions);
        return actionItemType;
    }

    public RuleType[] getRuleTypes() throws RemoteException, ActionFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<RuleType[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<RuleType[]>(){

                public RuleType[] execute() throws Exception {
                    return ActionWebService.this.getRuleTypesImpl();
                }
            };
            return (RuleType[])this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable exception) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", exception);
            }
            throw new ActionFault(0, exception.getMessage());
        }
    }

    public RuleType[] getRuleTypesImpl() throws RemoteException, ActionFault {
        List ruleTypes = this.ruleService.getRuleTypes();
        RuleType[] results = new RuleType[ruleTypes.size()];
        int index = 0;
        for (org.alfresco.service.cmr.rule.RuleType ruleType : ruleTypes) {
            RuleType webServiceRuleType;
            results[index] = webServiceRuleType = new RuleType(ruleType.getName(), ruleType.getDisplayLabel());
            ++index;
        }
        return results;
    }

    public RuleType getRuleType(final String name) throws RemoteException, ActionFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<RuleType> callback = new RetryingTransactionHelper.RetryingTransactionCallback<RuleType>(){

                public RuleType execute() throws Exception {
                    return ActionWebService.this.getRuleTypeImpl(name);
                }
            };
            return (RuleType)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable exception) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", exception);
            }
            throw new ActionFault(0, exception.getMessage());
        }
    }

    public RuleType getRuleTypeImpl(String name) throws RemoteException, ActionFault {
        RuleType result = null;
        org.alfresco.service.cmr.rule.RuleType ruleType = this.ruleService.getRuleType(name);
        if (ruleType != null) {
            result = new RuleType(ruleType.getName(), ruleType.getDisplayLabel());
        }
        return result;
    }

    public Action[] getActions(final Reference reference, final ActionFilter filter) throws RemoteException, ActionFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<Action[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Action[]>(){

                public Action[] execute() throws Exception {
                    return ActionWebService.this.getActionsImpl(reference, filter);
                }
            };
            return (Action[])this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable exception) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", exception);
            }
            throw new ActionFault(0, exception.getMessage());
        }
    }

    private Action[] getActionsImpl(Reference reference, ActionFilter filter) throws RemoteException, ActionFault {
        NodeRef nodeRef = Utils.convertToNodeRef(reference, this.nodeService, this.searchService, this.namespaceService);
        List actions = this.actionService.getActions(nodeRef);
        Action[] webServiceActions = new Action[actions.size()];
        if (filter != null) {
            // empty if block
        }
        int index = 0;
        for (org.alfresco.service.cmr.action.Action action : actions) {
            webServiceActions[index] = this.convertToWebServiceAction(action);
            ++index;
        }
        return webServiceActions;
    }

    private Action convertToWebServiceAction(org.alfresco.service.cmr.action.Action action) {
        NamedValue[] namedValues = this.convertParametersToNamedValues((ParameterizedItem)action);
        List conditions = action.getActionConditions();
        Condition[] webServiceConditions = new Condition[conditions.size()];
        int index2 = 0;
        for (ActionCondition condition : conditions) {
            webServiceConditions[index2] = this.convertToWebServiceCondition(condition);
            ++index2;
        }
        org.alfresco.service.cmr.action.Action compensatingAction = action.getCompensatingAction();
        Action webServiceCompensatingAction = null;
        if (compensatingAction != null) {
            webServiceCompensatingAction = this.convertToWebServiceAction(compensatingAction);
        }
        Action[] childWebServiceActions = null;
        if (action instanceof CompositeAction) {
            List childActions = ((CompositeAction)action).getActions();
            childWebServiceActions = new Action[childActions.size()];
            int index3 = 0;
            for (org.alfresco.service.cmr.action.Action childAction : childActions) {
                childWebServiceActions[index3] = this.convertToWebServiceAction(childAction);
                ++index3;
            }
        }
        Action webServiceAction = new Action(Utils.convertToReference(this.nodeService, this.namespaceService, action.getNodeRef()), action.getId(), action.getActionDefinitionName(), action.getTitle(), action.getDescription(), namedValues, webServiceConditions, webServiceCompensatingAction, childWebServiceActions);
        return webServiceAction;
    }

    private NamedValue[] convertParametersToNamedValues(ParameterizedItem item) {
        NamedValue[] namedValues = null;
        if (item != null) {
            Map params = item.getParameterValues();
            namedValues = new NamedValue[params.size()];
            int index = 0;
            for (Map.Entry entry : params.entrySet()) {
                String value = null;
                try {
                    value = (String)DefaultTypeConverter.INSTANCE.convert(String.class, entry.getValue());
                }
                catch (Throwable exception) {
                    value = ((Serializable)entry.getValue()).toString();
                }
                NamedValue namedValue = new NamedValue();
                namedValue.setName((String)entry.getKey());
                namedValue.setIsMultiValue(false);
                namedValue.setValue(value);
                namedValues[index] = namedValue;
                ++index;
            }
        }
        return namedValues;
    }

    private Condition convertToWebServiceCondition(ActionCondition condition) {
        NamedValue[] namedValues = this.convertParametersToNamedValues((ParameterizedItem)condition);
        Condition webServiceCondition = new Condition(condition.getId(), condition.getActionConditionDefinitionName(), condition.getInvertCondition(), namedValues);
        return webServiceCondition;
    }

    public Action[] saveActions(final Reference reference, final Action[] webServiceActions) throws RemoteException, ActionFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<Action[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Action[]>(){

                public Action[] execute() throws Exception {
                    return ActionWebService.this.saveActionsImpl(reference, webServiceActions);
                }
            };
            return (Action[])this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable exception) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", exception);
            }
            throw new ActionFault(0, exception.getMessage());
        }
    }

    private Action[] saveActionsImpl(Reference reference, Action[] webServiceActions) throws RemoteException, ActionFault {
        NodeRef nodeRef = Utils.convertToNodeRef(reference, this.nodeService, this.searchService, this.namespaceService);
        Action[] results = new Action[webServiceActions.length];
        int index = 0;
        for (Action webServiceAction : webServiceActions) {
            org.alfresco.service.cmr.action.Action action = this.convertToAction(webServiceAction);
            this.actionService.saveAction(nodeRef, action);
            results[index] = this.convertToWebServiceAction(action);
            ++index;
        }
        return results;
    }

    private org.alfresco.service.cmr.action.Action convertToAction(Action webServiceAction) {
        Action[] webServiceChildActions;
        Action webServiceCompensatingAction;
        Condition[] webServiceConditions;
        String id = webServiceAction.getId();
        if (id == null || id.length() == 0) {
            id = GUID.generate();
        }
        NodeRef actionNodeRef = null;
        Reference actionReference = webServiceAction.getActionReference();
        if (actionReference != null) {
            actionNodeRef = Utils.convertToNodeRef(actionReference, this.nodeService, this.searchService, this.namespaceService);
        }
        Object action = null;
        String actionDefinitionName = webServiceAction.getActionName();
        action = "composite-action".equals(actionDefinitionName) ? new CompositeActionImpl(actionNodeRef, id) : new ActionImpl(actionNodeRef, id, actionDefinitionName);
        action.setTitle(webServiceAction.getTitle());
        action.setDescription(webServiceAction.getDescription());
        NamedValue[] namedValues = webServiceAction.getParameters();
        if (namedValues != null) {
            for (NamedValue namedValue : namedValues) {
                DataTypeDefinition propertyType = null;
                ActionDefinition actionDefintion = this.actionService.getActionDefinition(action.getActionDefinitionName());
                org.alfresco.service.cmr.action.ParameterDefinition propertyDefintion = actionDefintion.getParameterDefintion(namedValue.getName());
                if (propertyDefintion != null) {
                    propertyType = this.dictionaryService.getDataType(propertyDefintion.getType());
                }
                Object value = null;
                value = propertyType != null ? (Serializable)DefaultTypeConverter.INSTANCE.convert(propertyType, (Object)namedValue.getValue()) : namedValue.getValue();
                action.setParameterValue(namedValue.getName(), (Serializable)value);
            }
        }
        if ((webServiceConditions = webServiceAction.getConditions()) != null) {
            for (Condition webServiceCondition : webServiceConditions) {
                action.addActionCondition(this.convertToActionCondition(webServiceCondition));
            }
        }
        if ((webServiceCompensatingAction = webServiceAction.getCompensatingAction()) != null) {
            org.alfresco.service.cmr.action.Action compensatingAction = this.convertToAction(webServiceCompensatingAction);
            action.setCompensatingAction(compensatingAction);
        }
        if ("composite-action".equals(actionDefinitionName) && (webServiceChildActions = webServiceAction.getActions()) != null) {
            for (Action webServiceChildAction : webServiceChildActions) {
                org.alfresco.service.cmr.action.Action childAction = this.convertToAction(webServiceChildAction);
                ((CompositeAction)action).addAction(childAction);
            }
        }
        return action;
    }

    private ActionCondition convertToActionCondition(Condition webServiceCondition) {
        String id = webServiceCondition.getId();
        if (id == null || id.length() == 0) {
            id = GUID.generate();
        }
        ActionConditionImpl actionCondition = new ActionConditionImpl(id, webServiceCondition.getConditionName());
        actionCondition.setInvertCondition(webServiceCondition.isInvertCondition());
        NamedValue[] namedValues = webServiceCondition.getParameters();
        if (namedValues != null) {
            for (NamedValue namedValue : namedValues) {
                DataTypeDefinition propertyType = null;
                ActionConditionDefinition actionConditionDefintion = this.actionService.getActionConditionDefinition(actionCondition.getActionConditionDefinitionName());
                org.alfresco.service.cmr.action.ParameterDefinition propertyDefintion = actionConditionDefintion.getParameterDefintion(namedValue.getName());
                if (propertyDefintion != null) {
                    propertyType = this.dictionaryService.getDataType(propertyDefintion.getType());
                }
                Object value = null;
                value = propertyType != null ? (Serializable)DefaultTypeConverter.INSTANCE.convert(propertyType, (Object)namedValue.getValue()) : namedValue.getValue();
                actionCondition.setParameterValue(namedValue.getName(), (Serializable)value);
            }
        }
        return actionCondition;
    }

    public void removeActions(final Reference reference, final Action[] webServiceActions) throws RemoteException, ActionFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() throws Exception {
                    ActionWebService.this.removeActionsImpl(reference, webServiceActions);
                    return null;
                }
            };
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable exception) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", exception);
            }
            throw new ActionFault(0, exception.getMessage());
        }
    }

    private void removeActionsImpl(Reference reference, Action[] webServiceActions) throws RemoteException, ActionFault {
        NodeRef nodeRef = Utils.convertToNodeRef(reference, this.nodeService, this.searchService, this.namespaceService);
        if (webServiceActions == null) {
            this.actionService.removeAllActions(nodeRef);
        } else {
            for (Action webServiceAction : webServiceActions) {
                org.alfresco.service.cmr.action.Action action = this.convertToAction(webServiceAction);
                this.actionService.removeAction(nodeRef, action);
            }
        }
    }

    public ActionExecutionResult[] executeActions(final Predicate predicate, final Action[] webServiceActions) throws RemoteException, ActionFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<ActionExecutionResult[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<ActionExecutionResult[]>(){

                public ActionExecutionResult[] execute() throws Exception {
                    return ActionWebService.this.executeActionsImpl(predicate, webServiceActions);
                }
            };
            return (ActionExecutionResult[])this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable exception) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", exception);
            }
            throw new ActionFault(0, exception.getMessage());
        }
    }

    public ActionExecutionResult[] executeActionsImpl(Predicate predicate, Action[] webServiceActions) throws RemoteException, ActionFault {
        ArrayList<ActionExecutionResult> results = new ArrayList<ActionExecutionResult>(10);
        List<NodeRef> nodeRefs = Utils.resolvePredicate(predicate, this.nodeService, this.searchService, this.namespaceService);
        for (NodeRef nodeRef : nodeRefs) {
            ActionExecutionResult executionResult = new ActionExecutionResult();
            executionResult.setReference(Utils.convertToReference(this.nodeService, this.namespaceService, nodeRef));
            ArrayList<Action> executedActions = new ArrayList<Action>(10);
            for (Action webServiceAction : webServiceActions) {
                org.alfresco.service.cmr.action.Action action = this.convertToAction(webServiceAction);
                if (!this.actionService.evaluateAction(action, nodeRef)) continue;
                this.actionService.executeAction(action, nodeRef, false);
                Serializable result = action.getParameterValue("result");
                if (result != null) {
                    String convertedValue = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)result);
                    NamedValue convertedNameValue = new NamedValue("result", false, convertedValue, null);
                    NamedValue[] currentValues = webServiceAction.getParameters();
                    NamedValue[] updatedValues = new NamedValue[currentValues.length + 1];
                    int index = 0;
                    NamedValue[] arr$ = currentValues;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        NamedValue value;
                        updatedValues[index] = value = arr$[i$];
                        ++index;
                    }
                    updatedValues[index] = convertedNameValue;
                    webServiceAction.setParameters(updatedValues);
                }
                executedActions.add(webServiceAction);
            }
            Action[] executedWebServiceActions = executedActions.toArray(new Action[executedActions.size()]);
            executionResult.setActions(executedWebServiceActions);
            results.add(executionResult);
        }
        return results.toArray(new ActionExecutionResult[results.size()]);
    }

    public Rule[] getRules(final Reference reference, final RuleFilter ruleFilter) throws RemoteException, ActionFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<Rule[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Rule[]>(){

                public Rule[] execute() throws Exception {
                    return ActionWebService.this.getRulesImpl(reference, ruleFilter);
                }
            };
            return (Rule[])this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable exception) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", exception);
            }
            throw new ActionFault(0, exception.getMessage());
        }
    }

    private Rule[] getRulesImpl(Reference reference, RuleFilter ruleFilter) throws RemoteException, ActionFault {
        NodeRef nodeRef = Utils.convertToNodeRef(reference, this.nodeService, this.searchService, this.namespaceService);
        List rules = this.ruleService.getRules(nodeRef);
        Rule[] webServiceRules = new Rule[rules.size()];
        int index = 0;
        for (org.alfresco.service.cmr.rule.Rule rule : rules) {
            webServiceRules[index] = this.convertToWebServiceRule(rule);
            ++index;
        }
        return webServiceRules;
    }

    private Rule convertToWebServiceRule(org.alfresco.service.cmr.rule.Rule rule) {
        Reference owningReference = null;
        NodeRef owningNodeRef = this.ruleService.getOwningNodeRef(rule);
        if (owningNodeRef != null) {
            owningReference = Utils.convertToReference(this.nodeService, this.namespaceService, owningNodeRef);
        }
        Rule webServiceRule = new Rule(Utils.convertToReference(this.nodeService, this.namespaceService, rule.getNodeRef()), owningReference, rule.getRuleTypes().toArray(new String[rule.getRuleTypes().size()]), rule.getTitle(), rule.getDescription(), rule.getExecuteAsynchronously(), this.convertToWebServiceAction(rule.getAction()));
        return webServiceRule;
    }

    public Rule[] saveRules(final Reference reference, final Rule[] webServiceRules) throws RemoteException, ActionFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<Rule[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Rule[]>(){

                public Rule[] execute() throws Exception {
                    return ActionWebService.this.saveRulesImpl(reference, webServiceRules);
                }
            };
            return (Rule[])this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable exception) {
            exception.printStackTrace();
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", exception);
            }
            throw new ActionFault(0, exception.getMessage());
        }
    }

    private Rule[] saveRulesImpl(Reference reference, Rule[] webServiceRules) throws RemoteException, ActionFault {
        NodeRef nodeRef = Utils.convertToNodeRef(reference, this.nodeService, this.searchService, this.namespaceService);
        Rule[] results = new Rule[webServiceRules.length];
        int index = 0;
        for (Rule webServiceRule : webServiceRules) {
            org.alfresco.service.cmr.rule.Rule rule = this.convertToRule(webServiceRule);
            this.ruleService.saveRule(nodeRef, rule);
            results[index] = this.convertToWebServiceRule(rule);
            ++index;
        }
        return results;
    }

    public void removeRules(final Reference reference, final Rule[] webServiceRules) throws RemoteException, ActionFault {
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() throws Exception {
                    ActionWebService.this.removeRulesImpl(reference, webServiceRules);
                    return null;
                }
            };
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (Throwable exception) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", exception);
            }
            throw new ActionFault(0, exception.getMessage());
        }
    }

    public void removeRulesImpl(Reference reference, Rule[] webServiceRules) throws RemoteException, ActionFault {
        NodeRef nodeRef = Utils.convertToNodeRef(reference, this.nodeService, this.searchService, this.namespaceService);
        if (webServiceRules == null) {
            this.ruleService.removeAllRules(nodeRef);
        } else {
            for (Rule webServiceRule : webServiceRules) {
                org.alfresco.service.cmr.rule.Rule rule = this.convertToRule(webServiceRule);
                this.ruleService.removeRule(nodeRef, rule);
            }
        }
    }

    private org.alfresco.service.cmr.rule.Rule convertToRule(Rule webServiceRule) {
        NodeRef ruleNodeRef = null;
        if (webServiceRule.getRuleReference() != null) {
            ruleNodeRef = Utils.convertToNodeRef(webServiceRule.getRuleReference(), this.nodeService, this.searchService, this.namespaceService);
        }
        String[] ruleTypes = webServiceRule.getRuleTypes();
        org.alfresco.service.cmr.rule.Rule rule = new org.alfresco.service.cmr.rule.Rule();
        ArrayList<String> ruleTypesList = new ArrayList<String>(ruleTypes.length);
        for (String ruleType : ruleTypes) {
            ruleTypesList.add(ruleType);
        }
        rule.setRuleTypes(ruleTypesList);
        rule.setNodeRef(ruleNodeRef);
        rule.setTitle(webServiceRule.getTitle());
        rule.setDescription(webServiceRule.getDescription());
        rule.setExecuteAsynchronously(webServiceRule.isExecuteAsynchronously());
        org.alfresco.service.cmr.action.Action action = this.convertToAction(webServiceRule.getAction());
        rule.setAction(action);
        return rule;
    }
}

