/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webservice.administration;

import java.util.ArrayList;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.webservice.AbstractQuery;
import org.alfresco.repo.webservice.administration.AdministrationWebService;
import org.alfresco.repo.webservice.administration.UserDetails;
import org.alfresco.repo.webservice.administration.UserFilter;
import org.alfresco.repo.webservice.administration.UserQueryResults;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserQuery
extends AbstractQuery<UserQueryResults> {
    private static final long serialVersionUID = -672399618512462040L;
    private UserFilter userFilter;

    public UserQuery(UserFilter userFilter) {
        this.userFilter = userFilter;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("AssociationQuery").append("[ userFilter=").append(this.userFilter.getUserName()).append("]");
        return sb.toString();
    }

    @Override
    public UserQueryResults execute(ServiceRegistry serviceRegistry) {
        PersonService personService = serviceRegistry.getPersonService();
        NodeService nodeService = serviceRegistry.getNodeService();
        Set nodeRefs = personService.getAllPeople();
        ArrayList<NodeRef> filteredNodeRefs = null;
        if (this.userFilter != null && this.userFilter.getUserName() != null && this.userFilter.getUserName().length() != 0) {
            String userNameFilter = this.userFilter.getUserName();
            filteredNodeRefs = new ArrayList(nodeRefs.size());
            for (NodeRef nodeRef : nodeRefs) {
                String userName = (String)((Object)nodeService.getProperty(nodeRef, ContentModel.PROP_USERNAME));
                if (!userName.matches(userNameFilter)) continue;
                filteredNodeRefs.add(nodeRef);
            }
        } else {
            filteredNodeRefs = new ArrayList<NodeRef>(nodeRefs);
        }
        UserDetails[] results = new UserDetails[filteredNodeRefs.size()];
        int index = 0;
        for (NodeRef nodeRef : filteredNodeRefs) {
            String userName = (String)((Object)nodeService.getProperty(nodeRef, ContentModel.PROP_USERNAME));
            results[index] = AdministrationWebService.createUserDetails(nodeService, userName, nodeRef);
            ++index;
        }
        UserQueryResults queryResults = new UserQueryResults(null, results);
        return queryResults;
    }
}

