/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webservice.classification;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.webservice.AbstractWebService;
import org.alfresco.repo.webservice.Utils;
import org.alfresco.repo.webservice.classification.AppliedCategory;
import org.alfresco.repo.webservice.classification.CategoriesResult;
import org.alfresco.repo.webservice.classification.ClassificationFault;
import org.alfresco.repo.webservice.classification.ClassificationServiceSoapPort;
import org.alfresco.repo.webservice.types.Category;
import org.alfresco.repo.webservice.types.Classification;
import org.alfresco.repo.webservice.types.Predicate;
import org.alfresco.repo.webservice.types.Reference;
import org.alfresco.repo.webservice.types.Store;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassificationWebService
extends AbstractWebService
implements ClassificationServiceSoapPort {
    private static Log logger = LogFactory.getLog(ClassificationWebService.class);
    private CategoryService categoryService;
    private DictionaryService dictionaryService;
    private TransactionService transactionService;

    public void setCategoryService(CategoryService categoryService) {
        this.categoryService = categoryService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public Classification[] getClassifications(final Store store) throws RemoteException, ClassificationFault {
        try {
            return (Classification[])this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Classification[]>(){

                public Classification[] execute() {
                    ArrayList<Classification> classifications = new ArrayList<Classification>();
                    Collection categoryAspects = ClassificationWebService.this.categoryService.getClassificationAspects();
                    for (QName aspect : categoryAspects) {
                        String title = null;
                        ClassDefinition aspectDefinition = ClassificationWebService.this.dictionaryService.getClass(aspect);
                        if (aspectDefinition != null) {
                            title = aspectDefinition.getTitle();
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Category aspect found: " + title + " (" + aspect.toString() + ")"));
                        }
                        Collection assocs = ClassificationWebService.this.categoryService.getCategories(Utils.convertToStoreRef(store), aspect, CategoryService.Depth.IMMEDIATE);
                        for (ChildAssociationRef assoc : assocs) {
                            NodeRef categoryNodeRef = assoc.getChildRef();
                            Classification classification = new Classification();
                            classification.setClassification(aspect.toString());
                            classification.setTitle(title);
                            classification.setRootCategory(ClassificationWebService.this.convertToCategory(categoryNodeRef));
                            classifications.add(classification);
                        }
                    }
                    return classifications.toArray(new Classification[classifications.size()]);
                }
            });
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            throw new ClassificationFault(0, e.getMessage());
        }
    }

    private Category convertToCategory(NodeRef nodeRef) {
        String title = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Category: " + title + "(" + nodeRef.toString() + ")"));
        }
        Category category = new Category();
        category.setId(Utils.convertToReference(this.nodeService, this.namespaceService, nodeRef));
        category.setTitle(title);
        return category;
    }

    public Category[] getChildCategories(final Reference parentCategory) throws RemoteException, ClassificationFault {
        try {
            return (Category[])this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Category[]>(){

                public Category[] execute() {
                    NodeRef parentNodeRef = Utils.convertToNodeRef(parentCategory, ClassificationWebService.this.nodeService, ClassificationWebService.this.searchService, ClassificationWebService.this.namespaceService);
                    Collection assocs = ClassificationWebService.this.categoryService.getChildren(parentNodeRef, CategoryService.Mode.SUB_CATEGORIES, CategoryService.Depth.IMMEDIATE);
                    ArrayList<Category> categories = new ArrayList<Category>(assocs.size());
                    for (ChildAssociationRef assoc : assocs) {
                        NodeRef categoryNodeRef = assoc.getChildRef();
                        categories.add(ClassificationWebService.this.convertToCategory(categoryNodeRef));
                    }
                    return categories.toArray(new Category[categories.size()]);
                }
            });
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            throw new ClassificationFault(0, e.getMessage());
        }
    }

    public CategoriesResult[] getCategories(final Predicate items) throws RemoteException, ClassificationFault {
        try {
            return (CategoriesResult[])this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<CategoriesResult[]>(){

                public CategoriesResult[] execute() {
                    ArrayList<CategoriesResult> result = new ArrayList<CategoriesResult>();
                    List<NodeRef> nodeRefs = Utils.resolvePredicate(items, ClassificationWebService.this.nodeService, ClassificationWebService.this.searchService, ClassificationWebService.this.namespaceService);
                    for (NodeRef nodeRef : nodeRefs) {
                        ArrayList<AppliedCategory> appliedCategories = new ArrayList<AppliedCategory>();
                        Set apsects = ClassificationWebService.this.nodeService.getAspects(nodeRef);
                        for (QName aspect : apsects) {
                            QName categoryPropertyName;
                            if (!ClassificationWebService.this.dictionaryService.isSubClass(aspect, ContentModel.ASPECT_CLASSIFIABLE) || (categoryPropertyName = ClassificationWebService.this.getPropertyName(aspect)) == null) continue;
                            Collection categoryNodeRefs = DefaultTypeConverter.INSTANCE.getCollection(NodeRef.class, (Object)ClassificationWebService.this.nodeService.getProperty(nodeRef, categoryPropertyName));
                            Reference[] categoryReferences = new Reference[categoryNodeRefs.size()];
                            int iIndex = 0;
                            for (NodeRef categoryNodeRef : categoryNodeRefs) {
                                categoryReferences[iIndex] = Utils.convertToReference(ClassificationWebService.this.nodeService, ClassificationWebService.this.namespaceService, categoryNodeRef);
                                ++iIndex;
                            }
                            AppliedCategory appliedCategory = new AppliedCategory();
                            appliedCategory.setClassification(aspect.toString());
                            appliedCategory.setCategories(categoryReferences);
                            appliedCategories.add(appliedCategory);
                        }
                        CategoriesResult categoryResult = new CategoriesResult();
                        categoryResult.setNode(Utils.convertToReference(ClassificationWebService.this.nodeService, ClassificationWebService.this.namespaceService, nodeRef));
                        categoryResult.setCategories(appliedCategories.toArray(new AppliedCategory[appliedCategories.size()]));
                        result.add(categoryResult);
                    }
                    return result.toArray(new CategoriesResult[result.size()]);
                }
            });
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            throw new ClassificationFault(0, e.getMessage());
        }
    }

    private QName getPropertyName(QName aspect) {
        QName categoryPropertyName = null;
        ClassDefinition classDefinition = this.dictionaryService.getClass(aspect);
        for (PropertyDefinition propertyDefintion : classDefinition.getProperties().values()) {
            if (!DataTypeDefinition.CATEGORY.equals((Object)propertyDefintion.getDataType().getName())) continue;
            categoryPropertyName = propertyDefintion.getName();
            break;
        }
        return categoryPropertyName;
    }

    public CategoriesResult[] setCategories(final Predicate items, final AppliedCategory[] categories) throws RemoteException, ClassificationFault {
        try {
            return (CategoriesResult[])this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<CategoriesResult[]>(){

                public CategoriesResult[] execute() {
                    ArrayList<CategoriesResult> result = new ArrayList<CategoriesResult>();
                    List<NodeRef> nodeRefs = Utils.resolvePredicate(items, ClassificationWebService.this.nodeService, ClassificationWebService.this.searchService, ClassificationWebService.this.namespaceService);
                    for (NodeRef nodeRef : nodeRefs) {
                        ArrayList<AppliedCategory> appliedCategories = new ArrayList<AppliedCategory>();
                        for (AppliedCategory category : categories) {
                            QName aspect = QName.createQName((String)category.getClassification());
                            QName propertyName = ClassificationWebService.this.getPropertyName(aspect);
                            if (propertyName == null) continue;
                            if (!ClassificationWebService.this.nodeService.hasAspect(nodeRef, aspect)) {
                                ClassificationWebService.this.nodeService.addAspect(nodeRef, aspect, null);
                            }
                            Reference[] categories2 = category.getCategories();
                            ArrayList<NodeRef> categoryNodeRefs = null;
                            if (categories2 == null) {
                                categoryNodeRefs = new ArrayList<NodeRef>(0);
                            } else {
                                categoryNodeRefs = new ArrayList(categories2.length);
                                for (Reference categoryReference : categories2) {
                                    categoryNodeRefs.add(Utils.convertToNodeRef(categoryReference, ClassificationWebService.this.nodeService, ClassificationWebService.this.searchService, ClassificationWebService.this.namespaceService));
                                }
                            }
                            ClassificationWebService.this.nodeService.setProperty(nodeRef, propertyName, categoryNodeRefs);
                            AppliedCategory appliedCategory = new AppliedCategory();
                            appliedCategory.setClassification(category.getClassification());
                            appliedCategory.setCategories(category.getCategories());
                            appliedCategories.add(appliedCategory);
                        }
                        CategoriesResult categoryResult = new CategoriesResult();
                        categoryResult.setNode(Utils.convertToReference(ClassificationWebService.this.nodeService, ClassificationWebService.this.namespaceService, nodeRef));
                        categoryResult.setCategories(appliedCategories.toArray(new AppliedCategory[appliedCategories.size()]));
                        result.add(categoryResult);
                    }
                    return result.toArray(new CategoriesResult[result.size()]);
                }
            });
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            throw new ClassificationFault(0, e.getMessage());
        }
    }

    public org.alfresco.repo.webservice.types.ClassDefinition describeClassification(final String classification) throws RemoteException, ClassificationFault {
        try {
            return (org.alfresco.repo.webservice.types.ClassDefinition)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<org.alfresco.repo.webservice.types.ClassDefinition>(){

                public org.alfresco.repo.webservice.types.ClassDefinition execute() {
                    ClassDefinition classDefinition = ClassificationWebService.this.dictionaryService.getClass(QName.createQName((String)classification));
                    return Utils.setupClassDefObject(classDefinition);
                }
            });
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.error((Object)"Unexpected error occurred", e);
            }
            throw new ClassificationFault(0, e.getMessage());
        }
    }
}

