/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webservice.repository;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.webservice.AbstractQuery;
import org.alfresco.repo.webservice.Utils;
import org.alfresco.repo.webservice.repository.Association;
import org.alfresco.repo.webservice.types.NamedValue;
import org.alfresco.repo.webservice.types.Reference;
import org.alfresco.repo.webservice.types.ResultSet;
import org.alfresco.repo.webservice.types.ResultSetRow;
import org.alfresco.repo.webservice.types.ResultSetRowNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociationQuery
extends AbstractQuery<ResultSet> {
    private static final long serialVersionUID = -672399618512462040L;
    private Reference node;
    private Association association;
    private static final String SOURCE = "source";

    public AssociationQuery(Reference node, Association association) {
        this.node = node;
        this.association = association;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("AssociationQuery").append("[ node=").append(this.node.getUuid()).append(", association=").append(this.association).append("]");
        return sb.toString();
    }

    @Override
    public ResultSet execute(ServiceRegistry serviceRegistry) {
        SearchService searchService = serviceRegistry.getSearchService();
        NodeService nodeService = serviceRegistry.getNodeService();
        DictionaryService dictionaryService = serviceRegistry.getDictionaryService();
        NamespaceService namespaceService = serviceRegistry.getNamespaceService();
        NodeRef nodeRef = Utils.convertToNodeRef(this.node, nodeService, searchService, namespaceService);
        List assocRefs = null;
        if (this.association == null) {
            assocRefs = nodeService.getTargetAssocs(nodeRef, RegexQNamePattern.MATCH_ALL);
        } else {
            QNamePattern name = RegexQNamePattern.MATCH_ALL;
            String assocType = this.association.getAssociationType();
            if (assocType != null) {
                name = QName.createQName((String)assocType);
            }
            assocRefs = SOURCE.equals(this.association.getDirection()) ? nodeService.getSourceAssocs(nodeRef, name) : nodeService.getTargetAssocs(nodeRef, name);
        }
        ResultSet results = new ResultSet();
        ArrayList<ResultSetRow> rows = new ArrayList<ResultSetRow>(assocRefs.size());
        int index = 0;
        NodeRef childNodeRef = null;
        for (AssociationRef assocRef : assocRefs) {
            childNodeRef = SOURCE.equals(this.association.getDirection()) ? assocRef.getSourceRef() : assocRef.getTargetRef();
            Map props = null;
            try {
                props = nodeService.getProperties(childNodeRef);
            }
            catch (AccessDeniedException e) {
                // empty catch block
            }
            if (props == null) continue;
            ResultSetRowNode rowNode = this.createResultSetRowNode(childNodeRef, nodeService);
            NamedValue[] columns = new NamedValue[props.size() + 2];
            int col = 0;
            for (QName propName : props.keySet()) {
                columns[col] = Utils.createNamedValue(dictionaryService, propName, (Serializable)props.get(propName));
                ++col;
            }
            columns[col] = new NamedValue("associationType", Boolean.FALSE, assocRef.getTypeQName().toString(), null);
            columns[++col] = Utils.createNamedValue(dictionaryService, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"path"), (Serializable)((Object)nodeService.getPath(childNodeRef).toString()));
            ResultSetRow row = new ResultSetRow();
            row.setRowIndex(index);
            row.setNode(rowNode);
            row.setColumns(columns);
            rows.add(row);
            ++index;
        }
        results.setRows(rows.toArray(new ResultSetRow[0]));
        results.setTotalRowCount(rows.size());
        return results;
    }
}

