/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.web.app.servlet.HTTPProxy;
import org.springframework.extensions.surf.util.URLEncoder;

public class HTTPProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = -576405943603122206L;
    private static final String PARAM_ENDPOINT = "endpoint";

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String endpoint = null;
        StringBuilder args = new StringBuilder(32);
        Map parameters = req.getParameterMap();
        for (Map.Entry parameter : parameters.entrySet()) {
            String[] values = (String[])parameter.getValue();
            int startIdx = 0;
            if (((String)parameter.getKey()).equals(PARAM_ENDPOINT) && values.length != 0) {
                endpoint = values[0];
            }
            for (int i = ++startIdx; i < values.length; ++i) {
                if (args.length() != 0) {
                    args.append("&");
                }
                args.append((String)parameter.getKey()).append('=').append(URLEncoder.encode((String)values[i]));
            }
        }
        if (endpoint == null || endpoint.length() == 0) {
            throw new IllegalArgumentException("endpoint argument not specified");
        }
        String url = endpoint + (args.length() == 0 ? "" : "?" + args.toString());
        HTTPProxy proxy = new HTTPProxy(url, res);
        proxy.service();
    }

    public static String createProxyUrl(String url) {
        String proxy = "/proxy";
        if (url != null && url.length() > 0) {
            int argIndex = url.lastIndexOf("?");
            proxy = argIndex == -1 ? proxy + "?endpoint=" + url : proxy + "?endpoint=" + url.substring(0, argIndex) + "&" + url.substring(argIndex + 1);
        }
        return proxy;
    }
}

