/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.dictionary;

import java.util.Collection;
import org.alfresco.cmis.CMISScope;
import org.alfresco.cmis.CMISTypeId;
import org.alfresco.cmis.dictionary.CMISAbstractDictionaryService;
import org.alfresco.cmis.dictionary.CMISAbstractTypeDefinition;
import org.alfresco.cmis.dictionary.CMISDocumentTypeDefinition;
import org.alfresco.cmis.dictionary.CMISFolderTypeDefinition;
import org.alfresco.cmis.dictionary.CMISObjectTypeDefinition;
import org.alfresco.cmis.dictionary.CMISPolicyTypeDefinition;
import org.alfresco.cmis.dictionary.CMISRelationshipTypeDefinition;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISStrictDictionaryService
extends CMISAbstractDictionaryService {
    @Override
    protected void createDefinitions(CMISAbstractDictionaryService.DictionaryRegistry registry) {
        this.createTypeDefs(registry, this.dictionaryService.getAllTypes());
        this.createAssocDefs(registry, this.dictionaryService.getAllAssociations());
        this.createTypeDefs(registry, this.dictionaryService.getAllAspects());
    }

    private void createTypeDefs(CMISAbstractDictionaryService.DictionaryRegistry registry, Collection<QName> classQNames) {
        for (QName classQName : classQNames) {
            CMISTypeId typeId;
            if (this.cmisMapping.isRemappedType(classQName) || (typeId = this.cmisMapping.getCmisTypeId(classQName)) == null) continue;
            ClassDefinition classDef = this.dictionaryService.getClass(this.cmisMapping.getCmisType(typeId.getQName()));
            CMISAbstractTypeDefinition objectTypeDef = null;
            if (typeId.getScope() == CMISScope.DOCUMENT) {
                objectTypeDef = new CMISDocumentTypeDefinition(this.cmisMapping, typeId, classDef);
            } else if (typeId.getScope() == CMISScope.FOLDER) {
                boolean isSystem = this.dictionaryService.isSubClass(classDef.getName(), ContentModel.TYPE_SYSTEM_FOLDER);
                objectTypeDef = new CMISFolderTypeDefinition(this.cmisMapping, typeId, classDef, isSystem);
            } else if (typeId.getScope() == CMISScope.RELATIONSHIP) {
                AssociationDefinition assocDef = this.dictionaryService.getAssociation(classQName);
                objectTypeDef = new CMISRelationshipTypeDefinition(this.cmisMapping, typeId, classDef, assocDef);
            } else if (typeId.getScope() == CMISScope.POLICY) {
                objectTypeDef = new CMISPolicyTypeDefinition(this.cmisMapping, typeId, classDef);
            } else if (typeId.getScope() == CMISScope.OBJECT) {
                objectTypeDef = new CMISObjectTypeDefinition(this.cmisMapping, typeId, classDef, false);
            }
            registry.registerTypeDefinition(objectTypeDef);
        }
    }

    private void createAssocDefs(CMISAbstractDictionaryService.DictionaryRegistry registry, Collection<QName> classQNames) {
        for (QName classQName : classQNames) {
            if (!this.cmisMapping.isValidCmisRelationship(classQName)) continue;
            CMISTypeId typeId = this.cmisMapping.getCmisTypeId(CMISScope.RELATIONSHIP, classQName);
            AssociationDefinition assocDef = this.dictionaryService.getAssociation(classQName);
            CMISRelationshipTypeDefinition objectTypeDef = new CMISRelationshipTypeDefinition(this.cmisMapping, typeId, null, assocDef);
            registry.registerTypeDefinition(objectTypeDef);
        }
    }
}

