/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.mapping;

import java.io.Serializable;
import java.util.Collection;
import org.alfresco.cmis.CMISQueryException;
import org.alfresco.cmis.CMISScope;
import org.alfresco.cmis.CMISTypeDefinition;
import org.alfresco.cmis.mapping.AbstractProperty;
import org.alfresco.repo.search.impl.lucene.AnalysisMode;
import org.alfresco.repo.search.impl.lucene.LuceneFunction;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.repo.search.impl.querymodel.PredicateMode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseTypeIdProperty
extends AbstractProperty {
    public BaseTypeIdProperty(ServiceRegistry serviceRegistry) {
        super(serviceRegistry, "cmis:baseTypeId");
    }

    @Override
    public Serializable getValue(NodeRef nodeRef) {
        QName type = this.getServiceRegistry().getNodeService().getType(nodeRef);
        return this.getServiceRegistry().getCMISDictionaryService().findTypeForClass(type, new CMISScope[0]).getBaseType().getTypeId().getId();
    }

    @Override
    public Serializable getValue(AssociationRef assocRef) {
        QName type = assocRef.getTypeQName();
        return this.getServiceRegistry().getCMISDictionaryService().findTypeForClass(type, CMISScope.RELATIONSHIP).getBaseType().getTypeId().getId();
    }

    @Override
    public Query buildLuceneEquality(LuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        return lqp.getFieldQuery("TYPE", this.getBaseType(this.getValueAsString(value)), AnalysisMode.IDENTIFIER, luceneFunction);
    }

    @Override
    public Query buildLuceneInequality(LuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        return lqp.getDoesNotMatchFieldQuery("TYPE", this.getBaseType(this.getValueAsString(value)), AnalysisMode.IDENTIFIER, luceneFunction);
    }

    @Override
    public Query buildLuceneIn(LuceneQueryParser lqp, Collection<Serializable> values, Boolean not, PredicateMode mode) throws ParseException {
        String field = "TYPE";
        Collection asStrings = DefaultTypeConverter.INSTANCE.convert(String.class, values);
        if (asStrings.size() == 0) {
            if (not.booleanValue()) {
                return new MatchAllDocsQuery();
            }
            return new TermQuery(new Term("NO_TOKENS", "__"));
        }
        if (asStrings.size() == 1) {
            String value = (String)asStrings.iterator().next();
            if (not.booleanValue()) {
                return lqp.getDoesNotMatchFieldQuery(field, this.getBaseType(value), AnalysisMode.IDENTIFIER, LuceneFunction.FIELD);
            }
            return lqp.getFieldQuery(field, this.getBaseType(value), AnalysisMode.IDENTIFIER, LuceneFunction.FIELD);
        }
        BooleanQuery booleanQuery = new BooleanQuery();
        if (not.booleanValue()) {
            booleanQuery.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
        }
        for (String value : asStrings) {
            Query any = lqp.getFieldQuery(field, this.getBaseType(value), AnalysisMode.IDENTIFIER, LuceneFunction.FIELD);
            if (not.booleanValue()) {
                booleanQuery.add(any, BooleanClause.Occur.MUST_NOT);
                continue;
            }
            booleanQuery.add(any, BooleanClause.Occur.SHOULD);
        }
        return booleanQuery;
    }

    @Override
    public Query buildLuceneExists(LuceneQueryParser lqp, Boolean not) throws ParseException {
        if (not.booleanValue()) {
            return new TermQuery(new Term("NO_TOKENS", "__"));
        }
        return new MatchAllDocsQuery();
    }

    private String getBaseType(String tableName) {
        CMISTypeDefinition typeDef = this.getServiceRegistry().getCMISDictionaryService().findTypeByQueryName(tableName);
        if (typeDef == null) {
            throw new CMISQueryException("Unknwon base type: " + tableName);
        }
        if (!typeDef.getBaseType().equals(typeDef)) {
            throw new CMISQueryException("Not a base type: " + tableName);
        }
        if (!typeDef.isQueryable()) {
            throw new CMISQueryException("Base type is not queryable: " + tableName);
        }
        return typeDef.getTypeId().getQName().toString();
    }

    private String getValueAsString(Serializable value) {
        String asString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
        return asString;
    }
}

