/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.server;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.email.server.EmailServerModel;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AliasableAspect
implements NodeServicePolicies.OnAddAspectPolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy {
    private PolicyComponent policyComponent;
    private NodeService nodeService;
    private SearchService searchService;
    public static final String SEARCH_TEMPLATE = "ASPECT:\"" + EmailServerModel.ASPECT_ALIASABLE + "\" +@" + "emailserver" + "\\:" + EmailServerModel.PROP_ALIAS.getLocalName() + ":\"%s\"";

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void initialise() {
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onAddAspect"), EmailServerModel.ASPECT_ALIASABLE, (Behaviour)new JavaBehaviour(this, "onAddAspect", Behaviour.NotificationFrequency.FIRST_EVENT));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateProperties"), EmailServerModel.ASPECT_ALIASABLE, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAlias(NodeRef nodeRef, String alias) {
        StoreRef storeRef = new StoreRef("workspace", "SpacesStore");
        String query = String.format(SEARCH_TEMPLATE, alias);
        ResultSet res = this.searchService.query(storeRef, "lucene", query);
        try {
            for (int i = 0; i < res.length(); ++i) {
                NodeRef resRef = res.getNodeRef(i);
                Serializable otherAlias = this.nodeService.getProperty(resRef, EmailServerModel.PROP_ALIAS);
                if (resRef.equals((Object)nodeRef) || !alias.equals(otherAlias)) continue;
                throw new AlfrescoRuntimeException("Node with alias=\"" + alias + "\" already exists. Duplicate isn't allowed.");
            }
        }
        finally {
            res.close();
        }
    }

    @Override
    public void onAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        Serializable alias = this.nodeService.getProperty(nodeRef, EmailServerModel.PROP_ALIAS);
        if (alias != null) {
            this.checkAlias(nodeRef, alias.toString());
        }
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        Serializable alias = after.get(EmailServerModel.PROP_ALIAS);
        if (alias != null) {
            this.checkAlias(nodeRef, alias.toString());
        }
    }
}

