/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.server.handler;

import java.util.HashMap;
import java.util.List;
import org.alfresco.email.server.handler.AbstractForumEmailMessageHandler;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ForumModel;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.email.EmailMessage;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;

public class DocumentEmailMessageHandler
extends AbstractForumEmailMessageHandler {
    private static final String forumNodeName = "EmailForum";

    public void processMessage(NodeRef contentNodeRef, EmailMessage message) {
        NodeRef topicNodeRef;
        NodeRef spaceNodeRef;
        String messageSubject = message.getSubject() != null ? message.getSubject() : "EMPTY_SUBJECT_" + System.currentTimeMillis();
        QName nodeTypeQName = this.getNodeService().getType(contentNodeRef);
        DictionaryService dictionaryService = this.getDictionaryService();
        if (dictionaryService.isSubClass(nodeTypeQName, ContentModel.TYPE_CONTENT)) {
            spaceNodeRef = this.getNodeService().getPrimaryParent(contentNodeRef).getParentRef();
            NodeRef forumNode = this.getForumNode(contentNodeRef);
            if (forumNode == null) {
                forumNode = this.addForumNode(contentNodeRef);
            }
            if ((topicNodeRef = this.getTopicNode(forumNode, messageSubject)) == null) {
                topicNodeRef = this.addTopicNode(forumNode, messageSubject);
            }
        } else {
            throw new AlfrescoRuntimeException("\nMessage handler " + this.getClass().getName() + " cannot handle type " + nodeTypeQName + ".\n" + "Check the message handler mappings.");
        }
        NodeRef postNodeRef = this.addPostNode(topicNodeRef, message);
        this.addAttachments(spaceNodeRef, postNodeRef, message);
    }

    private NodeRef addForumNode(NodeRef nodeRef) {
        NodeService nodeService = this.getNodeService();
        if (!nodeService.hasAspect(nodeRef, ForumModel.ASPECT_DISCUSSABLE)) {
            nodeService.addAspect(nodeRef, ForumModel.ASPECT_DISCUSSABLE, null);
        }
        HashMap<QName, String> properties = new HashMap<QName, String>(1);
        properties.put(ContentModel.PROP_NAME, forumNodeName);
        ChildAssociationRef childAssoc = nodeService.createNode(nodeRef, ForumModel.ASSOC_DISCUSSION, ForumModel.ASSOC_DISCUSSION, ForumModel.TYPE_FORUM, properties);
        NodeRef forumNode = childAssoc.getChildRef();
        properties.clear();
        properties.put(ApplicationModel.PROP_ICON, "forum");
        nodeService.addAspect(forumNode, ApplicationModel.ASPECT_UIFACETS, properties);
        return forumNode;
    }

    private NodeRef getForumNode(NodeRef nodeRef) {
        if (this.getNodeService().hasAspect(nodeRef, ForumModel.ASPECT_DISCUSSABLE)) {
            List assocRefList = this.getNodeService().getChildAssocs(nodeRef);
            for (ChildAssociationRef assocRef : assocRefList) {
                QName nodeTypeName = this.getNodeService().getType(assocRef.getChildRef());
                if (!nodeTypeName.equals((Object)ForumModel.TYPE_FORUM)) continue;
                return assocRef.getChildRef();
            }
        }
        return null;
    }
}

