/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.avm;

import org.alfresco.jlan.server.filesys.FileAttribute;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.SearchContext;
import org.alfresco.jlan.util.WildCard;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;

public class AVMSearchContext
extends SearchContext {
    private AVMNodeDescriptor[] m_fileList;
    private int m_fileIdx;
    private int m_attrib;
    private WildCard m_filter;
    private String m_parentPath;
    private boolean m_readOnly;

    public AVMSearchContext(AVMNodeDescriptor[] fileList, int attrib, WildCard filter, String parentPath, boolean readOnly) {
        this.m_attrib = attrib;
        this.m_filter = filter;
        this.m_fileList = fileList;
        this.m_parentPath = parentPath;
        if (this.m_parentPath != null && !this.m_parentPath.endsWith("\\")) {
            this.m_parentPath = this.m_parentPath + "\\";
        }
        this.m_readOnly = readOnly;
    }

    public boolean hasMoreFiles() {
        return this.m_fileIdx < this.m_fileList.length;
    }

    public boolean nextFileInfo(FileInfo info) {
        if (this.m_fileIdx >= this.m_fileList.length) {
            return false;
        }
        boolean foundMatch = false;
        AVMNodeDescriptor curFile = null;
        while (!foundMatch && this.m_fileIdx < this.m_fileList.length) {
            if (!this.m_filter.matchesPattern((curFile = this.m_fileList[this.m_fileIdx++]).getName())) continue;
            if (FileAttribute.hasAttribute((int)this.m_attrib, (int)16) && curFile.isDirectory()) {
                foundMatch = true;
            } else if (curFile.isFile()) {
                foundMatch = true;
            }
            if (foundMatch || ++this.m_fileIdx >= this.m_fileList.length) continue;
            curFile = this.m_fileList[this.m_fileIdx];
        }
        if (foundMatch) {
            info.setFileName(curFile.getName());
            if (curFile.isFile()) {
                info.setFileSize(curFile.getLength());
                info.setAllocationSize(curFile.getLength() + 512L & 0xFFFFFFFFFFFFFE00L);
            } else {
                info.setFileSize(0L);
            }
            info.setAccessDateTime(curFile.getAccessDate());
            info.setCreationDateTime(curFile.getCreateDate());
            info.setModifyDateTime(curFile.getModDate());
            int attr = 0;
            if (curFile.isDirectory()) {
                attr += 16;
            }
            if (curFile.getName().startsWith(".") || curFile.getName().equalsIgnoreCase("Desktop.ini") || curFile.getName().equalsIgnoreCase("Thumbs.db")) {
                attr += 2;
            }
            if (this.isReadOnly()) {
                ++attr;
            }
            if (attr == 0) {
                attr = 128;
            }
            info.setFileAttributes(attr);
            StringBuilder pathStr = new StringBuilder(this.m_parentPath);
            pathStr.append(curFile.getName());
            info.setFileId(pathStr.toString().hashCode());
        }
        return foundMatch;
    }

    public String nextFileName() {
        while (this.m_fileIdx < this.m_fileList.length) {
            String fname;
            if (!this.m_filter.matchesPattern(fname = this.m_fileList[this.m_fileIdx++].getName())) continue;
            return fname;
        }
        return null;
    }

    public int numberOfEntries() {
        return this.m_fileList.length;
    }

    public int getResumeId() {
        return this.m_fileIdx;
    }

    public boolean restartAt(int resumeId) {
        int resId = resumeId - 1;
        if (resId < 0 || resId >= this.m_fileList.length) {
            return false;
        }
        this.m_fileIdx = resId;
        return true;
    }

    public boolean restartAt(FileInfo info) {
        int curFileIdx = this.m_fileIdx;
        if (this.m_fileIdx >= this.m_fileList.length) {
            this.m_fileIdx = this.m_fileList.length - 1;
        }
        while (this.m_fileIdx > 0) {
            if (this.m_fileList[this.m_fileIdx].getName().equals(info.getFileName())) {
                return true;
            }
            --this.m_fileIdx;
        }
        this.m_fileIdx = curFileIdx;
        return false;
    }

    public final boolean isReadOnly() {
        return this.m_readOnly;
    }

    public final void setReadOnly(boolean readOnly) {
        this.m_readOnly = readOnly;
    }
}

