/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.avm;

import java.util.Hashtable;
import org.alfresco.filesys.avm.StorePseudoFile;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.repository.NodeRef;

public class WebProjectStorePseudoFile
extends StorePseudoFile {
    public static final int RoleNone = 0;
    public static final int RolePublisher = 1;
    public static final int RoleContentManager = 2;
    private NodeRef m_noderef;
    private Hashtable<String, Integer> m_users;

    public WebProjectStorePseudoFile(AVMStoreDescriptor storeDesc, String relPath, NodeRef nodeRef) {
        super(storeDesc, relPath, 5);
        FileInfo fInfo = new FileInfo(storeDesc.getName(), 0L, 17);
        fInfo.setCreationDateTime(storeDesc.getCreateDate());
        fInfo.setModifyDateTime(storeDesc.getCreateDate());
        fInfo.setAccessDateTime(storeDesc.getCreateDate());
        fInfo.setChangeDateTime(storeDesc.getCreateDate());
        fInfo.setPath(relPath);
        fInfo.setFileId(relPath.hashCode());
        this.setFileInfo(fInfo);
        this.m_noderef = nodeRef;
    }

    public WebProjectStorePseudoFile(String storeName, String relPath, NodeRef nodeRef) {
        super(storeName, relPath);
        FileInfo fInfo = new FileInfo(storeName, 0L, 17);
        long timeNow = System.currentTimeMillis();
        fInfo.setCreationDateTime(timeNow);
        fInfo.setModifyDateTime(timeNow);
        fInfo.setAccessDateTime(timeNow);
        fInfo.setChangeDateTime(timeNow);
        fInfo.setPath(relPath);
        fInfo.setFileId(relPath.hashCode());
        this.setFileInfo(fInfo);
        this.m_noderef = nodeRef;
    }

    public final boolean hasNodeRef() {
        return this.m_noderef != null;
    }

    public final NodeRef getNodeRef() {
        return this.m_noderef;
    }

    public final void setNodeRef(NodeRef node) {
        this.m_noderef = node;
    }

    public final int getUserRole(String userName) {
        if (this.m_users == null) {
            return 0;
        }
        Integer role = this.m_users.get(userName);
        return role != null ? role : 0;
    }

    public final void addUserRole(String userName, int role) {
        if (this.m_users == null) {
            this.m_users = new Hashtable();
        }
        this.m_users.put(userName, new Integer(role));
    }

    public final void removeUserRole(String userName) {
        if (this.m_users != null) {
            this.m_users.remove(userName);
        }
    }
}

