/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.FileNotFoundException;
import org.alfresco.filesys.alfresco.AlfrescoClientInfo;
import org.alfresco.filesys.alfresco.AlfrescoContext;
import org.alfresco.filesys.alfresco.AlfrescoDiskDriver;
import org.alfresco.filesys.alfresco.DesktopAction;
import org.alfresco.filesys.alfresco.DesktopActionTable;
import org.alfresco.filesys.alfresco.DesktopParams;
import org.alfresco.filesys.alfresco.DesktopResponse;
import org.alfresco.filesys.alfresco.DesktopTarget;
import org.alfresco.filesys.alfresco.IOControlHandler;
import org.alfresco.filesys.repo.CifsHelper;
import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.filesys.repo.ContentDiskDriver;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.filesys.IOControlNotImplementedException;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.jlan.smb.nt.NTIOCtl;
import org.alfresco.jlan.util.DataBuffer;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentIOControlHandler
implements IOControlHandler {
    private static final Log logger = LogFactory.getLog(ContentIOControlHandler.class);
    private ContentDiskDriver contentDriver;
    private ContentContext contentContext;

    public void initialize(AlfrescoDiskDriver filesysDriver, AlfrescoContext context) {
        this.contentDriver = (ContentDiskDriver)filesysDriver;
        this.contentContext = (ContentContext)context;
    }

    public final CifsHelper getCifsHelper() {
        return this.contentDriver.getCifsHelper();
    }

    public final AuthenticationService getAuthenticationService() {
        return this.contentDriver.getAuthenticationService();
    }

    public final TransactionService getTransactionService() {
        return this.contentDriver.getTransactionService();
    }

    public final NodeService getNodeService() {
        return this.contentDriver.getNodeService();
    }

    public final ContentDiskDriver getContentDriver() {
        return this.contentDriver;
    }

    public final ContentContext getContentContext() {
        return this.contentContext;
    }

    public DataBuffer processIOControl(SrvSession sess, TreeConnection tree, int ctrlCode, int fid, DataBuffer dataBuf, boolean isFSCtrl, int filter) throws IOControlNotImplementedException, SMBException {
        NetworkFile netFile = tree.findFile(fid);
        if (netFile == null || !netFile.isDirectory()) {
            throw new SMBException(6, -1073741811);
        }
        int devType = NTIOCtl.getDeviceType((int)ctrlCode);
        int ioFunc = NTIOCtl.getFunctionCode((int)ctrlCode);
        if (devType == 9 && ioFunc == 48) {
            return null;
        }
        if (devType != 9 || dataBuf == null) {
            throw new IOControlNotImplementedException();
        }
        if (dataBuf.getLength() < "ALFRESCO".length()) {
            throw new IOControlNotImplementedException("Bad request length");
        }
        String sig = dataBuf.getFixedString("ALFRESCO".length(), false);
        if (sig == null || sig.compareTo("ALFRESCO") != 0) {
            throw new IOControlNotImplementedException("Bad request signature");
        }
        NodeRef folderNode = null;
        try {
            folderNode = this.contentDriver.getNodeForPath(tree, netFile.getFullName());
            if (!this.getCifsHelper().isDirectory(folderNode)) {
                folderNode = null;
            }
        }
        catch (FileNotFoundException ex) {
            folderNode = null;
        }
        if (folderNode == null) {
            throw new SMBException(6, -1073741790);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("IO control func=0x" + Integer.toHexString(ioFunc) + ", fid=" + fid + ", buffer=" + dataBuf));
            logger.debug((Object)("  Folder nodeRef=" + folderNode));
        }
        DataBuffer retBuffer = null;
        switch (ioFunc) {
            case 2048: {
                retBuffer = new DataBuffer("ALFRESCO".length());
                retBuffer.putFixedString("ALFRESCO", "ALFRESCO".length());
                retBuffer.putInt(0);
                retBuffer.putInt(2);
                break;
            }
            case 2049: {
                retBuffer = this.procIOFileStatus(sess, tree, dataBuf, folderNode);
                break;
            }
            case 2052: {
                retBuffer = this.procGetActionInfo(sess, tree, dataBuf, folderNode, netFile);
                break;
            }
            case 2053: {
                retBuffer = this.procRunAction(sess, tree, dataBuf, folderNode, netFile);
                break;
            }
            case 2054: {
                retBuffer = this.procGetAuthTicket(sess, tree, dataBuf, folderNode, netFile);
                break;
            }
            default: {
                throw new IOControlNotImplementedException();
            }
        }
        return retBuffer;
    }

    private final DataBuffer procIOFileStatus(SrvSession sess, TreeConnection tree, DataBuffer reqBuf, NodeRef folderNode) {
        this.contentDriver.beginReadTransaction(sess);
        String fName = reqBuf.getString(true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("  File status, fname=" + fName));
        }
        DataBuffer respBuf = new DataBuffer(256);
        respBuf.putFixedString("ALFRESCO", "ALFRESCO".length());
        NodeRef childNode = null;
        try {
            childNode = this.getCifsHelper().getNodeRef(folderNode, fName);
        }
        catch (FileNotFoundException ex) {
            // empty catch block
        }
        if (childNode == null) {
            respBuf.putInt(2);
            return respBuf;
        }
        if (this.getCifsHelper().isDirectory(childNode)) {
            respBuf.putInt(0);
            respBuf.putInt(1);
        } else {
            respBuf.putInt(0);
            respBuf.putInt(0);
            if (this.getNodeService().hasAspect(childNode, ContentModel.ASPECT_WORKING_COPY)) {
                NodeRef fromNode;
                respBuf.putInt(1);
                String owner = (String)((Object)this.getNodeService().getProperty(childNode, ContentModel.PROP_WORKING_COPY_OWNER));
                String copiedFrom = null;
                if (this.getNodeService().hasAspect(childNode, ContentModel.ASPECT_COPIEDFROM) && (fromNode = (NodeRef)this.getNodeService().getProperty(childNode, ContentModel.PROP_COPY_REFERENCE)) != null) {
                    copiedFrom = (String)((Object)this.getNodeService().getProperty(fromNode, ContentModel.PROP_NAME));
                }
                respBuf.putString(owner != null ? owner : "", true, true);
                respBuf.putString(copiedFrom != null ? copiedFrom : "", true, true);
            } else {
                respBuf.putInt(0);
            }
            if (this.getNodeService().hasAspect(childNode, ContentModel.ASPECT_LOCKABLE)) {
                String lockTypeStr = (String)((Object)this.getNodeService().getProperty(childNode, ContentModel.PROP_LOCK_TYPE));
                String lockOwner = null;
                if (lockTypeStr != null) {
                    lockOwner = (String)((Object)this.getNodeService().getProperty(childNode, ContentModel.PROP_LOCK_OWNER));
                }
                if (lockTypeStr == null) {
                    respBuf.putInt(0);
                } else {
                    LockType lockType = LockType.valueOf(lockTypeStr);
                    respBuf.putInt(lockType == LockType.READ_ONLY_LOCK ? 1 : 2);
                    respBuf.putString(lockOwner != null ? lockOwner : "", true, true);
                }
            } else {
                respBuf.putInt(0);
            }
            ContentData contentData = (ContentData)this.getNodeService().getProperty(childNode, ContentModel.PROP_CONTENT);
            if (contentData != null) {
                String mimeType = contentData.getMimetype();
                respBuf.putInt(1);
                respBuf.putLong(contentData.getSize());
                respBuf.putString(mimeType != null ? mimeType : "", true, true);
            } else {
                respBuf.putInt(0);
            }
        }
        return respBuf;
    }

    private final DataBuffer procGetActionInfo(SrvSession sess, TreeConnection tree, DataBuffer reqBuf, NodeRef folderNode, NetworkFile netFile) {
        String exeName = reqBuf.getString(true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("  Get action info, exe=" + exeName));
        }
        DataBuffer respBuf = new DataBuffer(256);
        respBuf.putFixedString("ALFRESCO", "ALFRESCO".length());
        DesktopActionTable deskActions = this.contentContext.getDesktopActions();
        if (deskActions == null) {
            respBuf.putInt(6);
            return respBuf;
        }
        DesktopAction deskAction = deskActions.getActionViaPseudoName(exeName);
        if (deskAction == null) {
            respBuf.putInt(6);
            return respBuf;
        }
        respBuf.putInt(0);
        respBuf.putString(deskAction.getName(), true);
        respBuf.putInt(deskAction.getAttributes());
        respBuf.putInt(deskAction.getPreProcessActions());
        String confirmStr = deskAction.getConfirmationString();
        respBuf.putString(confirmStr != null ? confirmStr : "", true);
        return respBuf;
    }

    private final DataBuffer procRunAction(SrvSession sess, TreeConnection tree, DataBuffer reqBuf, NodeRef folderNode, NetworkFile netFile) {
        String actionName = reqBuf.getString(true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("  Run action, name=" + actionName));
        }
        DataBuffer respBuf = new DataBuffer(256);
        respBuf.putFixedString("ALFRESCO", "ALFRESCO".length());
        DesktopActionTable deskActions = this.contentContext.getDesktopActions();
        DesktopAction action = null;
        if (deskActions != null) {
            action = deskActions.getAction(actionName);
        }
        if (action == null) {
            respBuf.putInt(6);
            respBuf.putString("", true);
            return respBuf;
        }
        this.contentDriver.beginReadTransaction(sess);
        this.getTicketForClient(sess);
        DesktopParams deskParams = new DesktopParams(sess, this.contentDriver, folderNode, netFile);
        for (int targetCnt = reqBuf.getInt(); reqBuf.getAvailableLength() > 4 && targetCnt > 0; --targetCnt) {
            int typ = reqBuf.getInt();
            String path = reqBuf.getString(true);
            DesktopTarget target = new DesktopTarget(typ, path);
            deskParams.addTarget(target);
            NodeRef childNode = null;
            try {
                childNode = path.startsWith("\\") ? this.getCifsHelper().getNodeRef(this.contentContext.getRootNode(), path) : this.getCifsHelper().getNodeRef(folderNode, path);
            }
            catch (FileNotFoundException ex) {
                // empty catch block
            }
            if (childNode == null) {
                respBuf.putInt(2);
                respBuf.putString("Cannot find noderef for path " + path, true);
                return respBuf;
            }
            target.setNode(childNode);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("    Desktop params: " + deskParams.numberOfTargetNodes()));
            for (int i = 0; i < deskParams.numberOfTargetNodes(); ++i) {
                DesktopTarget target = deskParams.getTarget(i);
                logger.debug((Object)("      " + target));
            }
        }
        DesktopResponse deskResponse = null;
        try {
            deskResponse = action.runAction(deskParams);
        }
        catch (Exception ex) {
            deskResponse = new DesktopResponse(1, ex.getMessage());
        }
        if (deskResponse != null) {
            respBuf.putInt(deskResponse.getStatus());
            respBuf.putString(deskResponse.hasStatusMessage() ? deskResponse.getStatusMessage() : "", true);
        } else {
            respBuf.putInt(1);
            respBuf.putString("Action did not return response", true);
        }
        return respBuf;
    }

    private final DataBuffer procGetAuthTicket(SrvSession sess, TreeConnection tree, DataBuffer reqBuf, NodeRef folderNode, NetworkFile netFile) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"  Get Auth Ticket");
        }
        DataBuffer respBuf = new DataBuffer(256);
        respBuf.putFixedString("ALFRESCO", "ALFRESCO".length());
        this.contentDriver.beginReadTransaction(sess);
        this.getTicketForClient(sess);
        AlfrescoClientInfo cInfo = (AlfrescoClientInfo)sess.getClientInformation();
        if (cInfo != null && cInfo.getAuthenticationTicket() != null) {
            respBuf.putInt(9);
            respBuf.putString(cInfo.getAuthenticationTicket(), true);
        } else {
            respBuf.putInt(1);
            respBuf.putString("Client information invalid", true);
        }
        return respBuf;
    }

    private final void getTicketForClient(SrvSession sess) {
        boolean needTicket;
        AlfrescoClientInfo cInfo;
        block8: {
            cInfo = (AlfrescoClientInfo)sess.getClientInformation();
            if (cInfo == null) {
                return;
            }
            needTicket = true;
            if (cInfo.hasAuthenticationTicket()) {
                try {
                    this.getAuthenticationService().validate(cInfo.getAuthenticationTicket());
                    needTicket = false;
                }
                catch (AuthenticationException ex) {
                    block7: {
                        try {
                            this.getAuthenticationService().invalidateTicket(cInfo.getAuthenticationTicket());
                            cInfo.setAuthenticationTicket(null);
                        }
                        catch (Exception ex2) {
                            if (!logger.isDebugEnabled()) break block7;
                            logger.debug((Object)"Error during invalidate ticket", (Throwable)ex2);
                        }
                    }
                    if (!logger.isDebugEnabled()) break block8;
                    logger.debug((Object)"Auth ticket expired or invalid");
                }
            }
        }
        if (needTicket) {
            String ticket = this.getAuthenticationService().getCurrentTicket();
            cInfo.setAuthenticationTicket(ticket);
        }
    }
}

