/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.IOException;
import java.util.HashMap;
import org.alfresco.filesys.repo.ContentDiskDriver;
import org.alfresco.filesys.repo.UserQuotaDetails;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskFullException;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.server.filesys.quota.QuotaManager;
import org.alfresco.jlan.server.filesys.quota.QuotaManagerException;
import org.alfresco.jlan.util.StringList;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.usage.ContentUsageService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentQuotaManager
implements QuotaManager,
Runnable {
    private static final Log logger = LogFactory.getLog(ContentQuotaManager.class);
    private static final long UserQuotaCheckInterval = 60000L;
    private static final long UserQuotaExpireInterval = 300000L;
    private ContentDiskDriver m_filesys;
    private ContentUsageService m_usageService;
    private HashMap<String, UserQuotaDetails> m_liveUsage;
    private Object m_addDetailsLock = new Object();
    private Thread m_thread;
    private boolean m_shutdown;

    public final ContentUsageService getUsageService() {
        return this.m_usageService;
    }

    public final void setUsageService(ContentUsageService usageService) {
        this.m_usageService = usageService;
    }

    public long getAvailableFreeSpace() {
        long freeSpace = this.m_filesys.getContentService().getStoreFreeSpace();
        if (freeSpace == -1L) {
            freeSpace = 0x8000000000L;
        }
        return freeSpace;
    }

    public long getUserFreeSpace(SrvSession sess, TreeConnection tree) {
        if (!this.m_usageService.getEnabled()) {
            return 0L;
        }
        UserQuotaDetails userQuota = this.getQuotaDetails(sess, true);
        if (userQuota != null) {
            return userQuota.getAvailableSpace();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long allocateSpace(SrvSession sess, TreeConnection tree, NetworkFile file, long alloc) throws IOException {
        if (!this.m_usageService.getEnabled()) {
            return alloc;
        }
        UserQuotaDetails userQuota = this.getQuotaDetails(sess, true);
        long allowedAlloc = 0L;
        if (userQuota != null) {
            if (userQuota.hasUserQuota()) {
                UserQuotaDetails userQuotaDetails = userQuota;
                synchronized (userQuotaDetails) {
                    if (alloc > 0L && userQuota.getAvailableSpace() >= alloc) {
                        userQuota.addToCurrentUsage(alloc);
                        allowedAlloc = alloc;
                    }
                }
            } else {
                UserQuotaDetails userQuotaDetails = userQuota;
                synchronized (userQuotaDetails) {
                    userQuota.addToCurrentUsage(alloc);
                    allowedAlloc = alloc;
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Failed to allocate " + alloc + " bytes for sess " + sess.getUniqueId()));
        }
        if (allowedAlloc < alloc) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Allocation failed userQuota=" + userQuota));
            }
            throw new DiskFullException();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Allocated " + alloc + " bytes, userQuota=" + userQuota));
        }
        return allowedAlloc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSpace(SrvSession sess, TreeConnection tree, int fid, String path, long alloc) throws IOException {
        if (!this.m_usageService.getEnabled()) {
            return;
        }
        UserQuotaDetails userQuota = this.getQuotaDetails(sess, true);
        if (userQuota != null) {
            UserQuotaDetails userQuotaDetails = userQuota;
            synchronized (userQuotaDetails) {
                userQuota.subtractFromCurrentUsage(alloc);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Released " + alloc + " bytes, userQuota=" + userQuota));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Failed to release " + alloc + " bytes for sess " + sess.getUniqueId()));
        }
    }

    public void startManager(DiskInterface disk, DiskDeviceContext ctx) throws QuotaManagerException {
        if (!(disk instanceof ContentDiskDriver)) {
            throw new QuotaManagerException("Invalid filesystem type, " + disk.getClass().getName());
        }
        this.m_filesys = (ContentDiskDriver)disk;
        this.m_liveUsage = new HashMap();
        this.m_thread = new Thread(this);
        this.m_thread.setDaemon(true);
        this.m_thread.setName("ContentQuotaManagerChecker");
        this.m_thread.start();
    }

    public void stopManager(DiskInterface disk, DiskDeviceContext ctx) throws QuotaManagerException {
        this.m_liveUsage.clear();
        this.m_shutdown = true;
        this.m_thread.interrupt();
    }

    private UserQuotaDetails getQuotaDetails(SrvSession sess, boolean loadDetails) {
        UserQuotaDetails userQuota;
        block3: {
            userQuota = null;
            if (sess != null && sess.hasClientInformation() && (userQuota = this.m_liveUsage.get(AuthenticationUtil.getFullyAuthenticatedUser())) == null && loadDetails) {
                try {
                    userQuota = this.loadUsageDetails(sess);
                }
                catch (QuotaManagerException ex) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug((Object)ex);
                }
            }
        }
        return userQuota;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserQuotaDetails loadUsageDetails(SrvSession sess) throws QuotaManagerException {
        if (sess == null || !sess.hasClientInformation()) {
            throw new QuotaManagerException("No session/client information");
        }
        UserQuotaDetails quotaDetails = null;
        String userName = null;
        try {
            userName = AuthenticationUtil.getFullyAuthenticatedUser();
            if (userName == null || userName.length() == 0) {
                throw new QuotaManagerException("No user name for client");
            }
            this.m_filesys.beginReadTransaction(sess);
            long userQuota = this.m_usageService.getUserQuota(userName);
            long userUsage = this.m_usageService.getUserUsage(userName);
            quotaDetails = new UserQuotaDetails(userName, userQuota);
            if (userUsage > 0L) {
                quotaDetails.setCurrentUsage(userUsage);
            }
            Object object = this.m_addDetailsLock;
            synchronized (object) {
                UserQuotaDetails details = this.m_liveUsage.get(userName);
                if (details != null) {
                    quotaDetails = details;
                } else {
                    this.m_liveUsage.put(userName, quotaDetails);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Added live usage tracking " + quotaDetails));
            }
        }
        catch (Exception ex) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)ex);
            }
            throw new QuotaManagerException("Failed to load usage for " + userName + ", " + ex);
        }
        return quotaDetails;
    }

    public void run() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Content quota manager checker thread starting");
        }
        StringList removeNameList = new StringList();
        this.m_shutdown = false;
        while (!this.m_shutdown) {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (this.m_shutdown) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Content quota manager checker thread closing");
                }
                return;
            }
            if (this.m_liveUsage == null || this.m_liveUsage.size() <= 0) continue;
            try {
                UserQuotaDetails quotaDetails;
                long checkTime = System.currentTimeMillis() - 300000L;
                removeNameList.remoteAllStrings();
                for (String userName : this.m_liveUsage.keySet()) {
                    quotaDetails = this.m_liveUsage.get(userName);
                    if (quotaDetails.getLastUpdated() >= checkTime) continue;
                    removeNameList.addString(userName);
                }
                while (removeNameList.numberOfStrings() > 0) {
                    String userName;
                    userName = removeNameList.removeStringAt(0);
                    quotaDetails = this.m_liveUsage.remove(userName);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Removed inactive usage tracking, " + quotaDetails));
                }
            }
            catch (Exception ex) {
                if (this.m_shutdown) continue;
                logger.debug((Object)ex);
            }
        }
    }
}

