/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo.desk;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.alfresco.filesys.alfresco.AlfrescoContext;
import org.alfresco.filesys.alfresco.AlfrescoDiskDriver;
import org.alfresco.filesys.alfresco.DesktopAction;
import org.alfresco.filesys.alfresco.DesktopActionException;
import org.alfresco.filesys.alfresco.DesktopParams;
import org.alfresco.filesys.alfresco.DesktopResponse;
import org.alfresco.jlan.server.filesys.DiskSharedDevice;
import org.alfresco.scripts.ScriptException;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.util.ResourceFinder;
import org.springframework.core.io.Resource;
import org.springframework.extensions.config.ConfigElement;

public class JavaScriptDesktopAction
extends DesktopAction {
    private String m_scriptName;
    private String m_scriptPath;
    private long m_lastModified;
    private String m_script;

    public JavaScriptDesktopAction() {
        super(0, 0);
    }

    public String getConfirmationString() {
        return "Run Javascript action";
    }

    public void standardInitialize(ConfigElement global, ConfigElement config, DiskSharedDevice fileSys) throws DesktopActionException {
        super.standardInitialize(global, config, fileSys);
        ConfigElement elem = config.getChild("script");
        if (elem == null || elem.getValue().length() <= 0) {
            throw new DesktopActionException("Script name not specified");
        }
        this.setScriptName(elem.getValue());
        elem = config.getChild("attributes");
        if (elem != null) {
            if (elem.getValue().length() == 0) {
                throw new DesktopActionException("Empty desktop action attributes");
            }
            this.setAttributeList(elem.getValue());
        }
        if ((elem = config.getChild("preprocess")) != null) {
            this.setPreprocess(elem.getValue());
        }
    }

    public void initializeAction(AlfrescoDiskDriver filesysDriver, AlfrescoContext filesysContext) throws DesktopActionException {
        File scriptFile;
        super.initializeAction(filesysDriver, filesysContext);
        if (this.m_scriptName == null || this.m_scriptName.length() == 0) {
            throw new DesktopActionException("Script name not specified");
        }
        Resource resource = new ResourceFinder().getResource(this.m_scriptName);
        if (!resource.exists()) {
            throw new DesktopActionException("Failed to find script on classpath, " + this.getScriptName());
        }
        try {
            scriptFile = resource.getFile();
            if (!scriptFile.exists()) {
                throw new DesktopActionException("Script file not found, " + this.m_scriptName);
            }
        }
        catch (IOException e) {
            throw new DesktopActionException("Unable to resolve script as a file, " + resource.getDescription());
        }
        this.m_scriptPath = scriptFile.getAbsolutePath();
        this.m_lastModified = scriptFile.lastModified();
        try {
            this.loadScript(scriptFile);
        }
        catch (IOException ex) {
            throw new DesktopActionException("Failed to load script, " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DesktopResponse runAction(DesktopParams params) throws DesktopActionException {
        File scriptFile = new File(this.m_scriptPath);
        JavaScriptDesktopAction javaScriptDesktopAction = this;
        synchronized (javaScriptDesktopAction) {
            if (scriptFile.lastModified() != this.m_lastModified) {
                this.m_lastModified = scriptFile.lastModified();
                try {
                    this.loadScript(scriptFile);
                }
                catch (IOException ex) {
                    return new DesktopResponse(1, "Failed to reload script file, " + this.getScriptName());
                }
            }
        }
        final ScriptService scriptService = this.getServiceRegistry().getScriptService();
        if (scriptService != null) {
            final HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("deskParams", params);
            model.put("out", System.out);
            if (this.hasWebappURL()) {
                model.put("webURL", this.getWebappURL());
            }
            try {
                return params.getDriver().doInWriteTransaction(params.getSession(), new AlfrescoDiskDriver.CallableIO<DesktopResponse>(){

                    @Override
                    public DesktopResponse call() throws IOException {
                        DesktopResponse response = new DesktopResponse(0);
                        Object result = scriptService.executeScriptString(JavaScriptDesktopAction.this.getScript(), model);
                        if (result != null) {
                            if (result instanceof DesktopResponse) {
                                response = (DesktopResponse)((Object)result);
                            } else if (result instanceof Double) {
                                Double jsSts = (Double)result;
                                response.setStatus(jsSts.intValue(), "");
                            } else if (result instanceof String) {
                                String responseMsg = (String)result;
                                StringTokenizer token = new StringTokenizer(responseMsg, ",");
                                String stsToken = token.nextToken();
                                String msgToken = token.nextToken();
                                int sts = -1;
                                try {
                                    sts = Integer.parseInt(stsToken);
                                }
                                catch (NumberFormatException ex) {
                                    response.setStatus(1, "Bad response from script");
                                }
                                response.setStatus(sts, msgToken != null ? msgToken : "");
                            }
                        }
                        return response;
                    }
                });
            }
            catch (ScriptException ex) {
                return new DesktopResponse(1, ex.getMessage());
            }
            catch (IOException ex) {
                return new DesktopResponse(1, ex.getMessage());
            }
        }
        return new DesktopResponse(1, "Script service not available");
    }

    public final String getScriptName() {
        return this.m_scriptName;
    }

    public final String getScript() {
        return this.m_script;
    }

    public final void setScriptName(String name) {
        this.m_scriptName = name;
    }

    public void setAttributeList(String attributes) throws DesktopActionException {
        if (attributes == null || attributes.length() == 0) {
            return;
        }
        int attr = 0;
        StringTokenizer tokens = new StringTokenizer(attributes, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equalsIgnoreCase("targetFiles")) {
                attr |= 1;
                continue;
            }
            if (token.equalsIgnoreCase("targetFolders")) {
                attr |= 2;
                continue;
            }
            if (token.equalsIgnoreCase("clientFiles")) {
                attr |= 4;
                continue;
            }
            if (token.equalsIgnoreCase("clientFolders")) {
                attr |= 8;
                continue;
            }
            if (token.equalsIgnoreCase("alfrescoFiles")) {
                attr |= 0x10;
                continue;
            }
            if (token.equalsIgnoreCase("alfrescoFolders")) {
                attr |= 0x20;
                continue;
            }
            if (token.equalsIgnoreCase("multiplePaths")) {
                attr |= 0x40;
                continue;
            }
            if (token.equalsIgnoreCase("allowNoParams")) {
                attr |= 0x80;
                continue;
            }
            if (token.equalsIgnoreCase("anyFiles")) {
                attr |= 0x15;
                continue;
            }
            if (token.equalsIgnoreCase("anyFolders")) {
                attr |= 0x2A;
                continue;
            }
            if (token.equalsIgnoreCase("anyFilesFolders")) {
                attr |= 0x3F;
                continue;
            }
            throw new DesktopActionException("Unknown attribute, " + token);
        }
        this.setAttributes(attr);
    }

    public void setPreprocess(String preProcessActions) throws DesktopActionException {
        if (preProcessActions == null || preProcessActions.length() == 0) {
            return;
        }
        int pre = 0;
        StringTokenizer tokens = new StringTokenizer(preProcessActions, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equalsIgnoreCase("copyToTarget")) {
                pre |= 1;
                continue;
            }
            if (token.equalsIgnoreCase("confirm")) {
                pre |= 2;
                continue;
            }
            if (token.equalsIgnoreCase("localToWorkingCopy")) {
                pre |= 4;
                continue;
            }
            throw new DesktopActionException("Unknown pre-processing flag, " + token);
        }
        this.setPreProcessActions(pre);
    }

    private final void loadScript(File scriptFile) throws IOException {
        BufferedReader scriptIn = new BufferedReader(new FileReader(scriptFile));
        StringBuilder scriptStr = new StringBuilder((int)scriptFile.length() + 256);
        String inRec = scriptIn.readLine();
        while (inRec != null) {
            scriptStr.append(inRec);
            scriptStr.append("\n");
            inRec = scriptIn.readLine();
        }
        scriptIn.close();
        this.m_script = scriptStr.toString();
    }
}

