/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.util;

import java.util.HashMap;
import org.alfresco.filesys.util.CifsMountException;
import org.alfresco.jlan.util.Platform;
import org.alfresco.util.exec.RuntimeExec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CifsMounter {
    private static final Log logger = LogFactory.getLog(CifsMounter.class);
    public static final int Default = 0;
    public static final int NetBIOS = 1;
    public static final int NativeSMB = 2;
    public static final int Win32NetBIOS = 3;
    private static final String WindowsMountCmd = "net use ${drive} \\\\${srvname}\\${sharename} ${password} /USER:${username}";
    private static final String WindowsUnMountCmd = "net use ${drive} /d";
    private static final String LinuxMountSmbfsCmd = "mount -t smbfs //${srvname}/${sharename} ${mountpoint} -o username=${username},password=${password}";
    private static final String LinuxMountCifsCmd = "mount -t cifs  //${srvname}/${sharename} ${mountpoint} -o username=${username},password=${password}";
    private static final String LinuxMountCifsNBCmd = "mount.cifs //${srvname}/${sharename} ${mountpoint} -o servern=${srvname},port=139,username=${username},password=${password}";
    private static final String LinuxUnMountCmd = "umount ${mountpoint}";
    private static final String MacOSXMountCmd = "mount_smbfs -U ${username} //${password}@${srvname}/${sharename} ${mountpoint}";
    private static final String MacOSXUnMountCmd = "umount ${mountpoint}";
    private String m_srvName;
    private String m_shareName;
    private String m_srvAddr;
    private String m_userName;
    private String m_password;
    private int m_protocolType = 0;
    private int m_port;

    public CifsMounter() {
    }

    public CifsMounter(String srvName, String shareName, String userName, String password) {
        this.setServerName(srvName);
        this.setShareName(shareName);
        this.setUserName(userName);
        this.setPassword(password);
    }

    public void mountFilesystem(String driveLetter, String mountPoint) throws CifsMountException {
        RuntimeExec exec = new RuntimeExec();
        HashMap<String, String> commandMap = new HashMap<String, String>(1);
        HashMap<String, String> defProperties = new HashMap<String, String>(10);
        Platform.Type platform = Platform.isPlatformType();
        switch (platform) {
            case WINDOWS: {
                commandMap.put("Windows.*", WindowsMountCmd);
                break;
            }
            case LINUX: {
                StringBuilder cmd;
                if (this.isProtocolType() == 2 || this.isProtocolType() == 0) {
                    cmd = new StringBuilder(LinuxMountCifsCmd);
                    if (this.getProtocolPort() != 0) {
                        cmd.append(",port=");
                        cmd.append(this.getProtocolPort());
                    }
                    commandMap.put("Linux", cmd.toString());
                    break;
                }
                cmd = new StringBuilder(LinuxMountCifsNBCmd);
                if (this.getServerAddress() != null) {
                    cmd.append(",ip=");
                    cmd.append(this.getServerAddress());
                }
                commandMap.put("Linux", cmd.toString());
                break;
            }
            case MACOSX: {
                commandMap.put("Mac OS X", MacOSXMountCmd);
            }
        }
        exec.setCommandMap(commandMap);
        defProperties.put("drive", driveLetter);
        defProperties.put("srvname", this.getServerName());
        defProperties.put("sharename", this.getShareName());
        defProperties.put("username", this.getUserName());
        defProperties.put("password", this.getPassword());
        defProperties.put("mountpoint", mountPoint);
        exec.setDefaultProperties(defProperties);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Mount CIFS share, cmdLine=" + exec.getCommand()));
        }
        RuntimeExec.ExecutionResult execRes = exec.execute();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Mount result=" + execRes));
        }
        if (!execRes.getSuccess()) {
            throw new CifsMountException(execRes.getExitValue(), execRes.getStdOut(), execRes.getStdErr());
        }
    }

    public void unmountFilesystem(String driveLetter, String mountPoint) throws CifsMountException {
        RuntimeExec exec = new RuntimeExec();
        HashMap<String, String> commandMap = new HashMap<String, String>(1);
        HashMap<String, String> defProperties = new HashMap<String, String>(10);
        Platform.Type platform = Platform.isPlatformType();
        switch (platform) {
            case WINDOWS: {
                commandMap.put("Windows.*", WindowsUnMountCmd);
                break;
            }
            case LINUX: {
                commandMap.put("Linux", "umount ${mountpoint}");
                break;
            }
            case MACOSX: {
                commandMap.put("Mac OS X", "umount ${mountpoint}");
            }
        }
        exec.setCommandMap(commandMap);
        defProperties.put("drive", driveLetter);
        defProperties.put("mountpoint", mountPoint);
        exec.setDefaultProperties(defProperties);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("UnMount CIFS share, cmdLine=" + exec.getCommand()));
        }
        RuntimeExec.ExecutionResult execRes = exec.execute();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("UnMount result=" + execRes));
        }
        if (!execRes.getSuccess()) {
            throw new CifsMountException(execRes.getExitValue(), execRes.getStdOut(), execRes.getStdErr());
        }
    }

    public final String getServerName() {
        return this.m_srvName;
    }

    public final String getServerAddress() {
        return this.m_srvAddr;
    }

    public final String getShareName() {
        return this.m_shareName;
    }

    public final String getUserName() {
        return this.m_userName;
    }

    public final String getPassword() {
        return this.m_password;
    }

    public final int isProtocolType() {
        return this.m_protocolType;
    }

    public final int getProtocolPort() {
        return this.m_port;
    }

    public final void setServerName(String name) {
        this.m_srvName = name;
    }

    public final void setServerAddress(String srvAddr) {
        this.m_srvAddr = srvAddr;
    }

    public final void setShareName(String name) {
        this.m_shareName = name;
    }

    public final void setUserName(String user) {
        this.m_userName = user;
    }

    public final void setPassword(String password) {
        this.m_password = password;
    }

    public final void setProtocolType(int proto) {
        this.m_protocolType = proto;
    }

    public final void setProtocolPort(int port) {
        this.m_port = port;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[\\\\");
        str.append(this.getServerName());
        str.append("\\");
        str.append(this.getShareName());
        str.append(",");
        str.append(this.getUserName());
        str.append(",");
        str.append(this.getPassword());
        if (this.isProtocolType() != 0) {
            str.append(" (");
            if (this.isProtocolType() == 1) {
                str.append("NetBIOS");
            } else if (this.isProtocolType() == 2) {
                str.append("NativeSMB");
            } else if (this.isProtocolType() == 3) {
                str.append("Win32NetBIOS");
            }
            if (this.getProtocolPort() != 0) {
                str.append(",");
                str.append(this.getProtocolPort());
            }
            str.append(")");
        }
        str.append("]");
        return str.toString();
    }
}

