/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.item;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;

public class JCRPatternMatch
implements QNamePattern {
    private List<String> searches = new ArrayList<String>();
    private NamespacePrefixResolver resolver;

    public JCRPatternMatch(String pattern, NamespacePrefixResolver resolver) {
        String regexPattern = pattern.replaceAll("\\*", ".*");
        StringTokenizer tokenizer = new StringTokenizer(regexPattern, "|", false);
        while (tokenizer.hasMoreTokens()) {
            String disjunct = tokenizer.nextToken().trim();
            this.searches.add(disjunct);
        }
        this.resolver = resolver;
    }

    public boolean isMatch(QName qname) {
        String prefixedName = qname.toPrefixString(this.resolver);
        for (String search : this.searches) {
            if (!prefixedName.matches(search)) continue;
            return true;
        }
        return false;
    }
}

