/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.query;

import java.util.List;
import java.util.Map;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.alfresco.jcr.query.PropertyMapRowImpl;
import org.alfresco.jcr.session.SessionImpl;
import org.alfresco.jcr.util.AbstractRangeIterator;
import org.alfresco.jcr.util.JCRProxyFactory;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeRefRowIteratorImpl
extends AbstractRangeIterator
implements RowIterator {
    private SessionImpl session;
    private Map<QName, PropertyDefinition> columns;
    private List<NodeRef> nodeRefs;
    private RowIterator proxy = null;

    public NodeRefRowIteratorImpl(SessionImpl session, Map<QName, PropertyDefinition> columns, List<NodeRef> nodeRefs) {
        this.session = session;
        this.columns = columns;
        this.nodeRefs = nodeRefs;
    }

    public RowIterator getProxy() {
        if (this.proxy == null) {
            this.proxy = (RowIterator)JCRProxyFactory.create(this, RowIterator.class, this.session);
        }
        return this.proxy;
    }

    public Row nextRow() {
        long position = this.skip();
        NodeRef nodeRef = this.nodeRefs.get((int)position);
        NodeService nodeService = this.session.getRepositoryImpl().getServiceRegistry().getNodeService();
        Map properties = nodeService.getProperties(nodeRef);
        return new PropertyMapRowImpl(this.session, this.columns, nodeRef, properties);
    }

    public long getSize() {
        return this.nodeRefs.size();
    }

    public Object next() {
        return this.nextRow();
    }
}

