/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.repository;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.jcr.dictionary.NamespaceRegistryImpl;
import org.alfresco.jcr.session.SessionImpl;
import org.alfresco.repo.importer.ImporterComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.descriptor.DescriptorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryImpl
implements Repository {
    private static final char[] EMPTY_PASSWORD = "".toCharArray();
    private static final Map<String, String> descriptors = new HashMap<String, String>();
    private static ThreadLocal<SessionImpl> sessions = new ThreadLocal();
    private ServiceRegistry serviceRegistry;
    private ImporterComponent importerComponent;
    private String defaultWorkspace = null;
    private NamespaceRegistryImpl namespaceRegistry = null;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setImporterComponent(ImporterComponent importerComponent) {
        this.importerComponent = importerComponent;
    }

    public void setDefaultWorkspace(String defaultWorkspace) {
        this.defaultWorkspace = defaultWorkspace;
    }

    public void init() {
        if (this.serviceRegistry == null) {
            throw new IllegalStateException("Service Registry has not been specified.");
        }
        this.namespaceRegistry = new NamespaceRegistryImpl(false, this.serviceRegistry.getNamespaceService());
        DescriptorService descriptorService = this.serviceRegistry.getDescriptorService();
        Descriptor descriptor = descriptorService.getServerDescriptor();
        String repNameDesc = "Alfresco Content Repository";
        String edition = descriptor.getEdition();
        if (edition != null && edition.length() > 0) {
            repNameDesc = repNameDesc + " (" + edition + ")";
        }
        String repVersion = descriptor.getVersion();
        descriptors.put("jcr.repository.name", repNameDesc);
        descriptors.put("jcr.repository.vendor", "Alfresco");
        descriptors.put("jcr.repository.vendor.url", "http://www.alfresco.org");
        descriptors.put("jcr.repository.version", repVersion);
        descriptors.put("jcr.specification.name", "Content Repository API for Java(TM) Technology Specification");
        descriptors.put("jcr.specification.version", "1.0");
        descriptors.put("level.1.supported", "true");
        descriptors.put("level.2.supported", "true");
        descriptors.put("option.transactions.supported", "true");
        descriptors.put("query.xpath.doc.order", "true");
        descriptors.put("query.xpath.pos.index", "true");
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public ImporterComponent getImporterComponent() {
        return this.importerComponent;
    }

    public NamespaceRegistryImpl getNamespaceRegistry() {
        return this.namespaceRegistry;
    }

    public String[] getDescriptorKeys() {
        String[] keys = descriptors.keySet().toArray(new String[descriptors.keySet().size()]);
        return keys;
    }

    public String getDescriptor(String key) {
        return descriptors.get(key);
    }

    public Session login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        String username = null;
        char[] password = EMPTY_PASSWORD;
        if (credentials != null && credentials instanceof SimpleCredentials) {
            username = ((SimpleCredentials)credentials).getUserID();
            password = ((SimpleCredentials)credentials).getPassword();
        }
        try {
            SessionImpl sessionImpl = new SessionImpl(this);
            MutableAuthenticationService authenticationService = this.getServiceRegistry().getAuthenticationService();
            try {
                authenticationService.authenticate(username, password);
            }
            catch (AuthenticationException e) {
                throw new LoginException("Alfresco Repository failed to authenticate credentials", (Throwable)e);
            }
            String ticket = authenticationService.getCurrentTicket();
            String sessionWorkspace = workspaceName == null ? this.defaultWorkspace : workspaceName;
            sessionImpl.init(ticket, sessionWorkspace, this.getAttributes(credentials));
            Session session = sessionImpl.getProxy();
            this.registerSession(sessionImpl);
            return session;
        }
        catch (AlfrescoRuntimeException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public Session login(Credentials credentials) throws LoginException, RepositoryException {
        return this.login(credentials, null);
    }

    public Session login(String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.login(null, workspaceName);
    }

    public Session login() throws LoginException, RepositoryException {
        return this.login(null, null);
    }

    private Map<String, Object> getAttributes(Credentials credentials) {
        HashMap<String, Object> attributes = null;
        if (credentials != null && credentials instanceof SimpleCredentials) {
            SimpleCredentials simpleCredentials = (SimpleCredentials)credentials;
            String[] names = simpleCredentials.getAttributeNames();
            attributes = new HashMap<String, Object>(names.length);
            for (String name : names) {
                attributes.put(name, simpleCredentials.getAttribute(name));
            }
        }
        return attributes;
    }

    private void registerSession(SessionImpl session) throws RepositoryException {
        if (sessions.get() != null) {
            throw new RepositoryException("Only one active session is allowed per thread.");
        }
        sessions.set(session);
    }

    public void deregisterSession() {
        sessions.set(null);
    }
}

