/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.session;

import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.alfresco.jcr.test.BaseJCRTest;

public class SessionImplTest
extends BaseJCRTest {
    protected Session superuserSession;

    protected void setUp() throws Exception {
        super.setUp();
        SimpleCredentials superuser = new SimpleCredentials("superuser", "".toCharArray());
        superuser.setAttribute("attr1", (Object)"superuserValue");
        superuser.setAttribute("attr2", (Object)new Integer(1));
        this.superuserSession = this.repository.login((Credentials)superuser, this.getWorkspace());
    }

    protected void tearDown() throws Exception {
        this.superuserSession.logout();
        super.tearDown();
    }

    public void testRepository() throws RepositoryException {
        Repository sessionRepository = this.superuserSession.getRepository();
        SessionImplTest.assertNotNull((Object)sessionRepository);
        SessionImplTest.assertEquals((Object)this.repository, (Object)sessionRepository);
    }

    public void testUserId() {
        String userId = this.superuserSession.getUserID();
        SessionImplTest.assertNotNull((Object)userId);
        SessionImplTest.assertEquals((String)"superuser", (String)userId);
    }

    public void testAttributes() {
        String[] names = this.superuserSession.getAttributeNames();
        SessionImplTest.assertNotNull((Object)names);
        SessionImplTest.assertEquals((int)2, (int)names.length);
        String value1 = (String)this.superuserSession.getAttribute("attr1");
        SessionImplTest.assertNotNull((Object)value1);
        SessionImplTest.assertEquals((String)"superuserValue", (String)value1);
        Integer value2 = (Integer)this.superuserSession.getAttribute("attr2");
        SessionImplTest.assertNotNull((Object)value2);
        SessionImplTest.assertEquals((Object)new Integer(1), (Object)value2);
        String value3 = (String)this.superuserSession.getAttribute("unknown");
        SessionImplTest.assertNull((Object)value3);
    }

    public void testLogout() {
        boolean isLive = this.superuserSession.isLive();
        SessionImplTest.assertTrue((boolean)isLive);
        this.superuserSession.logout();
        isLive = this.superuserSession.isLive();
        SessionImplTest.assertFalse((boolean)isLive);
    }

    public void testSessionThread() {
        Session anotherSession;
        SimpleCredentials superuser = new SimpleCredentials("superuser", "".toCharArray());
        try {
            anotherSession = this.repository.login((Credentials)superuser, this.getWorkspace());
            SessionImplTest.fail((String)"Exception not thrown when establishing two sessions on same thread");
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        this.superuserSession.logout();
        try {
            anotherSession = this.repository.login((Credentials)superuser, this.getWorkspace());
            anotherSession.logout();
        }
        catch (RepositoryException e) {
            SessionImplTest.fail((String)"Exception thrown when it shouldn't of been.");
        }
    }
}

