/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.version.VersionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateVersionActionExecuter
extends ActionExecuterAbstractBase {
    public static final String NAME = "create-version";
    public static final String PARAM_DESCRIPTION = "description";
    public static final String PARAM_MINOR_CHANGE = "minor-change";
    public NodeService nodeService;
    public VersionService versionService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    @Override
    public void executeImpl(Action ruleAction, NodeRef actionedUponNodeRef) {
        if (this.nodeService.exists(actionedUponNodeRef) && this.nodeService.hasAspect(actionedUponNodeRef, ContentModel.ASPECT_VERSIONABLE)) {
            Boolean minorChange;
            HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>(2);
            String description = (String)((Object)ruleAction.getParameterValue(PARAM_DESCRIPTION));
            if (description != null && description.length() != 0) {
                versionProperties.put(PARAM_DESCRIPTION, (Serializable)((Object)description));
            }
            if ((minorChange = (Boolean)ruleAction.getParameterValue(PARAM_MINOR_CHANGE)) != null && !minorChange.booleanValue()) {
                versionProperties.put("versionType", (Serializable)((Object)VersionType.MAJOR));
            } else {
                versionProperties.put("versionType", (Serializable)((Object)VersionType.MINOR));
            }
            this.versionService.createVersion(actionedUponNodeRef, versionProperties);
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_MINOR_CHANGE, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_MINOR_CHANGE)));
        paramList.add(new ParameterDefinitionImpl(PARAM_DESCRIPTION, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_DESCRIPTION)));
    }
}

