/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.node.index.FullIndexRecoveryComponent;
import org.alfresco.repo.search.AVMSnapShotTriggeredIndexingMethodInterceptor;
import org.alfresco.repo.search.IndexMode;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.InvalidStoreRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;
import org.springframework.extensions.surf.util.I18NUtil;

public class ConfigurationChecker
extends AbstractLifecycleBean {
    private static Log logger = LogFactory.getLog(ConfigurationChecker.class);
    private static final String WARN_RELATIVE_DIR_ROOT = "system.config_check.warn.dir_root";
    private static final String MSG_DIR_ROOT = "system.config_check.msg.dir_root";
    private static final String ERR_DUPLICATE_ROOT_NODE = "system.config_check.err.indexes.duplicate_root_node";
    private static final String ERR_MISSING_INDEXES = "system.config_check.err.missing_index";
    private static final String ERR_MISSING_CONTENT = "system.config_check.err.missing_content";
    private static final String ERR_FIX_DIR_ROOT = "system.config_check.err.fix_dir_root";
    private static final String MSG_HOWTO_INDEX_RECOVER = "system.config_check.msg.howto_index_recover";
    private static final String WARN_STARTING_WITH_ERRORS = "system.config_check.warn.starting_with_errors";
    private boolean strict;
    private FullIndexRecoveryComponent.RecoveryMode indexRecoveryMode;
    private String dirRoot;
    private ImporterBootstrap systemBootstrap;
    private TransactionService transactionService;
    private NamespaceService namespaceService;
    private NodeService nodeService;
    private SearchService searchService;
    private ContentService contentService;
    private AVMSnapShotTriggeredIndexingMethodInterceptor avmSnapShotTriggeredIndexingMethodInterceptor;

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append("ConfigurationChecker").append("[indexRecoveryMode=").append((Object)this.indexRecoveryMode).append("]");
        return sb.toString();
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setIndexRecoveryMode(String indexRecoveryMode) {
        this.indexRecoveryMode = FullIndexRecoveryComponent.RecoveryMode.valueOf(indexRecoveryMode);
    }

    public void setDirRoot(String dirRoot) {
        this.dirRoot = dirRoot;
    }

    public void setSystemBootstrap(ImporterBootstrap systemBootstrap) {
        this.systemBootstrap = systemBootstrap;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setAvmSnapShotTriggeredIndexingMethodInterceptor(AVMSnapShotTriggeredIndexingMethodInterceptor avmSnapShotTriggeredIndexingMethodInterceptor) {
        this.avmSnapShotTriggeredIndexingMethodInterceptor = avmSnapShotTriggeredIndexingMethodInterceptor;
    }

    protected void onBootstrap(ApplicationEvent event) {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> checkWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                ConfigurationChecker.this.check();
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(checkWork, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check() {
        String msg;
        int missingStoreIndexes;
        ContentReader reader;
        boolean isRelativeRoot;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting bootstrap configuration check: " + (Object)((Object)this)));
        }
        if (isRelativeRoot = this.dirRoot.startsWith(".")) {
            String msg2 = I18NUtil.getMessage((String)WARN_RELATIVE_DIR_ROOT, (Object[])new Object[]{this.dirRoot});
            logger.warn((Object)msg2);
        }
        File dirRootFile = new File(this.dirRoot);
        String msgDirRoot = I18NUtil.getMessage((String)MSG_DIR_ROOT, (Object[])new Object[]{dirRootFile});
        logger.info((Object)msgDirRoot);
        List storeRefs = this.nodeService.getStores();
        ArrayList<StoreRef> missingIndexStoreRefs = new ArrayList<StoreRef>(0);
        for (StoreRef storeRef : storeRefs) {
            NodeRef rootNodeRef = null;
            try {
                rootNodeRef = this.nodeService.getRootNode(storeRef);
            }
            catch (InvalidStoreRefException e) {
                continue;
            }
            if (this.indexRecoveryMode == FullIndexRecoveryComponent.RecoveryMode.FULL) continue;
            if (storeRef.getProtocol().equals("avm")) {
                if (this.avmSnapShotTriggeredIndexingMethodInterceptor.isIndexingEnabled()) {
                    IndexMode storeIndexMode = this.avmSnapShotTriggeredIndexingMethodInterceptor.getIndexMode(storeRef.getIdentifier());
                    if (storeIndexMode.equals((Object)IndexMode.UNINDEXED)) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Skipping index check for store: " + storeRef + " (unindexed AVM store)"));
                        continue;
                    }
                } else {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Skipping index check for store: " + storeRef + " (AVM indexing is disabled)"));
                    continue;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Checking index for store: " + storeRef));
            }
            SearchParameters sp = new SearchParameters();
            sp.addStore(storeRef);
            sp.setLanguage("lucene");
            sp.setQuery("ISROOT:T");
            ResultSet results = null;
            int size = 0;
            try {
                results = this.searchService.query(sp);
                size = results.length();
            }
            finally {
                try {
                    results.close();
                }
                catch (Throwable e) {}
            }
            if (size == 0) {
                missingIndexStoreRefs.add(storeRef);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Index missing for store: \n   store: " + storeRef));
                continue;
            }
            if (size <= 1) continue;
            String msg3 = I18NUtil.getMessage((String)ERR_DUPLICATE_ROOT_NODE, (Object[])new Object[]{storeRef});
            throw new AlfrescoRuntimeException(msg3);
        }
        boolean versionPropertiesContentAvailable = true;
        NodeRef descriptorNodeRef = this.getSystemDescriptor();
        if (descriptorNodeRef != null && (reader = this.contentService.getReader(descriptorNodeRef, ContentModel.PROP_SYS_VERSION_PROPERTIES)) != null && !reader.exists()) {
            versionPropertiesContentAvailable = false;
        }
        if ((missingStoreIndexes = missingIndexStoreRefs.size()) > 0) {
            msg = I18NUtil.getMessage((String)ERR_MISSING_INDEXES, (Object[])new Object[]{missingStoreIndexes});
            logger.error((Object)msg);
            String msgRecover = I18NUtil.getMessage((String)MSG_HOWTO_INDEX_RECOVER);
            logger.info((Object)msgRecover);
        }
        if (!versionPropertiesContentAvailable) {
            msg = I18NUtil.getMessage((String)ERR_MISSING_CONTENT);
            logger.error((Object)msg);
        }
        if (missingStoreIndexes > 0 || !versionPropertiesContentAvailable) {
            msg = I18NUtil.getMessage((String)ERR_FIX_DIR_ROOT, (Object[])new Object[]{dirRootFile});
            logger.error((Object)msg);
            if (this.strict) {
                throw new AlfrescoRuntimeException(msg);
            }
            String warn = I18NUtil.getMessage((String)WARN_STARTING_WITH_ERRORS);
            logger.warn((Object)warn);
        }
    }

    public NodeRef getSystemDescriptor() {
        StoreRef systemStoreRef = this.systemBootstrap.getStoreRef();
        List nodeRefs = null;
        if (this.nodeService.exists(systemStoreRef)) {
            Properties systemProperties = this.systemBootstrap.getConfiguration();
            String path = systemProperties.getProperty("system.descriptor.current.childname");
            String searchPath = "/" + path;
            NodeRef rootNodeRef = this.nodeService.getRootNode(systemStoreRef);
            nodeRefs = this.searchService.selectNodes(rootNodeRef, searchPath, null, (NamespacePrefixResolver)this.namespaceService, false);
            if (nodeRefs.size() > 0) {
                NodeRef descriptorNodeRef = (NodeRef)nodeRefs.get(0);
                return descriptorNodeRef;
            }
        }
        return null;
    }

    protected void onShutdown(ApplicationEvent event) {
    }
}

