/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.domain.mimetype.MimetypeDAO;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.repo.search.Indexer;
import org.alfresco.repo.search.IndexerAndSearcher;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.util.Pair;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericMimetypeRenamePatch
extends AbstractPatch {
    private static final String MSG_START = "patch.genericMimetypeUpdate.start";
    private static final String MSG_UPDATED = "patch.genericMimetypeUpdate.updated";
    private static final String MSG_INDEXED = "patch.genericMimetypeUpdate.indexed";
    private static final String MSG_DONE = "patch.genericMimetypeUpdate.done";
    private static final String MSG_DONE_REINDEX = "patch.genericMimetypeUpdate.doneReindex";
    private IndexerAndSearcher indexerAndSearcher;
    private MimetypeDAO mimetypeDAO;
    private PatchDAO patchDAO;
    private Map<String, String> mimetypeMappings;
    private boolean reindex;

    public void setIndexerAndSearcher(IndexerAndSearcher indexerAndSearcher) {
        this.indexerAndSearcher = indexerAndSearcher;
    }

    public void setMimetypeDAO(MimetypeDAO mimetypeDAO) {
        this.mimetypeDAO = mimetypeDAO;
    }

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    public void setMimetypeMappings(Map<String, String> mimetypeMappings) {
        this.mimetypeMappings = mimetypeMappings;
    }

    public void setReindex(boolean reindex) {
        this.reindex = reindex;
    }

    @Override
    protected void checkProperties() {
        super.checkProperties();
        this.checkPropertyNotNull(this.indexerAndSearcher, "indexerAndSearcher");
        this.checkPropertyNotNull(this.mimetypeDAO, "mimetypeDAO");
        this.checkPropertyNotNull(this.patchDAO, "patchDAO");
        this.checkPropertyNotNull(this.mimetypeMappings, "mimetypeMappings");
    }

    @Override
    protected String applyInternal() throws Exception {
        List storeRefsList = this.nodeService.getStores();
        HashSet<StoreRef> storeRefs = new HashSet<StoreRef>();
        for (StoreRef storeRef : storeRefsList) {
            if (!storeRef.getIdentifier().endsWith("SpacesStore")) continue;
            storeRefs.add(storeRef);
        }
        StringBuilder result = new StringBuilder(I18NUtil.getMessage((String)MSG_START));
        for (Map.Entry<String, String> element : this.mimetypeMappings.entrySet()) {
            String oldMimetype = element.getKey();
            String newMimetype = element.getValue();
            Pair<Long, String> oldMimetypePair = this.mimetypeDAO.getMimetype(oldMimetype);
            if (oldMimetypePair == null) continue;
            Pair<Long, String> newMimetypePair = this.mimetypeDAO.getMimetype(newMimetype);
            int updateCount = 0;
            if (newMimetypePair == null) {
                updateCount = this.mimetypeDAO.updateMimetype(oldMimetype, newMimetype);
            } else {
                Long oldMimetypeId = (Long)oldMimetypePair.getFirst();
                Long newMimetypeId = (Long)this.mimetypeDAO.getOrCreateMimetype(newMimetype).getFirst();
                updateCount = this.patchDAO.updateContentMimetypeIds(oldMimetypeId, newMimetypeId);
            }
            result.append(I18NUtil.getMessage((String)MSG_UPDATED, (Object[])new Object[]{updateCount, oldMimetype, newMimetype}));
            if (!this.reindex) continue;
            int reindexCount = 0;
            for (StoreRef storeRef : storeRefs) {
                result.append(I18NUtil.getMessage((String)MSG_INDEXED, (Object[])new Object[]{reindexCount += this.reindex(oldMimetype, storeRef), storeRef}));
            }
        }
        if (this.reindex) {
            result.append(I18NUtil.getMessage((String)MSG_DONE));
        } else {
            result.append(I18NUtil.getMessage((String)MSG_DONE_REINDEX));
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int reindex(String oldMimetype, StoreRef store) {
        SearchParameters sp = new SearchParameters();
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toString()) + ".mimetype:\"" + oldMimetype + "\"");
        sp.addStore(store);
        Indexer indexer = this.indexerAndSearcher.getIndexer(store);
        ResultSet rs = null;
        int count = 0;
        try {
            rs = this.searchService.query(sp);
            count = rs.length();
            for (ResultSetRow row : rs) {
                indexer.updateNode(row.getNodeRef());
            }
            Object var10_9 = null;
            if (rs == null) return count;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (rs == null) throw throwable;
            rs.close();
            throw throwable;
        }
        rs.close();
        return count;
    }
}

