/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.sql.Savepoint;
import java.util.Date;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.domain.control.ControlDAO;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.util.Pair;
import org.alfresco.util.TempFileProvider;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class LinkNodeFileExtensionPatch
extends AbstractPatch {
    private static final String MSG_SUCCESS = "patch.linkNodeExtension.result";
    private static final String MSG_REWRITTEN = "patch.linkNodeExtension.rewritten";
    private static final String ERR_UNABLE_TO_FIX = "patch.linkNodeExtension.err.unable_to_fix";
    private PatchDAO patchDAO;
    private ControlDAO controlDAO;
    private NodeService nodeService;

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    public void setControlDAO(ControlDAO controlDAO) {
        this.controlDAO = controlDAO;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    protected void checkProperties() {
        super.checkProperties();
        this.checkPropertyNotNull(this.patchDAO, "patchDAO");
        this.checkPropertyNotNull(this.nodeService, "nodeService");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String applyInternal() throws Exception {
        String string;
        LinkNodeFileExtensionHelper helper = new LinkNodeFileExtensionHelper();
        try {
            string = helper.fixNames();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            helper.closeWriter();
            throw throwable;
        }
        helper.closeWriter();
        return string;
    }

    private class LinkNodeFileExtensionHelper
    extends HibernateDaoSupport {
        private File logFile;
        private FileChannel channel;

        private LinkNodeFileExtensionHelper() throws IOException {
            File tempDir = TempFileProvider.getLongLifeTempDir((String)"patches");
            this.logFile = new File(tempDir, "LinkNodeExtensionPatch.log");
            RandomAccessFile outputFile = new RandomAccessFile(this.logFile, "rw");
            this.channel = outputFile.getChannel();
            this.channel.position(this.channel.size());
            this.writeLine("").writeLine("");
            this.writeLine("LinkNodeExtensionPatch executing on " + new Date());
        }

        private LinkNodeFileExtensionHelper write(Object obj) throws IOException {
            this.channel.write(ByteBuffer.wrap(obj.toString().getBytes()));
            return this;
        }

        private LinkNodeFileExtensionHelper writeLine(Object obj) throws IOException {
            this.write(obj);
            this.write("\n");
            return this;
        }

        private void closeWriter() {
            try {
                this.channel.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public String fixNames() throws Exception {
            List<Pair<NodeRef, String>> names = LinkNodeFileExtensionPatch.this.patchDAO.getNodesOfTypeWithNamePattern(ContentModel.TYPE_LINK, "%.lnk");
            int updated = 0;
            for (Pair<NodeRef, String> pair : names) {
                NodeRef nodeRef = (NodeRef)pair.getFirst();
                String name = (String)pair.getSecond();
                String updatedName = name.substring(0, name.length() - 4) + ".url";
                int idx = 0;
                boolean applied = false;
                while (!applied && idx < 10) {
                    Savepoint savepoint = LinkNodeFileExtensionPatch.this.controlDAO.createSavepoint("LinkNodeFileExtensionsFix");
                    try {
                        LinkNodeFileExtensionPatch.this.nodeService.setProperty(nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)updatedName));
                        LinkNodeFileExtensionPatch.this.controlDAO.releaseSavepoint(savepoint);
                        applied = true;
                    }
                    catch (DuplicateChildNodeNameException e) {
                        LinkNodeFileExtensionPatch.this.controlDAO.rollbackToSavepoint(savepoint);
                        updatedName = updatedName + "_" + ++idx;
                    }
                }
                if (applied) {
                    this.writeLine(I18NUtil.getMessage((String)LinkNodeFileExtensionPatch.MSG_REWRITTEN, (Object[])new Object[]{name, updatedName}));
                } else {
                    this.writeLine(I18NUtil.getMessage((String)LinkNodeFileExtensionPatch.ERR_UNABLE_TO_FIX, (Object[])new Object[]{name, updatedName}));
                }
                ++updated;
            }
            String msg = I18NUtil.getMessage((String)LinkNodeFileExtensionPatch.MSG_SUCCESS, (Object[])new Object[]{updated, this.logFile});
            return msg;
        }
    }
}

