/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionModel;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.util.GUID;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class ImportFileUpdater {
    private static int INDENT_SIZE = 2;
    private static String EXPORT_VERSION = "1.4.0";
    private static String DEFAULT_ENCODING = "UTF-8";
    private String fileEncoding = DEFAULT_ENCODING;
    private static String NAME_EXPORTER_VERSION = "exporterVersion";
    private static String NAME_RULE = "rule";
    private String version;
    private boolean shownWarning = false;

    public void setFileEncoding(String fileEncoding) {
        this.fileEncoding = fileEncoding;
    }

    public void updateImportFile(String source, String destination) {
        XmlPullParser reader = this.getReader(source);
        XMLWriter writer = this.getWriter(destination);
        this.shownWarning = false;
        try {
            writer.startDocument();
            int eventType = reader.getEventType();
            while (eventType != 1) {
                if (eventType == 2) {
                    this.outputCurrentElement(reader, writer, new OutputChildren());
                }
                eventType = reader.next();
            }
            writer.endDocument();
            writer.close();
        }
        catch (Exception exception) {
            throw new AlfrescoRuntimeException("Unable to update import file.", (Throwable)exception);
        }
    }

    private XmlPullParser getReader(String source) {
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
            factory.setNamespaceAware(true);
            FileInputStream inputStream = new FileInputStream(source);
            InputStreamReader inputReader = new InputStreamReader((InputStream)inputStream, this.fileEncoding);
            XmlPullParser xpp = factory.newPullParser();
            xpp.setInput((Reader)new BufferedReader(inputReader));
            return xpp;
        }
        catch (XmlPullParserException exception) {
            throw new AlfrescoRuntimeException("Unable to update import file.", (Throwable)exception);
        }
        catch (FileNotFoundException fileNotFound) {
            throw new AlfrescoRuntimeException("The source file could not be loaded.", (Throwable)fileNotFound);
        }
        catch (UnsupportedEncodingException exception) {
            throw new AlfrescoRuntimeException("Unsupported encoding", (Throwable)exception);
        }
    }

    private XMLWriter getWriter(String destination) {
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setNewLineAfterDeclaration(false);
            format.setIndentSize(INDENT_SIZE);
            format.setEncoding(this.fileEncoding);
            return new XMLWriter((OutputStream)new FileOutputStream(destination), format);
        }
        catch (Exception exception) {
            throw new AlfrescoRuntimeException("Unable to create XML writer.", (Throwable)exception);
        }
    }

    private void outputCurrentElement(XmlPullParser reader, XMLWriter writer, Work work) throws Exception {
        this.outputCurrentElement(reader, writer, work, true);
    }

    private void outputCurrentElement(XmlPullParser reader, XMLWriter writer, Work work, boolean checkForCallbacks) throws Exception {
        if (!checkForCallbacks || !this.checkForCallbacks(reader, writer)) {
            String name = reader.getName();
            String namespace = reader.getNamespace();
            String prefix = reader.getPrefix();
            HashMap<String, String> nss = new HashMap<String, String>();
            int nsStart = reader.getNamespaceCount(reader.getDepth() - 1);
            int nsEnd = reader.getNamespaceCount(reader.getDepth());
            for (int i = nsStart; i < nsEnd; ++i) {
                String nsPrefix = reader.getNamespacePrefix(i);
                String ns = reader.getNamespaceUri(i);
                nss.put(nsPrefix, ns);
            }
            AttributesImpl attributes = new AttributesImpl();
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attributeName = reader.getAttributeName(i);
                String attributeNamespace = reader.getAttributeNamespace(i);
                String attributePrefix = reader.getAttributePrefix(i);
                String attributeType = reader.getAttributeType(i);
                String attributeValue = reader.getAttributeValue(i);
                attributes.addAttribute(attributeNamespace, attributeName, attributePrefix + ":" + attributeName, attributeType, attributeValue);
            }
            for (Map.Entry entry : nss.entrySet()) {
                writer.startPrefixMapping((String)entry.getKey(), (String)entry.getValue());
            }
            writer.startElement(namespace, name, prefix + ":" + name, (Attributes)attributes);
            work.doWork(reader, writer);
            writer.endElement(namespace, name, prefix + ":" + name);
            for (String nsPrefix : nss.keySet()) {
                writer.endPrefixMapping(nsPrefix);
            }
        }
    }

    private boolean checkForCallbacks(XmlPullParser reader, XMLWriter writer) throws Exception {
        boolean result = false;
        if (reader.getName().equals(NAME_EXPORTER_VERSION)) {
            new ImportVersionLabelCallback().doCallback(reader, writer);
            result = true;
        } else if (reader.getName().equals(NAME_RULE)) {
            if (!this.shownWarning && this.version == null) {
                System.out.println("WARNING:  No version information has been found in this import file.  It will be presumed it has been exported from 1.3");
                this.shownWarning = true;
            }
            if (this.version == null || this.version.startsWith("1.3") || this.version.startsWith("1.2")) {
                new RuleCallback().doCallback(reader, writer);
                result = true;
            } else {
                throw new RuntimeException("Import files of version " + this.version + " are not supported by this tool.");
            }
        }
        return result;
    }

    public static void main(String[] args) {
        if (args.length == 2) {
            ImportFileUpdater util = new ImportFileUpdater();
            util.updateImportFile(args[0], args[1]);
        } else if (args.length == 3) {
            ImportFileUpdater util = new ImportFileUpdater();
            util.setFileEncoding(args[2]);
            util.updateImportFile(args[0], args[1]);
        } else {
            System.out.println(" ImportFileUpdater <source> <destination>");
            System.out.println("    source - 1.3 import file name to be updated");
            System.out.println("    destination - name of the generated 1.4 import file");
            System.out.println("    file encoding (optional) - the file encoding, default is UTF-8");
        }
    }

    private class RuleCallback
    implements ImportUpdaterCallback {
        private RuleCallback() {
        }

        public void doCallback(XmlPullParser reader, XMLWriter writer) throws Exception {
            String name = reader.getName();
            String namespace = reader.getNamespace();
            String prefix = reader.getPrefix();
            AttributesImpl attributes = new AttributesImpl();
            String attributeName = reader.getAttributeName(0);
            String attributeNamespace = reader.getAttributeNamespace(0);
            String attributePrefix = reader.getAttributePrefix(0);
            String attributeType = reader.getAttributeType(0);
            String attributeValue = reader.getAttributeValue(0) + GUID.generate();
            attributes.addAttribute(attributeNamespace, attributeName, attributePrefix + ":" + attributeName, attributeType, attributeValue);
            writer.startElement(namespace, name, prefix + ":" + name, (Attributes)attributes);
            int eventType = reader.getEventType();
            while (eventType != 3) {
                eventType = reader.next();
                if (eventType != 2) continue;
                String childName = reader.getName();
                if (childName.equals("aspects")) {
                    ImportFileUpdater.this.outputCurrentElement(reader, writer, new Work(){

                        public void doWork(XmlPullParser reader, XMLWriter writer) throws Exception {
                            writer.startElement(ContentModel.ASPECT_TITLED.getNamespaceURI(), ContentModel.ASPECT_TITLED.getLocalName(), "cm:" + ContentModel.ASPECT_TITLED.getLocalName(), (Attributes)new AttributesImpl());
                            writer.endElement(ContentModel.ASPECT_TITLED.getNamespaceURI(), ContentModel.ASPECT_TITLED.getLocalName(), "cm:" + ContentModel.ASPECT_TITLED.getLocalName());
                            int eventType = reader.getEventType();
                            while (eventType != 3) {
                                eventType = reader.next();
                                if (eventType != 2) continue;
                                ImportFileUpdater.this.outputCurrentElement(reader, writer, new OutputChildren());
                            }
                        }
                    }, false);
                    continue;
                }
                if (childName.equals("properties")) {
                    ImportFileUpdater.this.outputCurrentElement(reader, writer, new Work(){

                        public void doWork(XmlPullParser reader, XMLWriter writer) throws Exception {
                            int eventType = reader.getEventType();
                            while (eventType != 3) {
                                eventType = reader.next();
                                if (eventType != 2) continue;
                                String propName = reader.getName();
                                if (propName.equals("actionDescription")) {
                                    writer.startElement(ContentModel.PROP_DESCRIPTION.getNamespaceURI(), ContentModel.PROP_DESCRIPTION.getLocalName(), "cm:" + ContentModel.PROP_DESCRIPTION.getLocalName(), (Attributes)new AttributesImpl());
                                    new OutputChildren().doWork(reader, writer);
                                    writer.endElement(ContentModel.PROP_DESCRIPTION.getNamespaceURI(), ContentModel.PROP_DESCRIPTION.getLocalName(), "cm:" + ContentModel.PROP_DESCRIPTION.getLocalName());
                                    eventType = reader.next();
                                    continue;
                                }
                                if (propName.equals("actionTitle")) {
                                    writer.startElement(ContentModel.PROP_TITLE.getNamespaceURI(), ContentModel.PROP_TITLE.getLocalName(), "cm:" + ContentModel.PROP_TITLE.getLocalName(), (Attributes)new AttributesImpl());
                                    new OutputChildren().doWork(reader, writer);
                                    writer.endElement(ContentModel.PROP_TITLE.getNamespaceURI(), ContentModel.PROP_TITLE.getLocalName(), "cm:" + ContentModel.PROP_TITLE.getLocalName());
                                    eventType = reader.next();
                                    continue;
                                }
                                if (propName.equals("executeAsynchronously")) {
                                    writer.startElement(RuleModel.PROP_EXECUTE_ASYNC.getNamespaceURI(), RuleModel.PROP_EXECUTE_ASYNC.getLocalName(), "rule:" + RuleModel.PROP_EXECUTE_ASYNC.getLocalName(), (Attributes)new AttributesImpl());
                                    new OutputChildren().doWork(reader, writer);
                                    writer.endElement(RuleModel.PROP_EXECUTE_ASYNC.getNamespaceURI(), RuleModel.PROP_EXECUTE_ASYNC.getLocalName(), "rule:" + RuleModel.PROP_EXECUTE_ASYNC.getLocalName());
                                    eventType = reader.next();
                                    continue;
                                }
                                if (propName.equals("ruleType")) {
                                    ImportFileUpdater.this.outputCurrentElement(reader, writer, new Work(){

                                        public void doWork(XmlPullParser reader, XMLWriter writer) throws Exception {
                                            writer.startElement("http://www.alfresco.org/view/repository/1.0", "values", "view:values", (Attributes)new AttributesImpl());
                                            writer.startElement("http://www.alfresco.org/view/repository/1.0", "value", "view:value", (Attributes)new AttributesImpl());
                                            new OutputChildren().doWork(reader, writer);
                                            writer.endElement("view", "value", "view:value");
                                            writer.endElement("view", "values", "view:values");
                                        }
                                    }, false);
                                    continue;
                                }
                                if (propName.equals("definitionName")) {
                                    while (eventType != 3) {
                                        eventType = reader.next();
                                    }
                                    eventType = reader.next();
                                    continue;
                                }
                                ImportFileUpdater.this.outputCurrentElement(reader, writer, new OutputChildren());
                            }
                            writer.startElement(RuleModel.PROP_DISABLED.getNamespaceURI(), RuleModel.PROP_DISABLED.getLocalName(), "rule:" + RuleModel.PROP_DISABLED.getLocalName(), (Attributes)new AttributesImpl());
                            writer.write("false");
                            writer.endElement(RuleModel.PROP_DISABLED.getNamespaceURI(), RuleModel.PROP_DISABLED.getLocalName(), "rule:" + RuleModel.PROP_DISABLED.getLocalName());
                        }
                    }, false);
                    continue;
                }
                if (childName.equals("associations")) {
                    ImportFileUpdater.this.outputCurrentElement(reader, writer, new Work(){

                        public void doWork(XmlPullParser reader, XMLWriter writer) throws Exception {
                            writer.startElement(RuleModel.ASSOC_ACTION.getNamespaceURI(), RuleModel.ASSOC_ACTION.getLocalName(), "rule:" + RuleModel.ASSOC_ACTION.getLocalName(), (Attributes)new AttributesImpl());
                            AttributesImpl attributes = new AttributesImpl();
                            attributes.addAttribute("http://www.alfresco.org/view/repository/1.0", "childName", "view:childName", null, "rule:action");
                            writer.startElement(ActionModel.TYPE_COMPOSITE_ACTION.getNamespaceURI(), ActionModel.TYPE_COMPOSITE_ACTION.getLocalName(), "act:" + ActionModel.TYPE_COMPOSITE_ACTION.getLocalName(), (Attributes)attributes);
                            writer.startElement("http://www.alfresco.org/view/repository/1.0", "properties", "view:properties", (Attributes)new AttributesImpl());
                            writer.startElement(ActionModel.PROP_DEFINITION_NAME.getNamespaceURI(), ActionModel.PROP_DEFINITION_NAME.getLocalName(), "act:" + ActionModel.PROP_DEFINITION_NAME.getLocalName(), (Attributes)new AttributesImpl());
                            writer.write("composite-action");
                            writer.endElement(ActionModel.PROP_DEFINITION_NAME.getNamespaceURI(), ActionModel.PROP_DEFINITION_NAME.getLocalName(), "act:" + ActionModel.PROP_DEFINITION_NAME.getLocalName());
                            writer.endElement("http://www.alfresco.org/view/repository/1.0", "properties", "view:properties");
                            writer.startElement("http://www.alfresco.org/view/repository/1.0", "associations", "view:associations", (Attributes)new AttributesImpl());
                            new OutputChildren().doWork(reader, writer);
                            writer.endElement("http://www.alfresco.org/view/repository/1.0", "associations", "view:associations");
                            writer.endElement(ActionModel.TYPE_COMPOSITE_ACTION.getNamespaceURI(), ActionModel.TYPE_COMPOSITE_ACTION.getLocalName(), "act:" + ActionModel.TYPE_COMPOSITE_ACTION.getLocalName());
                            writer.endElement(RuleModel.ASSOC_ACTION.getNamespaceURI(), RuleModel.ASSOC_ACTION.getLocalName(), "rule:" + RuleModel.ASSOC_ACTION.getLocalName());
                        }
                    }, false);
                    continue;
                }
                ImportFileUpdater.this.outputCurrentElement(reader, writer, new OutputChildren());
            }
            writer.endElement(namespace, name, prefix + ":" + name);
        }
    }

    private class ImportVersionLabelCallback
    implements ImportUpdaterCallback {
        private ImportVersionLabelCallback() {
        }

        public void doCallback(XmlPullParser reader, XMLWriter writer) throws Exception {
            ImportFileUpdater.this.outputCurrentElement(reader, writer, new Work(){

                public void doWork(XmlPullParser reader, XMLWriter writer) throws Exception {
                    reader.next();
                    ImportFileUpdater.this.version = reader.getText();
                    writer.write(EXPORT_VERSION);
                    reader.next();
                }
            }, false);
        }
    }

    private static interface ImportUpdaterCallback {
        public void doCallback(XmlPullParser var1, XMLWriter var2) throws Exception;
    }

    private class IgnoreChildren
    implements Work {
        private IgnoreChildren() {
        }

        public void doWork(XmlPullParser reader, XMLWriter writer) throws Exception {
            int eventType = reader.getEventType();
            while (eventType != 3) {
                eventType = reader.next();
                if (eventType != 2) continue;
                this.doWork(reader, writer);
            }
        }
    }

    private class OutputChildren
    implements Work {
        private OutputChildren() {
        }

        public void doWork(XmlPullParser reader, XMLWriter writer) throws Exception {
            int eventType = reader.getEventType();
            while (eventType != 3) {
                eventType = reader.next();
                if (eventType == 2) {
                    ImportFileUpdater.this.outputCurrentElement(reader, writer, new OutputChildren());
                    continue;
                }
                if (eventType != 4) continue;
                writer.write(reader.getText());
            }
        }
    }

    private static interface Work {
        public void doWork(XmlPullParser var1, XMLWriter var2) throws Exception;
    }
}

