/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.error.StackTraceUtil;
import org.alfresco.repo.audit.AuditComponent;
import org.alfresco.repo.audit.PublicServiceIdentifier;
import org.alfresco.repo.audit.model.AuditApplication;
import org.alfresco.repo.domain.schema.SchemaBootstrap;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.Auditable;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.alfresco.service.transaction.TransactionService;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditMethodInterceptor
implements MethodInterceptor {
    public static final String AUDIT_PATH_API_ROOT = "/alfresco-api";
    public static final String AUDIT_PATH_API_PRE = "/alfresco-api/pre";
    public static final String AUDIT_PATH_API_POST = "/alfresco-api/post";
    public static final String AUDIT_SNIPPET_ARGS = "/args";
    public static final String AUDIT_SNIPPET_RESULT = "/result";
    public static final String AUDIT_SNIPPET_ERROR = "/error";
    public static final String AUDIT_SNIPPET_NO_ERROR = "/no-error";
    private static final Log logger = LogFactory.getLog(AuditMethodInterceptor.class);
    private PublicServiceIdentifier publicServiceIdentifier;
    private AuditComponent auditComponent;
    private TransactionService transactionService;
    private final ThreadLocal<Boolean> inAudit = new ThreadLocal();

    public void setUseNewConfig(boolean useNewConfig) {
        logger.warn((Object)"Property 'useNewConfig' is no longer used.");
    }

    public void setPublicServiceIdentifier(PublicServiceIdentifier serviceIdentifier) {
        this.publicServiceIdentifier = serviceIdentifier;
    }

    public void setAuditComponent(AuditComponent auditComponent) {
        this.auditComponent = auditComponent;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        if (!this.auditComponent.areAuditValuesRequired()) {
            return mi.proceed();
        }
        return this.proceed(mi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object proceed(MethodInvocation mi) throws Throwable {
        String serviceName;
        Map<String, Serializable> namedArguments;
        Auditable auditableDef;
        Boolean wasInAudit;
        block7: {
            block6: {
                block5: {
                    wasInAudit = this.inAudit.get();
                    try {
                        if (wasInAudit == null) break block5;
                        Object object = mi.proceed();
                        Object var10_5 = null;
                        this.inAudit.set(wasInAudit);
                        return object;
                    }
                    catch (Throwable throwable) {
                        Object var10_9 = null;
                        this.inAudit.set(wasInAudit);
                        throw throwable;
                    }
                }
                auditableDef = mi.getMethod().getAnnotation(Auditable.class);
                if (auditableDef != null) break block6;
                Object object = mi.proceed();
                Object var10_6 = null;
                this.inAudit.set(wasInAudit);
                return object;
            }
            Object[] args = mi.getArguments();
            namedArguments = this.getInvocationArguments(auditableDef, args);
            serviceName = this.publicServiceIdentifier.getPublicServiceName(mi);
            if (serviceName != null) break block7;
            Object object = mi.proceed();
            Object var10_7 = null;
            this.inAudit.set(wasInAudit);
            return object;
        }
        String methodName = mi.getMethod().getName();
        this.inAudit.set(Boolean.TRUE);
        Object object = this.proceedWithAudit(mi, auditableDef, serviceName, methodName, namedArguments);
        Object var10_8 = null;
        this.inAudit.set(wasInAudit);
        return object;
    }

    private Object proceedWithAudit(MethodInvocation mi, Auditable auditableDef, String serviceName, String methodName, Map<String, Serializable> namedArguments) throws Throwable {
        try {
            this.auditInvocationBefore(serviceName, methodName, namedArguments);
        }
        catch (Throwable e) {
            logger.error((Object)("Failed to audit pre-invocation: \n   Invocation: " + mi), e);
        }
        Object ret = null;
        Throwable thrown = null;
        try {
            ret = mi.proceed();
        }
        catch (Throwable e) {
            thrown = e;
        }
        Object auditRet = auditableDef.recordReturnedObject() ? ret : null;
        try {
            this.auditInvocationAfter(serviceName, methodName, namedArguments, auditRet, thrown);
        }
        catch (Throwable e) {
            logger.error((Object)("Failed to audit post-invocation: \n   Invocation: " + mi), e);
        }
        if (thrown != null) {
            throw thrown;
        }
        return ret;
    }

    private Map<String, Serializable> getInvocationArguments(Auditable auditableDef, Object[] args) {
        String[] params = auditableDef.parameters();
        boolean[] recordable = auditableDef.recordable();
        HashMap<String, Serializable> namedArgs = new HashMap<String, Serializable>(args.length * 2);
        for (int i = 0; i < args.length && i < params.length; ++i) {
            Object arg;
            if (i < recordable.length && !recordable[i]) continue;
            if (args[i] == null) {
                arg = null;
            } else if (args[i] instanceof Serializable) {
                arg = (Serializable)args[i];
            } else {
                try {
                    arg = (Serializable)DefaultTypeConverter.INSTANCE.convert(String.class, args[i]);
                }
                catch (TypeConversionException e) {
                    continue;
                }
            }
            if (arg instanceof String) {
                arg = SchemaBootstrap.trimStringForTextFields((String)arg);
            }
            namedArgs.put(params[i], (Serializable)arg);
        }
        return namedArgs;
    }

    private void auditInvocationBefore(String serviceName, String methodName, Map<String, Serializable> namedArguments) {
        String rootPath = AuditApplication.buildPath(AUDIT_PATH_API_PRE, serviceName, methodName, AUDIT_SNIPPET_ARGS);
        Map<String, Serializable> auditedData = this.auditComponent.recordAuditValues(rootPath, namedArguments);
        if (logger.isDebugEnabled() && auditedData.size() > 0) {
            logger.debug((Object)("Audited before invocation: \n   Values: " + auditedData));
        }
    }

    private void auditInvocationAfter(String serviceName, String methodName, Map<String, Serializable> namedArguments, Object ret, Throwable thrown) {
        Map<String, Serializable> auditedData;
        final String rootPath = AuditApplication.buildPath(AUDIT_PATH_API_POST, serviceName, methodName);
        final HashMap<String, Serializable> auditData = new HashMap<String, Serializable>(23);
        for (Map.Entry<String, Serializable> entry : namedArguments.entrySet()) {
            String argName = entry.getKey();
            Serializable argValue = entry.getValue();
            auditData.put(AuditApplication.buildPath(AUDIT_SNIPPET_ARGS, argName), argValue);
        }
        if (ret != null) {
            if (ret instanceof String) {
                ret = SchemaBootstrap.trimStringForTextFields((String)ret);
            }
            if (ret instanceof Serializable) {
                auditData.put(AUDIT_SNIPPET_RESULT, (Serializable)ret);
            } else {
                try {
                    ret = DefaultTypeConverter.INSTANCE.convert(String.class, ret);
                    auditData.put(AUDIT_SNIPPET_RESULT, (Serializable)((Object)((String)ret)));
                }
                catch (TypeConversionException e) {
                    // empty catch block
                }
            }
        }
        if (thrown != null) {
            StringBuilder sb = new StringBuilder(1024);
            StackTraceUtil.buildStackTrace((String)thrown.getMessage(), (StackTraceElement[])thrown.getStackTrace(), (StringBuilder)sb, (int)Integer.MAX_VALUE);
            auditData.put(AUDIT_SNIPPET_ERROR, (Serializable)((Object)SchemaBootstrap.trimStringForTextFields(sb.toString())));
            RetryingTransactionHelper.RetryingTransactionCallback<Map<String, Serializable>> auditCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Map<String, Serializable>>(){

                @Override
                public Map<String, Serializable> execute() throws Throwable {
                    return AuditMethodInterceptor.this.auditComponent.recordAuditValues(rootPath, auditData);
                }
            };
            auditedData = this.transactionService.getRetryingTransactionHelper().doInTransaction(auditCallback, false, true);
        } else {
            auditData.put(AUDIT_SNIPPET_NO_ERROR, null);
            auditedData = this.auditComponent.recordAuditValues(rootPath, auditData);
        }
        if (logger.isDebugEnabled() && auditedData.size() > 0) {
            logger.debug((Object)("Audited after invocation: \n" + (thrown == null ? "" : "   Exception: " + thrown.getMessage() + "\n") + "   Values: " + auditedData));
        }
    }
}

