/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.audit.PublicServiceIdentifier;
import org.alfresco.service.PublicService;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;

public class PublicServiceIdentifierImpl
implements PublicServiceIdentifier,
BeanFactoryAware {
    private static Log s_logger = LogFactory.getLog(PublicServiceIdentifierImpl.class);
    private static ThreadLocal<HashMap<Method, String>> methodToServiceMap = new ThreadLocal();
    private ListableBeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    public String getPublicServiceName(MethodInvocation mi) {
        return this.getServiceName(mi);
    }

    private String getServiceName(MethodInvocation mi) throws BeansException {
        if (methodToServiceMap.get() == null) {
            methodToServiceMap.set(new HashMap());
        }
        Method method = mi.getMethod();
        String serviceName = methodToServiceMap.get().get(method);
        if (serviceName == null) {
            serviceName = this.getServiceNameImpl(mi);
            methodToServiceMap.get().put(method, serviceName);
        } else if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Cached look up for " + serviceName + "." + method.getName()));
        }
        return serviceName;
    }

    private String getServiceNameImpl(MethodInvocation mi) throws BeansException {
        for (Class<?> clazz = mi.getThis().getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Class<?>[] interfaces;
            for (Class<?> iFace : interfaces = clazz.getInterfaces()) {
                Class publicServiceInterface = this.findPublicService(iFace);
                if (publicServiceInterface == null) continue;
                Map beans = this.beanFactory.getBeansOfType(publicServiceInterface);
                for (Map.Entry entry : beans.entrySet()) {
                    String serviceName = (String)entry.getKey();
                    if (!serviceName.endsWith("Service") || !Character.isUpperCase(serviceName.charAt(0)) || serviceName.equals("DescriptorService")) continue;
                    return serviceName;
                }
            }
        }
        return null;
    }

    private Class findPublicService(Class clazz) {
        Class<?>[] classes;
        if (!clazz.isInterface()) {
            return null;
        }
        if (clazz.isAnnotationPresent(PublicService.class)) {
            return clazz;
        }
        for (Class<?> implemented : classes = clazz.getInterfaces()) {
            Class answer = this.findPublicService(implemented);
            if (answer == null) continue;
            return answer;
        }
        return null;
    }
}

