/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.service.cmr.avm.AVMException;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.avm.LayeringDescriptor;
import org.alfresco.service.cmr.avm.VersionDescriptor;
import org.alfresco.service.cmr.remote.AVMRemoteTransport;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVMRemoteTransportService
implements AVMRemoteTransport,
Runnable {
    private Map<String, InputStream> fInputStreams = new HashMap<String, InputStream>();
    private Map<String, Long> fInputLastAccessTimes = new HashMap<String, Long>();
    private Map<String, Boolean> fInputBusy = new HashMap<String, Boolean>();
    private Map<String, OutputStream> fOutputStreams = new HashMap<String, OutputStream>();
    private Map<String, Long> fOutputLastAccessTimes = new HashMap<String, Long>();
    private Map<String, Boolean> fOutputBusy = new HashMap<String, Boolean>();
    private long fIdleTimeout = 30000L;
    private AVMService fAVMService;
    private AuthenticationService fAuthService;
    private Thread fThread;
    private boolean fDone;

    public void setIdleTimeout(long timeout) {
        this.fIdleTimeout = timeout;
    }

    public void setAvmService(AVMService service) {
        this.fAVMService = service;
    }

    public void setAuthenticationService(AuthenticationService service) {
        this.fAuthService = service;
    }

    public void init() {
        this.fThread = new Thread(this);
        this.fThread.setDaemon(true);
        this.fDone = false;
        this.fThread.start();
    }

    @Override
    public synchronized void run() {
        while (!this.fDone) {
            try {
                this.wait(this.fIdleTimeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            long now = System.currentTimeMillis();
            ArrayList<String> toClose = new ArrayList<String>();
            for (String handle : this.fInputLastAccessTimes.keySet()) {
                if (this.fInputBusy.get(handle).booleanValue() || now - this.fInputLastAccessTimes.get(handle) <= this.fIdleTimeout) continue;
                toClose.add(handle);
            }
            for (String handle : toClose) {
                try {
                    this.fInputStreams.get(handle).close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.fInputStreams.remove(handle);
                this.fInputLastAccessTimes.remove(handle);
                this.fInputBusy.remove(handle);
            }
            toClose.clear();
            for (String handle : this.fOutputLastAccessTimes.keySet()) {
                if (this.fOutputBusy.get(handle).booleanValue() || now - this.fOutputLastAccessTimes.get(handle) <= this.fIdleTimeout) continue;
                toClose.add(handle);
            }
            for (String handle : toClose) {
                try {
                    this.fOutputStreams.get(handle).close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.fOutputStreams.remove(handle);
                this.fOutputLastAccessTimes.remove(handle);
                this.fOutputBusy.remove(handle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        AVMRemoteTransportService aVMRemoteTransportService = this;
        synchronized (aVMRemoteTransportService) {
            this.fDone = true;
            this.notifyAll();
        }
        try {
            this.fThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInputHandle(String ticket, int version, String path) {
        this.fAuthService.validate(ticket);
        InputStream in = this.fAVMService.getFileInputStream(version, path);
        String handle = GUID.generate();
        AVMRemoteTransportService aVMRemoteTransportService = this;
        synchronized (aVMRemoteTransportService) {
            this.fInputStreams.put(handle, in);
            this.fInputLastAccessTimes.put(handle, System.currentTimeMillis());
            this.fInputBusy.put(handle, false);
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInputHandle(String ticket, AVMNodeDescriptor desc) {
        this.fAuthService.validate(ticket);
        InputStream in = this.fAVMService.getFileInputStream(desc);
        String handle = GUID.generate();
        AVMRemoteTransportService aVMRemoteTransportService = this;
        synchronized (aVMRemoteTransportService) {
            this.fInputStreams.put(handle, in);
            this.fInputLastAccessTimes.put(handle, System.currentTimeMillis());
            this.fInputBusy.put(handle, false);
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readInput(String ticket, String handle, int count) {
        AVMRemoteTransportService aVMRemoteTransportService;
        byte[] byArray;
        byte[] buff;
        block18: {
            this.fAuthService.validate(ticket);
            InputStream in = null;
            AVMRemoteTransportService aVMRemoteTransportService2 = this;
            synchronized (aVMRemoteTransportService2) {
                in = this.fInputStreams.get(handle);
                if (in == null) {
                    throw new AVMException("Invalid Input Handle.");
                }
                this.fInputBusy.put(handle, true);
                this.fInputLastAccessTimes.put(handle, System.currentTimeMillis());
            }
            buff = new byte[count];
            int read = in.read(buff);
            if (read == -1) {
                read = 0;
            }
            if (read == count) break block18;
            byte[] newBuff = new byte[read];
            for (int i = 0; i < read; ++i) {
                newBuff[i] = buff[i];
            }
            byte[] byArray2 = newBuff;
            Object var10_13 = null;
            AVMRemoteTransportService aVMRemoteTransportService3 = this;
            synchronized (aVMRemoteTransportService3) {
                this.fInputBusy.put(handle, false);
            }
            return byArray2;
        }
        try {
            byArray = buff;
            Object var10_14 = null;
            aVMRemoteTransportService = this;
        }
        catch (IOException e) {
            try {
                throw new AVMException("I/O Error.");
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                AVMRemoteTransportService aVMRemoteTransportService4 = this;
                synchronized (aVMRemoteTransportService4) {
                    this.fInputBusy.put(handle, false);
                }
                throw throwable;
            }
        }
        synchronized (aVMRemoteTransportService) {
            this.fInputBusy.put(handle, false);
        }
        return byArray;
    }

    @Override
    public synchronized void closeInputHandle(String ticket, String handle) {
        this.fAuthService.validate(ticket);
        InputStream in = this.fInputStreams.get(handle);
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.fInputStreams.remove(handle);
            this.fInputLastAccessTimes.remove(handle);
            this.fInputBusy.remove(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOutputHandle(String ticket, String path) {
        this.fAuthService.validate(ticket);
        OutputStream out = this.fAVMService.getFileOutputStream(path);
        String handle = GUID.generate();
        AVMRemoteTransportService aVMRemoteTransportService = this;
        synchronized (aVMRemoteTransportService) {
            this.fOutputStreams.put(handle, out);
            this.fOutputLastAccessTimes.put(handle, System.currentTimeMillis());
            this.fOutputBusy.put(handle, false);
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void writeOutput(String ticket, String handle, byte[] buff, int count) {
        AVMRemoteTransportService aVMRemoteTransportService;
        this.fAuthService.validate(ticket);
        OutputStream out = null;
        AVMRemoteTransportService aVMRemoteTransportService2 = this;
        synchronized (aVMRemoteTransportService2) {
            out = this.fOutputStreams.get(handle);
            if (out == null) {
                throw new AVMException("Invalid Output Handle.");
            }
            this.fOutputBusy.put(handle, true);
            this.fOutputLastAccessTimes.put(handle, System.currentTimeMillis());
        }
        try {
            try {
                out.write(buff, 0, count);
            }
            catch (IOException e) {
                throw new AVMException("I/O Errror.");
            }
            Object var9_8 = null;
            aVMRemoteTransportService = this;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            AVMRemoteTransportService aVMRemoteTransportService3 = this;
            synchronized (aVMRemoteTransportService3) {
                this.fOutputBusy.put(handle, false);
                throw throwable;
            }
        }
        synchronized (aVMRemoteTransportService) {
            this.fOutputBusy.put(handle, false);
            return;
        }
    }

    @Override
    public synchronized void closeOutputHandle(String ticket, String handle) {
        this.fAuthService.validate(ticket);
        OutputStream out = this.fOutputStreams.get(handle);
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.fOutputStreams.remove(handle);
            this.fOutputLastAccessTimes.remove(handle);
            this.fOutputBusy.remove(handle);
        }
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListingDirect(String ticket, int version, String path) {
        this.fAuthService.validate(ticket);
        return this.fAVMService.getDirectoryListingDirect(version, path);
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListing(String ticket, int version, String path) {
        this.fAuthService.validate(ticket);
        return this.fAVMService.getDirectoryListing(version, path);
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListing(String ticket, AVMNodeDescriptor dir) {
        this.fAuthService.validate(ticket);
        return this.fAVMService.getDirectoryListing(dir);
    }

    @Override
    public List<String> getDeleted(String ticket, int version, String path) {
        this.fAuthService.validate(ticket);
        return this.fAVMService.getDeleted(version, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createFile(String ticket, String path, String name) {
        this.fAuthService.validate(ticket);
        OutputStream out = this.fAVMService.createFile(path, name);
        String handle = GUID.generate();
        AVMRemoteTransportService aVMRemoteTransportService = this;
        synchronized (aVMRemoteTransportService) {
            this.fOutputStreams.put(handle, out);
            this.fOutputLastAccessTimes.put(handle, System.currentTimeMillis());
            this.fOutputBusy.put(handle, false);
        }
        return handle;
    }

    @Override
    public void createDirectory(String ticket, String path, String name) {
        this.fAuthService.validate(ticket);
        this.fAVMService.createDirectory(path, name);
    }

    @Override
    public void createLayeredFile(String ticket, String targetPath, String parent, String name) {
        this.fAuthService.validate(ticket);
        this.fAVMService.createLayeredFile(targetPath, parent, name);
    }

    @Override
    public void createLayeredDirectory(String ticket, String targetPath, String parent, String name) {
        this.fAuthService.validate(ticket);
        this.fAVMService.createLayeredDirectory(targetPath, parent, name);
    }

    @Override
    public void retargetLayeredDirectory(String ticket, String path, String target) {
        this.fAuthService.validate(ticket);
        this.fAVMService.retargetLayeredDirectory(path, target);
    }

    @Override
    public void createStore(String ticket, String name) {
        this.fAuthService.validate(ticket);
        this.fAVMService.createStore(name);
    }

    @Override
    public void createBranch(String ticket, int version, String srcPath, String dstPath, String name) {
        this.fAuthService.validate(ticket);
        this.fAVMService.createBranch(version, srcPath, dstPath, name);
    }

    @Override
    public void removeNode(String ticket, String parent, String name) {
        this.fAuthService.validate(ticket);
        this.fAVMService.removeNode(parent, name);
    }

    @Override
    public void rename(String ticket, String srcParent, String srcName, String dstParent, String dstName) {
        this.fAuthService.validate(ticket);
        this.fAVMService.rename(srcParent, srcName, dstParent, dstName);
    }

    @Override
    public void uncover(String ticket, String dirPath, String name) {
        this.fAuthService.validate(ticket);
        this.fAVMService.uncover(dirPath, name);
    }

    @Override
    public int getNextVersionID(String ticket, String storeName) {
        this.fAuthService.validate(ticket);
        return this.fAVMService.getNextVersionID(storeName);
    }

    @Override
    public int getLatestSnapshotID(String ticket, String storeName) {
        return this.fAVMService.getLatestSnapshotID(storeName);
    }

    @Override
    public Map<String, Integer> createSnapshot(String ticket, String store, String label, String comment) {
        this.fAuthService.validate(ticket);
        return this.fAVMService.createSnapshot(store, label, comment);
    }

    @Override
    public List<VersionDescriptor> getStoreVersions(String ticket, String name) {
        this.fAuthService.validate(ticket);
        return this.fAVMService.getStoreVersions(name);
    }

    @Override
    public List<VersionDescriptor> getStoreVersions(String ticket, String name, Date from, Date to) {
        this.fAuthService.validate(ticket);
        return this.fAVMService.getStoreVersions(name, from, to);
    }

    @Override
    public List<AVMStoreDescriptor> getStores(String ticket) {
        this.fAuthService.validate(ticket);
        return this.fAVMService.getStores();
    }

    @Override
    public AVMStoreDescriptor getStore(String ticket, String name) {
        this.fAuthService.validate(ticket);
        return this.fAVMService.getStore(name);
    }

    @Override
    public AVMNodeDescriptor getStoreRoot(String ticket, int version, String name) {
        this.fAuthService.validate(ticket);
        return this.fAVMService.getStoreRoot(version, name);
    }

    @Override
    public AVMNodeDescriptor lookup(String ticket, int version, String path) {
        this.fAuthService.validate(ticket);
        return this.fAVMService.lookup(version, path);
    }

    @Override
    public AVMNodeDescriptor lookup(String ticket, int version, String path, boolean includeDeleted) {
        this.fAuthService.validate(ticket);
        return this.fAVMService.lookup(version, path, includeDeleted);
    }

    @Override
    public AVMNodeDescriptor lookup(String ticket, AVMNodeDescriptor dir, String name) {
        this.fAuthService.validate(ticket);
        return this.fAVMService.lookup(dir, name);
    }

    @Override
    public AVMNodeDescriptor lookup(String ticket, AVMNodeDescriptor dir, String name, boolean includeDeleted) {
        this.fAuthService.validate(ticket);
        return this.fAVMService.lookup(dir, name, includeDeleted);
    }

    @Override
    public String getIndirectionPath(String ticket, int version, String path) {
        this.fAuthService.validate(ticket);
        return this.fAVMService.getIndirectionPath(version, path);
    }

    @Override
    public void purgeStore(String ticket, String name) {
        this.fAuthService.validate(ticket);
        this.fAVMService.purgeStore(name);
    }

    @Override
    public void purgeVersion(String ticket, int version, String name) {
        this.fAuthService.validate(ticket);
        this.fAVMService.purgeVersion(version, name);
    }

    @Override
    public void makePrimary(String ticket, String path) {
        this.fAuthService.validate(ticket);
        this.fAVMService.makePrimary(path);
    }

    @Override
    public List<AVMNodeDescriptor> getHistory(String ticket, AVMNodeDescriptor desc, int count) {
        this.fAuthService.validate(ticket);
        return this.fAVMService.getHistory(desc, count);
    }

    @Override
    public void setOpacity(String ticket, String path, boolean opacity) {
        this.fAuthService.validate(ticket);
        this.fAVMService.setOpacity(path, opacity);
    }

    @Override
    public AVMNodeDescriptor getCommonAncestor(String ticket, AVMNodeDescriptor left, AVMNodeDescriptor right) {
        this.fAuthService.validate(ticket);
        return this.fAVMService.getCommonAncestor(left, right);
    }

    @Override
    public LayeringDescriptor getLayeringInfo(String ticket, int version, String path) {
        this.fAuthService.validate(ticket);
        return this.fAVMService.getLayeringInfo(version, path);
    }

    @Override
    public void setNodeProperty(String ticket, String path, QName name, PropertyValue value) {
        this.fAuthService.validate(ticket);
        this.fAVMService.setNodeProperty(path, name, value);
    }

    @Override
    public void setNodeProperties(String ticket, String path, Map<QName, PropertyValue> properties) {
        this.fAuthService.validate(ticket);
        this.fAVMService.setNodeProperties(path, properties);
    }

    @Override
    public PropertyValue getNodeProperty(String ticket, int version, String path, QName name) {
        this.fAuthService.validate(ticket);
        return this.fAVMService.getNodeProperty(version, path, name);
    }

    @Override
    public Map<QName, PropertyValue> getNodeProperties(String ticket, int version, String path) {
        this.fAuthService.validate(ticket);
        return this.fAVMService.getNodeProperties(version, path);
    }

    @Override
    public void deleteNodeProperty(String ticket, String path, QName name) {
        this.fAuthService.validate(ticket);
        this.fAVMService.deleteNodeProperty(path, name);
    }

    @Override
    public void deleteNodeProperties(String ticket, String path) {
        this.fAuthService.validate(ticket);
        this.fAVMService.deleteNodeProperties(path);
    }

    @Override
    public void setStoreProperty(String ticket, String store, QName name, PropertyValue value) {
        this.fAuthService.validate(ticket);
        this.fAVMService.setStoreProperty(store, name, value);
    }

    @Override
    public void setStoreProperties(String ticket, String store, Map<QName, PropertyValue> props) {
        this.fAuthService.validate(ticket);
        this.fAVMService.setStoreProperties(store, props);
    }

    @Override
    public PropertyValue getStoreProperty(String ticket, String store, QName name) {
        this.fAuthService.validate(ticket);
        return this.fAVMService.getStoreProperty(store, name);
    }

    @Override
    public Map<QName, PropertyValue> queryStorePropertyKey(String ticket, String store, QName keyPattern) {
        this.fAuthService.validate(ticket);
        return this.fAVMService.queryStorePropertyKey(store, keyPattern);
    }

    @Override
    public Map<String, Map<QName, PropertyValue>> queryStoresPropertyKey(String ticket, QName keyPattern) {
        this.fAuthService.validate(ticket);
        return this.fAVMService.queryStoresPropertyKeys(keyPattern);
    }

    @Override
    public Map<QName, PropertyValue> getStoreProperties(String ticket, String store) {
        this.fAuthService.validate(ticket);
        return this.fAVMService.getStoreProperties(store);
    }

    @Override
    public void deleteStoreProperty(String ticket, String store, QName name) {
        this.fAuthService.validate(ticket);
        this.fAVMService.deleteStoreProperty(store, name);
    }

    @Override
    public void renameStore(String ticket, String sourceName, String destName) {
        this.fAuthService.validate(ticket);
        this.fAVMService.renameStore(sourceName, destName);
    }

    @Override
    public void addAspect(String ticket, String path, QName aspectName) {
        this.fAuthService.validate(ticket);
        this.fAVMService.addAspect(path, aspectName);
    }

    @Override
    public Set<QName> getAspects(String ticket, int version, String path) {
        this.fAuthService.validate(ticket);
        return this.fAVMService.getAspects(version, path);
    }

    @Override
    public boolean hasAspect(String ticket, int version, String path, QName aspectName) {
        this.fAuthService.validate(ticket);
        return this.fAVMService.hasAspect(version, path, aspectName);
    }

    @Override
    public void removeAspect(String ticket, String path, QName aspectName) {
        this.fAuthService.validate(ticket);
        this.fAVMService.removeAspect(path, aspectName);
    }

    @Override
    public void revert(String ticket, String path, AVMNodeDescriptor toRevertTo) {
        this.fAuthService.validate(ticket);
        this.fAVMService.revert(path, toRevertTo);
    }

    @Override
    public Pair<Integer, String> getAPath(String ticket, AVMNodeDescriptor desc) {
        this.fAuthService.validate(ticket);
        return this.fAVMService.getAPath(desc);
    }

    @Override
    public void setGuid(String ticket, String path, String guid) {
        this.fAuthService.validate(ticket);
        this.fAVMService.setGuid(path, guid);
    }

    @Override
    public void setEncoding(String ticket, String path, String encoding) {
        this.fAuthService.validate(ticket);
        this.fAVMService.setEncoding(path, encoding);
    }

    @Override
    public void setMimeType(String ticket, String path, String mimeType) {
        this.fAuthService.validate(ticket);
        this.fAVMService.setMimeType(path, mimeType);
    }
}

