/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WCMModel;
import org.alfresco.repo.avm.AVMDAOs;
import org.alfresco.repo.avm.AVMNode;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.avm.AVMRepository;
import org.alfresco.repo.avm.AVMStore;
import org.alfresco.repo.avm.AVMStorePropertyImpl;
import org.alfresco.repo.avm.DirectoryNode;
import org.alfresco.repo.avm.DirectoryNodeImpl;
import org.alfresco.repo.avm.FileNode;
import org.alfresco.repo.avm.Layered;
import org.alfresco.repo.avm.LayeredDirectoryNode;
import org.alfresco.repo.avm.LayeredDirectoryNodeImpl;
import org.alfresco.repo.avm.LayeredFileNode;
import org.alfresco.repo.avm.LayeredFileNodeImpl;
import org.alfresco.repo.avm.Lookup;
import org.alfresco.repo.avm.PlainDirectoryNodeImpl;
import org.alfresco.repo.avm.PlainFileNode;
import org.alfresco.repo.avm.PlainFileNodeImpl;
import org.alfresco.repo.avm.VersionLayeredNodeEntry;
import org.alfresco.repo.avm.VersionLayeredNodeEntryImpl;
import org.alfresco.repo.avm.VersionRoot;
import org.alfresco.repo.avm.VersionRootImpl;
import org.alfresco.repo.avm.util.AVMUtil;
import org.alfresco.repo.avm.util.RawServices;
import org.alfresco.repo.avm.util.SimplePath;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.domain.permissions.Acl;
import org.alfresco.repo.security.permissions.ACLCopyMode;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.avm.AVMBadArgumentException;
import org.alfresco.service.cmr.avm.AVMException;
import org.alfresco.service.cmr.avm.AVMExistsException;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMNotFoundException;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.avm.AVMWrongTypeException;
import org.alfresco.service.cmr.avm.VersionDescriptor;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVMStoreImpl
implements AVMStore {
    private static Log logger = LogFactory.getLog(AVMStoreImpl.class);
    private long fID;
    private String fName;
    private DirectoryNode fRoot;
    private int fNextVersionID;
    private long fVers;
    private Acl fACL;
    private transient AVMRepository fAVMRepository;

    public AVMStoreImpl() {
        this.fAVMRepository = AVMRepository.GetInstance();
    }

    public AVMStoreImpl(AVMRepository repo, String name) {
        this.fAVMRepository = repo;
        this.setName(name);
        this.setNextVersionID(0);
        this.setRoot(null);
        AVMDAOs.Instance().fAVMStoreDAO.save(this);
        String creator = RawServices.Instance().getAuthenticationContext().getCurrentUserName();
        if (creator == null) {
            creator = RawServices.Instance().getAuthenticationContext().getSystemUserName();
        }
        this.setProperty(ContentModel.PROP_CREATOR, new PropertyValue(null, (Serializable)((Object)creator)));
        this.setProperty(ContentModel.PROP_CREATED, new PropertyValue(null, new Date(System.currentTimeMillis())));
        long time = System.currentTimeMillis();
        PlainDirectoryNodeImpl dir = new PlainDirectoryNodeImpl(this);
        dir.setIsRoot(true);
        AVMDAOs.Instance().fAVMNodeDAO.save(dir);
        this.setRoot(dir);
        VersionRootImpl versionRoot = new VersionRootImpl(this, this.getRoot(), this.getNextVersionID(), time, creator, "Initial Empty Version.", "Initial Empty Version.");
        this.setNextVersionID(this.getNextVersionID() + 1);
        AVMDAOs.Instance().fAVMStoreDAO.update(this);
        AVMDAOs.Instance().fVersionRootDAO.save(versionRoot);
    }

    public void setId(long id) {
        this.fID = id;
    }

    @Override
    public long getId() {
        return this.fID;
    }

    @Override
    public void setNewRoot(DirectoryNode root) {
        this.fRoot = root;
    }

    @Override
    public Map<String, Integer> createSnapshot(String tag, String description, Map<String, Integer> snapShotMap) {
        long start = System.currentTimeMillis();
        long rootID = this.getRoot().getId();
        AVMStoreImpl me = (AVMStoreImpl)AVMDAOs.Instance().fAVMStoreDAO.getByID(this.getId());
        VersionRoot lastVersion = AVMDAOs.Instance().fVersionRootDAO.getMaxVersion(me);
        List<VersionLayeredNodeEntry> layeredEntries = AVMDAOs.Instance().fVersionLayeredNodeEntryDAO.get(lastVersion);
        DirectoryNode root = (DirectoryNode)AVMDAOs.Instance().fAVMNodeDAO.getByID(rootID);
        if (!root.getIsNew() && layeredEntries.size() == 0) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("createSnapshot: no snapshot required: " + me.getName() + " [" + me.getId() + "] - lastVersion = " + lastVersion.getVersionID() + "(" + tag + ", " + description + ")"));
            }
            if (tag != null || description != null) {
                lastVersion.setTag(tag);
                lastVersion.setDescription(description);
                AVMDAOs.Instance().fVersionRootDAO.update(lastVersion);
            }
            snapShotMap.put(this.getName(), lastVersion.getVersionID());
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("createSnapshot: no snapshot required: " + me.getName() + (tag != null ? "(" + tag + ")" : "") + " [lastVersion = " + lastVersion.getVersionID() + "]"));
            }
            return snapShotMap;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("createSnapshot: snapshot: " + me.getName() + " [" + me.getId() + "] - lastVersion=" + lastVersion.getVersionID() + ", layeredEntries=" + layeredEntries.size()));
        }
        snapShotMap.put(this.getName(), me.getNextVersionID());
        for (VersionLayeredNodeEntry entry : layeredEntries) {
            String[] pathParts = AVMUtil.splitPath(entry.getPath());
            Lookup lookup = me.lookup(-1, pathParts[1], false, false);
            if (lookup == null || lookup.getCurrentNode().getType() != 3 && lookup.getCurrentNode().getType() != 1 || lookup.getCurrentNode().getIsNew()) continue;
            if (lookup.getCurrentNode().getType() == 3) {
                this.fAVMRepository.forceCopy(entry.getPath());
                me = (AVMStoreImpl)AVMDAOs.Instance().fAVMStoreDAO.getByID(this.getId());
                continue;
            }
            if (lookup.getCurrentNode().getType() != 1) continue;
            String[] parentName = AVMUtil.splitBase(entry.getPath());
            AVMNode child = lookup.getCurrentNode();
            DirectoryNode parent = lookup.getCurrentNodeDirectory();
            LayeredFileNode newChild = ((LayeredFileNode)child).copyLiterally(lookup);
            newChild.setAncestor(child);
            parent.putChild(parentName[1], newChild);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("createSnapshot: force copy: " + me.getName() + (tag != null ? "(" + tag + ")" : "") + " [lastVersion=" + lastVersion.getVersionID() + ", layeredEntriesCnt=" + layeredEntries.size() + "] in " + (System.currentTimeMillis() - start) + " msecs"));
        }
        List<Long> allLayeredNodeIDs = AVMDAOs.Instance().fAVMNodeDAO.getNewLayeredInStoreIDs(me);
        AVMDAOs.Instance().fAVMNodeDAO.clearNewInStore(me);
        AVMDAOs.Instance().fAVMNodeDAO.clear();
        ArrayList<Long> layeredNodeIDs = new ArrayList<Long>();
        for (Long layeredID : allLayeredNodeIDs) {
            Layered layered = (Layered)AVMDAOs.Instance().fAVMNodeDAO.getByID(layeredID);
            String indirection = null;
            if (layered != null) {
                indirection = layered.getIndirection();
            }
            if (indirection == null) continue;
            layeredNodeIDs.add(layeredID);
            String storeName = AVMUtil.getStoreName(indirection);
            if (!snapShotMap.containsKey(storeName)) {
                AVMStore store = AVMDAOs.Instance().fAVMStoreDAO.getByName(storeName);
                if (store == null) {
                    layered.setIndirectionVersion(-1);
                } else {
                    store.createSnapshot(null, null, snapShotMap);
                    layered = (Layered)AVMDAOs.Instance().fAVMNodeDAO.getByID(layeredID);
                    layered.setIndirectionVersion(snapShotMap.get(storeName));
                }
            } else {
                layered.setIndirectionVersion(snapShotMap.get(storeName));
            }
            AVMDAOs.Instance().fAVMNodeDAO.update(layered);
        }
        String user = RawServices.Instance().getAuthenticationContext().getCurrentUserName();
        if (user == null) {
            user = RawServices.Instance().getAuthenticationContext().getSystemUserName();
        }
        me = (AVMStoreImpl)AVMDAOs.Instance().fAVMStoreDAO.getByID(this.getId());
        VersionRootImpl versionRoot = new VersionRootImpl(me, me.getRoot(), me.getNextVersionID(), System.currentTimeMillis(), user, tag, description);
        me.setNextVersionID(me.getNextVersionID() + 1);
        AVMDAOs.Instance().fAVMStoreDAO.update(me);
        AVMDAOs.Instance().fVersionRootDAO.save(versionRoot);
        int vlneCnt = 0;
        for (Long nodeID : layeredNodeIDs) {
            AVMNode node = AVMDAOs.Instance().fAVMNodeDAO.getByID(nodeID);
            List<String> paths = this.fAVMRepository.getVersionPaths(versionRoot, node);
            for (String path : paths) {
                VersionLayeredNodeEntryImpl entry = new VersionLayeredNodeEntryImpl(versionRoot, path);
                AVMDAOs.Instance().fVersionLayeredNodeEntryDAO.save(entry);
            }
            vlneCnt += paths.size();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Raw snapshot: " + me.getName() + (tag != null ? "(" + tag + ")" : "") + " [versionRootId=" + versionRoot.getId() + ", layeredNodeIDsCnt=" + layeredNodeIDs.size() + ", versionLayeredNodeEntriesCnt=" + vlneCnt + "] in " + (System.currentTimeMillis() - start) + " msecs"));
        }
        return snapShotMap;
    }

    @Override
    public void createDirectory(String path, String name, List<QName> aspects, Map<QName, PropertyValue> properties) {
        AVMNode child;
        Lookup lPath = this.lookupDirectory(-1, path, true);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + path + " not found.");
        }
        DirectoryNode dir = (DirectoryNode)lPath.getCurrentNode();
        if (!this.fAVMRepository.can(this, dir, "AddChildren", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to write: " + path);
        }
        Pair<AVMNode, Boolean> temp = dir.lookupChild(lPath, name, true);
        AVMNode aVMNode = child = temp == null ? null : (AVMNode)temp.getFirst();
        if (child != null && child.getType() != 4) {
            throw new AVMExistsException("Child exists: " + name);
        }
        DirectoryNodeImpl newDir = null;
        if (lPath.isLayered()) {
            newDir = new LayeredDirectoryNodeImpl(null, this, null, null, ACLCopyMode.INHERIT);
            ((LayeredDirectoryNodeImpl)newDir).setPrimaryIndirection(false);
            ((LayeredDirectoryNodeImpl)newDir).setLayerID(lPath.getTopLayer().getLayerID());
            newDir.copyACLs(dir, ACLCopyMode.INHERIT);
            AVMDAOs.Instance().fAVMNodeDAO.update(newDir);
        } else {
            newDir = new PlainDirectoryNodeImpl(this);
            newDir.copyACLs(dir, ACLCopyMode.INHERIT);
            AVMDAOs.Instance().fAVMNodeDAO.save(newDir);
        }
        if (child != null) {
            newDir.setAncestor(child);
        }
        dir.putChild(name, newDir);
        if (aspects != null) {
            HashSet<QName> aspectQNames = new HashSet<QName>(newDir.getAspects());
            aspectQNames.addAll(aspects);
            newDir.setAspects(aspectQNames);
        }
        if (properties != null) {
            HashMap<QName, PropertyValue> props = new HashMap<QName, PropertyValue>(newDir.getProperties());
            props.putAll(properties);
            newDir.setProperties(props);
        }
    }

    @Override
    public void createLayeredDirectory(String srcPath, String dstPath, String name) {
        AVMNode child;
        Lookup lPath = this.lookupDirectory(-1, dstPath, true);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + dstPath + " not found.");
        }
        DirectoryNode dir = (DirectoryNode)lPath.getCurrentNode();
        Pair<AVMNode, Boolean> temp = dir.lookupChild(lPath, name, true);
        AVMNode aVMNode = child = temp == null ? null : (AVMNode)temp.getFirst();
        if (child != null && child.getType() != 4) {
            throw new AVMExistsException("Child exists: " + name);
        }
        Long parentAcl = dir.getAcl() == null ? null : dir.getAcl().getId();
        LayeredDirectoryNodeImpl newDir = new LayeredDirectoryNodeImpl(srcPath, this, null, parentAcl, ACLCopyMode.INHERIT);
        if (lPath.isLayered()) {
            LayeredDirectoryNode top = lPath.getTopLayer();
            newDir.setLayerID(top.getLayerID());
        } else {
            newDir.setLayerID(newDir.getId());
        }
        AVMDAOs.Instance().fAVMNodeDAO.update(newDir);
        if (child != null) {
            newDir.setAncestor(child);
        }
        dir.putChild(name, newDir);
    }

    @Override
    public OutputStream createFile(String path, String name) {
        return this.createFile(path, name, null, null).getContentOutputStream();
    }

    @Override
    public void createFile(String path, String name, File data, List<QName> aspects, Map<QName, PropertyValue> properties) {
        this.createFile(path, name, aspects, properties).putContent(data);
    }

    private ContentWriter createFile(String path, String name, List<QName> aspects, Map<QName, PropertyValue> properties) {
        AVMNode child;
        Lookup lPath = this.lookupDirectory(-1, path, true);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + path + " not found.");
        }
        DirectoryNode dir = (DirectoryNode)lPath.getCurrentNode();
        if (!this.fAVMRepository.can(this, dir, "AddChildren", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to write: " + path);
        }
        Pair<AVMNode, Boolean> temp = dir.lookupChild(lPath, name, true);
        AVMNode aVMNode = child = temp == null ? null : (AVMNode)temp.getFirst();
        if (child != null && child.getType() != 4) {
            throw new AVMExistsException("Child exists: " + name);
        }
        PlainFileNodeImpl file = new PlainFileNodeImpl(this);
        file.setContentData(new ContentData(null, RawServices.Instance().getMimetypeService().guessMimetype(name), -1L, "UTF-8"));
        file.copyACLs(dir, ACLCopyMode.INHERIT);
        AVMDAOs.Instance().fAVMNodeDAO.save(file);
        dir.putChild(name, file);
        if (child != null) {
            file.setAncestor(child);
        }
        if (aspects != null) {
            HashSet<QName> aspectQNames = new HashSet<QName>(aspects.size());
            aspectQNames.addAll(aspects);
            file.setAspects(aspectQNames);
        }
        if (properties != null) {
            HashMap<QName, PropertyValue> props = new HashMap<QName, PropertyValue>(properties.size());
            props.putAll(properties);
            file.setProperties(props);
        }
        return this.createContentWriter(AVMNodeConverter.ExtendAVMPath(path, name), true);
    }

    @Override
    public void createLayeredFile(String srcPath, String dstPath, String name) {
        AVMNode child;
        Lookup lPath = this.lookupDirectory(-1, dstPath, true);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + dstPath + " not found.");
        }
        DirectoryNode dir = (DirectoryNode)lPath.getCurrentNode();
        if (!this.fAVMRepository.can(this, dir, "AddChildren", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to write: " + dstPath);
        }
        Pair<AVMNode, Boolean> temp = dir.lookupChild(lPath, name, true);
        AVMNode aVMNode = child = temp == null ? null : (AVMNode)temp.getFirst();
        if (child != null && child.getType() != 4) {
            throw new AVMExistsException("Child exists: " + name);
        }
        String[] srcPathParts = srcPath.split(":");
        String[] dstPathParts = dstPath.split(":");
        Lookup lPathSrc = null;
        if (srcPathParts[0].equals(dstPathParts[0])) {
            lPathSrc = this.lookup(-1, srcPathParts[1], false, false);
        } else {
            AVMStore srcStore = AVMDAOs.Instance().fAVMStoreDAO.getByName(srcPathParts[0]);
            if (srcStore != null) {
                lPathSrc = srcStore.lookup(-1, srcPathParts[1], false, false);
            }
        }
        AVMNode srcNode = null;
        if (lPathSrc == null) {
            logger.warn((Object)("CreateLayeredFile: srcPath not found: " + srcPath));
        } else {
            srcNode = lPathSrc.getCurrentNode();
            if (!(srcNode instanceof FileNode)) {
                logger.warn((Object)("CreateLayeredFile: srcPath is not a file: " + srcPath));
            }
        }
        LayeredFileNodeImpl newFile = new LayeredFileNodeImpl(srcPath, this, null);
        newFile.copyACLs(dir, ACLCopyMode.INHERIT);
        AVMDAOs.Instance().fAVMNodeDAO.save(newFile);
        if (child != null) {
            newFile.setAncestor(child);
        } else if (srcNode != null && srcNode instanceof FileNode) {
            newFile.setAncestor((FileNode)srcNode);
        }
        dir.putChild(name, newFile);
    }

    @Override
    public InputStream getInputStream(int version, String path) {
        ContentReader reader = this.getContentReader(version, path);
        if (reader == null) {
            throw new AVMNotFoundException(path + " has no content.");
        }
        return reader.getContentInputStream();
    }

    @Override
    public ContentReader getContentReader(int version, String path) {
        try {
            NodeRef nodeRef = AVMNodeConverter.ToNodeRef(version, this.getName() + ":" + path);
            return RawServices.Instance().getContentService().getReader(nodeRef, ContentModel.PROP_CONTENT);
        }
        catch (InvalidNodeRefException inre) {
            throw new AVMNotFoundException("Path " + path + " not found.");
        }
    }

    @Override
    public ContentWriter createContentWriter(String path, boolean update) {
        try {
            NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, this.getName() + ":" + path);
            ContentWriter writer = RawServices.Instance().getContentService().getWriter(nodeRef, ContentModel.PROP_CONTENT, update);
            return writer;
        }
        catch (InvalidNodeRefException inre) {
            throw new AVMNotFoundException("Path " + path + " not found.");
        }
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getListing(int version, String path, boolean includeDeleted) {
        Lookup lPath = this.lookupDirectory(version, path, false);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + path + " not found.");
        }
        DirectoryNode dir = (DirectoryNode)lPath.getCurrentNode();
        if (!this.fAVMRepository.can(this, dir, "ReadChildren", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to read: " + path);
        }
        Map<String, AVMNode> listing = dir.getListing(lPath, includeDeleted);
        return this.translateListing(listing, lPath);
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getListingDirect(int version, String path, boolean includeDeleted) {
        Lookup lPath = this.lookupDirectory(version, path, false);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + path + " not found.");
        }
        DirectoryNode dir = (DirectoryNode)lPath.getCurrentNode();
        if (!this.fAVMRepository.can(this, dir, "ReadChildren", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to read: " + path);
        }
        if (lPath.isLayered() && dir.getType() != 3) {
            return new TreeMap<String, AVMNodeDescriptor>();
        }
        Map<String, AVMNode> listing = dir.getListingDirect(lPath, includeDeleted);
        return this.translateListing(listing, lPath);
    }

    private SortedMap<String, AVMNodeDescriptor> translateListing(Map<String, AVMNode> listing, Lookup lPath) {
        TreeMap<String, AVMNodeDescriptor> results = new TreeMap<String, AVMNodeDescriptor>(String.CASE_INSENSITIVE_ORDER);
        for (String name : listing.keySet()) {
            AVMNode child = listing.get(name);
            AVMNodeDescriptor desc = child.getDescriptor(lPath, name);
            results.put(name, desc);
        }
        return results;
    }

    @Override
    public List<String> getDeleted(int version, String path) {
        Lookup lPath = this.lookupDirectory(version, path, false);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + path + " not found.");
        }
        DirectoryNode dir = (DirectoryNode)lPath.getCurrentNode();
        if (!this.fAVMRepository.can(this, dir, "ReadChildren", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to read: " + path);
        }
        List<String> deleted = dir.getDeletedNames();
        return deleted;
    }

    @Override
    public OutputStream getOutputStream(String path) {
        ContentWriter writer = this.createContentWriter(path, true);
        return writer.getContentOutputStream();
    }

    @Override
    public void removeNode(String path, String name) {
        AVMNode child;
        Lookup lPath = this.lookupDirectory(-1, path, true);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + path + " not found.");
        }
        DirectoryNode dir = (DirectoryNode)lPath.getCurrentNode();
        Pair<AVMNode, Boolean> temp = dir.lookupChild(lPath, name, false);
        AVMNode aVMNode = child = temp == null ? null : (AVMNode)temp.getFirst();
        if (child == null) {
            Lookup lPathToChild = this.lookup(-1, path + "/" + name, true, false);
            if (lPathToChild != null) {
                child = lPathToChild.getCurrentNode();
            }
            if (child == null) {
                throw new AVMNotFoundException("Does not exist: " + name);
            }
            dir = lPathToChild.getCurrentNodeDirectory();
        }
        if (!this.fAVMRepository.can(this, child, "DeleteNode", false)) {
            throw new AVMNotFoundException("Not allowed to delete in store : " + this.getName() + "  at " + path);
        }
        if (dir != null) {
            dir.removeChild(lPath, name);
        }
    }

    @Override
    public void uncover(String dirPath, String name) {
        AVMNode child;
        Lookup lPath = this.lookupDirectory(-1, dirPath, true);
        if (lPath == null) {
            throw new AVMNotFoundException("Directory path " + dirPath + " not found.");
        }
        DirectoryNode node = (DirectoryNode)lPath.getCurrentNode();
        if (node.getType() != 3) {
            throw new AVMWrongTypeException("Not a layered directory: " + dirPath);
        }
        Pair<AVMNode, Boolean> temp = node.lookupChild(lPath, name, true);
        AVMNode aVMNode = child = temp == null ? null : (AVMNode)temp.getFirst();
        if (child == null) {
            throw new AVMNotFoundException("No child to recover at " + dirPath + " called " + name);
        }
        if (!this.fAVMRepository.can(this, child, "DeleteNode", false)) {
            throw new AccessDeniedException("Not allowed to uncover: " + dirPath + "  ->  " + name);
        }
        ((LayeredDirectoryNode)node).uncover(lPath, name);
        node.updateModTime();
        AVMDAOs.Instance().fAVMNodeDAO.update(node);
    }

    @Override
    public List<VersionDescriptor> getVersions() {
        List<VersionRoot> versions = AVMDAOs.Instance().fVersionRootDAO.getAllInAVMStore(this);
        ArrayList<VersionDescriptor> descs = new ArrayList<VersionDescriptor>();
        for (VersionRoot vr : versions) {
            VersionDescriptor desc = new VersionDescriptor(this.getName(), vr.getVersionID(), vr.getCreator(), vr.getCreateDate(), vr.getTag(), vr.getDescription());
            descs.add(desc);
        }
        return descs;
    }

    @Override
    public List<VersionDescriptor> getVersions(Date from, Date to) {
        List<VersionRoot> versions = AVMDAOs.Instance().fVersionRootDAO.getByDates(this, from, to);
        ArrayList<VersionDescriptor> descs = new ArrayList<VersionDescriptor>();
        for (VersionRoot vr : versions) {
            VersionDescriptor desc = new VersionDescriptor(this.getName(), vr.getVersionID(), vr.getCreator(), vr.getCreateDate(), vr.getTag(), vr.getDescription());
            descs.add(desc);
        }
        return descs;
    }

    @Override
    public List<VersionDescriptor> getVersionsTo(int version) {
        List<VersionRoot> versions = AVMDAOs.Instance().fVersionRootDAO.getByVersionsTo(this, version);
        ArrayList<VersionDescriptor> descs = new ArrayList<VersionDescriptor>();
        for (VersionRoot vr : versions) {
            VersionDescriptor desc = new VersionDescriptor(this.getName(), vr.getVersionID(), vr.getCreator(), vr.getCreateDate(), vr.getTag(), vr.getDescription());
            descs.add(desc);
        }
        return descs;
    }

    @Override
    public List<VersionDescriptor> getVersionsFrom(int version) {
        List<VersionRoot> versions = AVMDAOs.Instance().fVersionRootDAO.getByVersionsFrom(this, version);
        ArrayList<VersionDescriptor> descs = new ArrayList<VersionDescriptor>();
        for (VersionRoot vr : versions) {
            VersionDescriptor desc = new VersionDescriptor(this.getName(), vr.getVersionID(), vr.getCreator(), vr.getCreateDate(), vr.getTag(), vr.getDescription());
            descs.add(desc);
        }
        return descs;
    }

    @Override
    public List<VersionDescriptor> getVersionsBetween(int startVersion, int endVersion) {
        List<VersionRoot> versions = AVMDAOs.Instance().fVersionRootDAO.getByVersionsBetween(this, startVersion, endVersion);
        ArrayList<VersionDescriptor> descs = new ArrayList<VersionDescriptor>();
        for (VersionRoot vr : versions) {
            VersionDescriptor desc = new VersionDescriptor(this.getName(), vr.getVersionID(), vr.getCreator(), vr.getCreateDate(), vr.getTag(), vr.getDescription());
            descs.add(desc);
        }
        return descs;
    }

    @Override
    public AVMRepository getAVMRepository() {
        return this.fAVMRepository;
    }

    @Override
    public Lookup lookup(int version, String path, boolean write, boolean includeDeleted) {
        SimplePath sPath = new SimplePath(path);
        return RawServices.Instance().getLookupCache().lookup(this, version, sPath, write, includeDeleted);
    }

    @Override
    public AVMNodeDescriptor getRoot(int version) {
        DirectoryNode root = null;
        root = version < 0 ? this.getRoot() : AVMDAOs.Instance().fAVMNodeDAO.getAVMStoreRoot(this, version);
        if (!this.fAVMRepository.can(this, root, "ReadChildren", true)) {
            throw new AccessDeniedException("Not allowed to read: " + this.getName() + "@" + version);
        }
        return root.getDescriptor(this.getName() + ":", "", null, -1);
    }

    @Override
    public Lookup lookupDirectory(int version, String path, boolean write) {
        Lookup lPath = this.lookup(version, path, write, false);
        if (lPath == null) {
            return null;
        }
        if (lPath.getCurrentNode().getType() != 2 && lPath.getCurrentNode().getType() != 3) {
            return null;
        }
        return lPath;
    }

    @Override
    public String getIndirectionPath(int version, String path) {
        Lookup lPath = this.lookup(version, path, false, false);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + path + " not found.");
        }
        if (!lPath.isLayered()) {
            return null;
        }
        AVMNode node = lPath.getCurrentNode();
        if (!this.fAVMRepository.can(this, node, "ReadProperties", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to read: " + path);
        }
        if (node.getType() == 3) {
            LayeredDirectoryNode dir = (LayeredDirectoryNode)node;
            return dir.getUnderlying(lPath);
        }
        if (node.getType() == 1) {
            LayeredFileNode file = (LayeredFileNode)node;
            return file.getUnderlying(lPath);
        }
        return lPath.getIndirectionPath();
    }

    @Override
    public void makePrimary(String path) {
        Lookup lPath = this.lookupDirectory(-1, path, true);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + path + " not found.");
        }
        DirectoryNode dir = (DirectoryNode)lPath.getCurrentNode();
        if (!lPath.isLayered()) {
            throw new AVMException("Not in a layered context: " + path);
        }
        if (!this.fAVMRepository.can(this, dir, "WriteProperties", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to write: " + path);
        }
        dir.turnPrimary(lPath);
        dir.updateModTime();
        AVMDAOs.Instance().fAVMNodeDAO.update(dir);
    }

    @Override
    public void retargetLayeredDirectory(String path, String target) {
        Lookup lPath = this.lookupDirectory(-1, path, true);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + path + " not found.");
        }
        DirectoryNode dir = (DirectoryNode)lPath.getCurrentNode();
        if (!lPath.isLayered()) {
            throw new AVMException("Not in a layered context: " + path);
        }
        if (!this.fAVMRepository.can(this, dir, "WriteProperties", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to write: " + path);
        }
        dir.retarget(lPath, target);
        dir.updateModTime();
        AVMDAOs.Instance().fAVMNodeDAO.update(dir);
    }

    @Override
    public void setName(String name) {
        this.fName = name;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public Acl getStoreAcl() {
        return this.fACL;
    }

    @Override
    public void setStoreAcl(Acl acl) {
        this.fACL = acl;
    }

    public void setNextVersionID(int nextVersionID) {
        this.fNextVersionID = nextVersionID;
    }

    @Override
    public int getNextVersionID() {
        return this.fNextVersionID;
    }

    @Override
    public int getLastVersionID() {
        Integer lastVersionId = AVMDAOs.Instance().fVersionRootDAO.getMaxVersionID(this);
        if (lastVersionId == null) {
            return 0;
        }
        return lastVersionId;
    }

    public void setRoot(DirectoryNode root) {
        this.fRoot = root;
    }

    @Override
    public DirectoryNode getRoot() {
        return this.fRoot;
    }

    public void setVers(long vers) {
        this.fVers = vers;
    }

    public long getVers() {
        return this.fVers;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AVMStore)) {
            return false;
        }
        return this.getId() == ((AVMStore)obj).getId();
    }

    public int hashCode() {
        return (int)this.getId();
    }

    @Override
    public void purgeVersion(int version) {
        if (version == 0) {
            throw new AVMBadArgumentException("Cannot purge initial version");
        }
        VersionRoot vRoot = AVMDAOs.Instance().fVersionRootDAO.getByVersionID(this, version);
        if (vRoot == null) {
            throw new AVMNotFoundException("Version not found.");
        }
        AVMDAOs.Instance().fVersionLayeredNodeEntryDAO.delete(vRoot);
        DirectoryNode root = vRoot.getRoot();
        if (!this.fAVMRepository.can(null, root, "DeleteChildren", true)) {
            throw new AccessDeniedException("Not allowed to purge: " + this.getName() + "@" + version);
        }
        root.setIsRoot(false);
        AVMDAOs.Instance().fAVMNodeDAO.update(root);
        AVMDAOs.Instance().fVersionRootDAO.delete(vRoot);
        if (root.equals(this.getRoot())) {
            vRoot = AVMDAOs.Instance().fVersionRootDAO.getMaxVersion(this);
            this.setRoot(vRoot.getRoot());
            AVMDAOs.Instance().fAVMStoreDAO.update(this);
        }
    }

    @Override
    public AVMStoreDescriptor getDescriptor() {
        PropertyValue creatorValue = this.getProperty(ContentModel.PROP_CREATOR);
        String creator = creatorValue == null ? "System" : (String)((Object)creatorValue.getValue(DataTypeDefinition.TEXT));
        creator = creator == null ? "System" : creator;
        PropertyValue createdValue = this.getProperty(ContentModel.PROP_CREATED);
        Date created = createdValue == null ? new Date() : (Date)createdValue.getValue(DataTypeDefinition.DATE);
        created = created == null ? new Date() : created;
        return new AVMStoreDescriptor(this.getId(), this.getName(), creator, created.getTime());
    }

    @Override
    public void setOpacity(String path, boolean opacity) {
        Lookup lPath = this.lookup(-1, path, true, false);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + path + " not found.");
        }
        AVMNode node = lPath.getCurrentNode();
        if (!(node instanceof LayeredDirectoryNode)) {
            throw new AVMWrongTypeException("Not a LayeredDirectoryNode.");
        }
        if (!this.fAVMRepository.can(this, node, "WriteProperties", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to write: " + path);
        }
        ((LayeredDirectoryNode)node).setOpacity(opacity);
        node.updateModTime();
        AVMDAOs.Instance().fAVMNodeDAO.update(node);
    }

    @Override
    public void setNodeProperty(String path, QName name, PropertyValue value) {
        Lookup lPath = this.lookup(-1, path, true, true);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + path + " not found.");
        }
        AVMNode node = lPath.getCurrentNode();
        if (!this.fAVMRepository.can(this, node, "WriteProperties", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to write: " + path);
        }
        node.setProperty(name, value);
        node.setGuid(GUID.generate());
        AVMDAOs.Instance().fAVMNodeDAO.update(node);
    }

    @Override
    public void setNodeProperties(String path, Map<QName, PropertyValue> properties) {
        Lookup lPath = this.lookup(-1, path, true, true);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + path + " not found.");
        }
        AVMNode node = lPath.getCurrentNode();
        if (!this.fAVMRepository.can(this, node, "WriteProperties", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to write: " + path);
        }
        if (properties != null) {
            HashMap<QName, PropertyValue> props = new HashMap<QName, PropertyValue>(properties.size());
            props.putAll(properties);
            node.addProperties(props);
        }
        node.setGuid(GUID.generate());
        AVMDAOs.Instance().fAVMNodeDAO.update(node);
    }

    @Override
    public PropertyValue getNodeProperty(int version, String path, QName name) {
        Lookup lPath = this.lookup(version, path, false, true);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + path + " not found.");
        }
        AVMNode node = lPath.getCurrentNode();
        if (!this.fAVMRepository.can(this, node, "ReadProperties", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to read: " + path);
        }
        return node.getProperty(name);
    }

    @Override
    public Map<QName, PropertyValue> getNodeProperties(int version, String path) {
        Lookup lPath = this.lookup(version, path, false, true);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + path + " not found.");
        }
        AVMNode node = lPath.getCurrentNode();
        if (!this.fAVMRepository.can(this, node, "ReadProperties", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to read: " + path);
        }
        return node.getProperties();
    }

    @Override
    public void deleteNodeProperty(String path, QName name) {
        Lookup lPath = this.lookup(-1, path, true, true);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + path + " not found.");
        }
        AVMNode node = lPath.getCurrentNode();
        if (!this.fAVMRepository.can(this, node, "WriteProperties", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to write: " + path);
        }
        node.setGuid(GUID.generate());
        node.deleteProperty(name);
        AVMDAOs.Instance().fAVMNodeDAO.update(node);
    }

    @Override
    public void deleteNodeProperties(String path) {
        Lookup lPath = this.lookup(-1, path, true, true);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + path + " not found.");
        }
        AVMNode node = lPath.getCurrentNode();
        if (!this.fAVMRepository.can(this, node, "WriteProperties", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to write: " + path);
        }
        node.setGuid(GUID.generate());
        node.deleteProperties();
        AVMDAOs.Instance().fAVMNodeDAO.update(node);
    }

    @Override
    public void setProperty(QName name, PropertyValue value) {
        AVMStorePropertyImpl prop = new AVMStorePropertyImpl();
        prop.setStore(this);
        prop.setQname(name);
        prop.setValue(value);
        AVMDAOs.Instance().fAVMStorePropertyDAO.save(prop);
    }

    @Override
    public void setProperties(Map<QName, PropertyValue> properties) {
        for (QName name : properties.keySet()) {
            this.setProperty(name, properties.get(name));
        }
    }

    @Override
    public PropertyValue getProperty(QName name) {
        return AVMDAOs.Instance().fAVMStorePropertyDAO.get(this, name);
    }

    @Override
    public Map<QName, PropertyValue> getProperties() {
        return AVMDAOs.Instance().fAVMStorePropertyDAO.get(this);
    }

    @Override
    public void deleteProperty(QName name) {
        AVMDAOs.Instance().fAVMStorePropertyDAO.delete(this, name);
    }

    @Override
    public ContentData getContentDataForRead(int version, String path) {
        Lookup lPath = this.lookup(version, path, false, false);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + path + " not found.");
        }
        AVMNode node = lPath.getCurrentNode();
        if (!(node instanceof FileNode)) {
            throw new AVMWrongTypeException("File Expected.");
        }
        if (!this.fAVMRepository.can(this, node, "ReadContent", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to read: " + path);
        }
        ContentData content = ((FileNode)node).getContentData(lPath);
        return content;
    }

    @Override
    public ContentData getContentDataForWrite(String path) {
        Lookup lPath = this.lookup(-1, path, true, false);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + path + " not found.");
        }
        AVMNode node = lPath.getCurrentNode();
        if (!(node instanceof FileNode)) {
            throw new AVMWrongTypeException("File Expected.");
        }
        if (!this.fAVMRepository.can(this, node, "WriteContent", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to write content: " + path);
        }
        node.updateModTime();
        node.setGuid(GUID.generate());
        AVMDAOs.Instance().fAVMNodeDAO.updateModTimeAndGuid(node);
        ContentData content = ((FileNode)node).getContentData(lPath);
        return content;
    }

    @Override
    public void setContentData(String path, ContentData data) {
        Lookup lPath = this.lookup(-1, path, true, false);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + path + " not found.");
        }
        AVMNode node = lPath.getCurrentNode();
        if (!(node instanceof FileNode)) {
            throw new AVMWrongTypeException("File Expected.");
        }
        ((FileNode)node).setContentData(data);
        node.updateModTime();
        AVMDAOs.Instance().fAVMNodeDAO.update(node);
    }

    @Override
    public void setMetaDataFrom(String path, AVMNode from) {
        Lookup lPath = this.lookup(-1, path, true, true);
        if (lPath == null) {
            throw new AVMNotFoundException("Path not found: " + path);
        }
        AVMNode node = lPath.getCurrentNode();
        if (!this.fAVMRepository.can(this, node, "WriteProperties", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to write properties: " + path);
        }
        node.copyMetaDataFrom(from, node.getAcl() == null ? null : node.getAcl().getInheritsFrom());
        node.setGuid(GUID.generate());
        AVMDAOs.Instance().fAVMNodeDAO.update(node);
    }

    @Override
    public void addAspect(String path, QName aspectName) {
        Lookup lPath = this.lookup(-1, path, true, true);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + path + " not found.");
        }
        AVMNode node = lPath.getCurrentNode();
        if (!this.fAVMRepository.can(this, node, "WriteProperties", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to write: " + path);
        }
        node.addAspect(aspectName);
        node.setGuid(GUID.generate());
        AVMDAOs.Instance().fAVMNodeDAO.update(node);
    }

    @Override
    public Set<QName> getAspects(int version, String path) {
        Lookup lPath = this.lookup(version, path, false, true);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + path + " not found.");
        }
        AVMNode node = lPath.getCurrentNode();
        if (!this.fAVMRepository.can(this, node, "ReadProperties", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to read properties: " + path);
        }
        return node.getAspects();
    }

    @Override
    public void removeAspect(String path, QName aspectName) {
        Lookup lPath = this.lookup(-1, path, true, true);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + path + " not found.");
        }
        AVMNode node = lPath.getCurrentNode();
        if (!this.fAVMRepository.can(this, node, "WriteProperties", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to write properties: " + path);
        }
        node.removeAspect(aspectName);
        AspectDefinition def = RawServices.Instance().getDictionaryService().getAspect(aspectName);
        Map properties = def.getProperties();
        for (QName propertyQName : properties.keySet()) {
            node.deleteProperty(propertyQName);
        }
        node.setGuid(GUID.generate());
        AVMDAOs.Instance().fAVMNodeDAO.update(node);
    }

    @Override
    public boolean hasAspect(int version, String path, QName aspectName) {
        Lookup lPath = this.lookup(version, path, false, true);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + path + " not found.");
        }
        AVMNode node = lPath.getCurrentNode();
        if (!this.fAVMRepository.can(this, node, "ReadProperties", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to read properties: " + path);
        }
        return node.getAspects().contains(aspectName);
    }

    @Override
    public void setACL(String path, Acl acl) {
        Lookup lPath = this.lookup(-1, path, true, true);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + path + " not found.");
        }
        AVMNode node = lPath.getCurrentNode();
        if (!this.fAVMRepository.can(this, node, "ChangePermissions", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to change permissions: " + path);
        }
        node.setAcl(acl);
        node.setGuid(GUID.generate());
        AVMDAOs.Instance().fAVMNodeDAO.update(node);
    }

    @Override
    public Acl getACL(int version, String path) {
        Lookup lPath = this.lookup(version, path, false, false);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + path + " not found.");
        }
        if (!this.fAVMRepository.can(this, lPath.getCurrentNode(), "ReadPermissions", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to read permissions: " + path + " in " + this.getName());
        }
        return lPath.getCurrentNode().getAcl();
    }

    @Override
    public void link(String parentPath, String name, AVMNodeDescriptor toLink) {
        Lookup lPath = this.lookupDirectory(-1, parentPath, true);
        if (lPath == null) {
            DirectoryNode parent;
            Pair<AVMNode, Boolean> temp;
            String[] pathParts = AVMUtil.splitBase(parentPath);
            Lookup lPath2 = this.lookup(-1, pathParts[0], true, false);
            if (lPath2 != null && (temp = (parent = (DirectoryNode)lPath2.getCurrentNode()).lookupChild(lPath2, pathParts[1], false)) != null && temp.getFirst() != null) {
                boolean directlyContained;
                DirectoryNode dir = (DirectoryNode)temp.getFirst();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found: " + dir));
                }
                if (!this.fAVMRepository.can(null, dir, "AddChildren", directlyContained = false)) {
                    throw new AccessDeniedException("Not allowed to add children: " + parentPath);
                }
                AVMNodeDescriptor desc = this.fAVMRepository.forceCopy(AVMUtil.buildAVMPath(this.getName(), parentPath));
                this.fAVMRepository.link(desc, name, toLink);
                return;
            }
            throw new AVMNotFoundException("Path " + parentPath + " not found.");
        }
        DirectoryNode dir = (DirectoryNode)lPath.getCurrentNode();
        if (!this.fAVMRepository.can(null, dir, "AddChildren", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to add children: " + parentPath);
        }
        dir.link(lPath, name, toLink);
    }

    @Override
    public void updateLink(String parentPath, String name, AVMNodeDescriptor toLink) {
        Lookup cPath;
        Lookup lPath = this.lookupDirectory(-1, parentPath, true);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + parentPath + " not found.");
        }
        DirectoryNode dir = (DirectoryNode)lPath.getCurrentNode();
        Pair<AVMNode, Boolean> result = dir.lookupChild(cPath = new Lookup(lPath, AVMDAOs.Instance().fAVMNodeDAO, AVMDAOs.Instance().fAVMStoreDAO), name, true);
        if (result != null) {
            AVMNode child = (AVMNode)result.getFirst();
            if (!this.fAVMRepository.can(null, child, "Write", cPath.getDirectlyContained())) {
                throw new AccessDeniedException("Not allowed to update node: " + parentPath + "/" + name);
            }
            dir.removeChild(lPath, name);
        }
        dir.link(lPath, name, toLink);
    }

    @Override
    public void revert(String path, String name, AVMNodeDescriptor toRevertTo) {
        AVMNode child;
        Lookup lPath = this.lookupDirectory(-1, path, true);
        if (lPath == null) {
            throw new AVMNotFoundException("Path " + path + " not found.");
        }
        DirectoryNode dir = (DirectoryNode)lPath.getCurrentNode();
        Pair<AVMNode, Boolean> temp = dir.lookupChild(lPath, name, true);
        AVMNode aVMNode = child = temp == null ? null : (AVMNode)temp.getFirst();
        if (child == null) {
            throw new AVMNotFoundException("Node not found: " + name);
        }
        if (!this.fAVMRepository.can(null, child, "Write", false)) {
            throw new AccessDeniedException("Not allowed to revert: " + path);
        }
        AVMNode revertNode = AVMDAOs.Instance().fAVMNodeDAO.getByID(toRevertTo.getId());
        if (revertNode == null) {
            throw new AVMNotFoundException(toRevertTo.toString());
        }
        AVMNode toLink = revertNode.copy(lPath);
        dir.putChild(name, toLink);
        toLink.changeAncestor(child);
        toLink.setVersionID(child.getVersionID() + 1);
        toLink.addAspect(WCMModel.ASPECT_REVERTED);
        PropertyValue value = new PropertyValue(null, Long.valueOf(toRevertTo.getId()));
        toLink.setProperty(WCMModel.PROP_REVERTED_ID, value);
        AVMDAOs.Instance().fAVMNodeDAO.update(toLink);
    }

    @Override
    public void setGuid(String path, String guid) {
        Lookup lPath = this.lookup(-1, path, true, true);
        if (lPath == null) {
            throw new AVMNotFoundException("Path not found: " + path);
        }
        AVMNode node = lPath.getCurrentNode();
        if (!this.fAVMRepository.can(this, node, "WriteProperties", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to write properties: " + path);
        }
        node.setGuid(guid);
        AVMDAOs.Instance().fAVMNodeDAO.update(node);
    }

    @Override
    public void setEncoding(String path, String encoding) {
        Lookup lPath = this.lookup(-1, path, true, false);
        if (lPath == null) {
            throw new AVMNotFoundException("Path not found: " + path);
        }
        AVMNode node = lPath.getCurrentNode();
        if (node.getType() != 0) {
            throw new AVMWrongTypeException("Not a File: " + path);
        }
        if (!this.fAVMRepository.can(this, node, "WriteProperties", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to write properties: " + path);
        }
        PlainFileNode file = (PlainFileNode)node;
        ContentData contentData = file.getContentData();
        contentData = ContentData.setEncoding((ContentData)contentData, (String)encoding);
        file.setContentData(contentData);
        AVMDAOs.Instance().fAVMNodeDAO.update(file);
    }

    @Override
    public void setMimeType(String path, String mimeType) {
        Lookup lPath = this.lookup(-1, path, true, false);
        if (lPath == null) {
            throw new AVMNotFoundException("Path not found: " + path);
        }
        AVMNode node = lPath.getCurrentNode();
        if (node.getType() != 0) {
            throw new AVMWrongTypeException("Not a File: " + path);
        }
        if (!this.fAVMRepository.can(this, node, "WriteProperties", lPath.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to write properties: " + path);
        }
        PlainFileNode file = (PlainFileNode)node;
        ContentData contentData = file.getContentData();
        contentData = ContentData.setMimetype((ContentData)contentData, (String)mimeType);
        file.setContentData(contentData);
        AVMDAOs.Instance().fAVMNodeDAO.update(file);
    }

    public String toString() {
        return this.getName();
    }
}

