/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.avm.AVMBadArgumentException;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.avm.LayeringDescriptor;
import org.alfresco.service.cmr.avm.VersionDescriptor;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiTAVMService
implements AVMService {
    private AVMService fService;
    private TenantService tenantService;
    Boolean enabled = null;

    public void setAvmService(AVMService fService) {
        this.fService = fService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    @Override
    public void addAspect(String path, QName aspectName) {
        this.fService.addAspect(this.getTenantPath(path), aspectName);
    }

    @Override
    public void copy(int srcVersion, String srcPath, String dstPath, String name) {
        this.fService.copy(srcVersion, this.getTenantPath(srcPath), this.getTenantPath(dstPath), name);
    }

    @Override
    public void createBranch(int version, String srcPath, String dstPath, String name) {
        this.fService.createBranch(version, this.getTenantPath(srcPath), this.getTenantPath(dstPath), name);
    }

    @Override
    public void createDirectory(String path, String name) {
        this.fService.createDirectory(this.getTenantPath(path), name);
    }

    @Override
    public OutputStream createFile(String path, String name) {
        return this.fService.createFile(this.getTenantPath(path), name);
    }

    @Override
    public void createFile(String path, String name, InputStream in) {
        this.fService.createFile(this.getTenantPath(path), name, in);
    }

    @Override
    public void createLayeredDirectory(String targetPath, String parentPath, String name) {
        this.fService.createLayeredDirectory(this.getTenantPath(targetPath), this.getTenantPath(parentPath), name);
    }

    @Override
    public void createLayeredFile(String targetPath, String parentPath, String name) {
        this.fService.createLayeredFile(this.getTenantPath(targetPath), this.getTenantPath(parentPath), name);
    }

    @Override
    public Map<String, Integer> createSnapshot(String storeName, String tag, String description) {
        return this.fService.createSnapshot(this.getTenantStoreName(storeName), tag, description);
    }

    @Override
    public void createStore(String storeName) {
        this.fService.createStore(this.getTenantStoreName(storeName));
    }

    @Override
    public void createStore(String name, Map<QName, PropertyValue> props) {
        this.fService.createStore(name, props);
    }

    @Override
    public void deleteNodeProperties(String path) {
        this.fService.deleteNodeProperties(this.getTenantPath(path));
    }

    @Override
    public void deleteNodeProperty(String path, QName name) {
        this.fService.deleteNodeProperty(this.getTenantPath(path), name);
    }

    @Override
    public void deleteStoreProperty(String storeName, QName name) {
        this.fService.deleteStoreProperty(this.getTenantStoreName(storeName), name);
    }

    @Override
    public void updateLink(String parentPath, String name, AVMNodeDescriptor toLink) {
        this.fService.updateLink(this.getTenantPath(parentPath), name, toLink);
    }

    @Override
    public AVMNodeDescriptor forceCopy(String path) {
        return this.getBaseNode(this.fService.forceCopy(this.getTenantPath(path)));
    }

    @Override
    public Pair<Integer, String> getAPath(AVMNodeDescriptor desc) {
        return this.getBaseVPath(this.fService.getAPath(this.getTenantNode(desc)));
    }

    @Override
    public List<String> getPathsInStoreVersion(AVMNodeDescriptor desc, String storeName, int version) {
        return this.getBasePaths(this.fService.getPathsInStoreVersion(this.getTenantNode(desc), this.getTenantStoreName(storeName), version));
    }

    @Override
    public Set<QName> getAspects(int version, String path) {
        return this.fService.getAspects(version, this.getTenantPath(path));
    }

    @Override
    public Set<QName> getAspects(AVMNodeDescriptor desc) {
        return this.fService.getAspects(this.getTenantNode(desc));
    }

    @Override
    public AVMNodeDescriptor getCommonAncestor(AVMNodeDescriptor left, AVMNodeDescriptor right) {
        return this.getBaseNode(this.fService.getCommonAncestor(this.getTenantNode(left), this.getTenantNode(right)));
    }

    @Override
    public ContentData getContentDataForRead(int version, String path) {
        return this.fService.getContentDataForRead(version, this.getTenantPath(path));
    }

    @Override
    public ContentData getContentDataForRead(AVMNodeDescriptor desc) {
        return this.fService.getContentDataForRead(this.getTenantNode(desc));
    }

    @Override
    public ContentData getContentDataForWrite(String path) {
        return this.fService.getContentDataForWrite(this.getTenantPath(path));
    }

    @Override
    public ContentReader getContentReader(int version, String path) {
        return this.fService.getContentReader(version, this.getTenantPath(path));
    }

    @Override
    public ContentWriter getContentWriter(String path, boolean update) {
        return this.fService.getContentWriter(this.getTenantPath(path), update);
    }

    @Override
    public List<String> getDeleted(int version, String path) {
        return this.fService.getDeleted(version, this.getTenantPath(path));
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListing(int version, String path) {
        return this.getBaseNodes(this.fService.getDirectoryListing(version, this.getTenantPath(path)));
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListing(int version, String path, boolean includeDeleted) {
        return this.getBaseNodes(this.fService.getDirectoryListing(version, this.getTenantPath(path), includeDeleted));
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListing(AVMNodeDescriptor dir) {
        return this.getBaseNodes(this.fService.getDirectoryListing(this.getTenantNode(dir)));
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListing(AVMNodeDescriptor dir, boolean includeDeleted) {
        return this.getBaseNodes(this.fService.getDirectoryListing(this.getTenantNode(dir), includeDeleted));
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListing(AVMNodeDescriptor dir, String childNamePattern) {
        return this.getBaseNodes(this.fService.getDirectoryListing(this.getTenantNode(dir), childNamePattern));
    }

    @Override
    public AVMNodeDescriptor[] getDirectoryListingArray(int version, String path, boolean includeDeleted) {
        return this.getBaseNodes(this.fService.getDirectoryListingArray(version, this.getTenantPath(path), includeDeleted));
    }

    @Override
    public AVMNodeDescriptor[] getDirectoryListingArray(AVMNodeDescriptor dir, boolean includeDeleted) {
        return this.getBaseNodes(this.fService.getDirectoryListingArray(this.getTenantNode(dir), includeDeleted));
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListingDirect(int version, String path) {
        return this.getBaseNodes(this.fService.getDirectoryListingDirect(version, this.getTenantPath(path)));
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListingDirect(int version, String path, boolean includeDeleted) {
        return this.getBaseNodes(this.fService.getDirectoryListingDirect(version, this.getTenantPath(path), includeDeleted));
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getDirectoryListingDirect(AVMNodeDescriptor dir, boolean includeDeleted) {
        return this.getBaseNodes(this.fService.getDirectoryListingDirect(this.getTenantNode(dir), includeDeleted));
    }

    @Override
    public InputStream getFileInputStream(int version, String path) {
        return this.fService.getFileInputStream(version, this.getTenantPath(path));
    }

    @Override
    public InputStream getFileInputStream(AVMNodeDescriptor desc) {
        return this.fService.getFileInputStream(this.getTenantNode(desc));
    }

    @Override
    public OutputStream getFileOutputStream(String path) {
        return this.fService.getFileOutputStream(this.getTenantPath(path));
    }

    @Override
    public List<Pair<Integer, String>> getHeadPaths(AVMNodeDescriptor desc) {
        return this.fService.getHeadPaths(this.getTenantNode(desc));
    }

    @Override
    public List<AVMNodeDescriptor> getHistory(AVMNodeDescriptor desc, int count) {
        return this.getBaseNodes(this.fService.getHistory(this.getTenantNode(desc), count));
    }

    @Override
    public String getIndirectionPath(int version, String path) {
        return this.getBasePath(this.fService.getIndirectionPath(version, this.getTenantPath(path)));
    }

    @Override
    public int getLatestSnapshotID(String storeName) {
        return this.fService.getLatestSnapshotID(this.getTenantStoreName(storeName));
    }

    @Override
    public LayeringDescriptor getLayeringInfo(int version, String path) {
        return this.fService.getLayeringInfo(version, this.getTenantPath(path));
    }

    @Override
    public int getNextVersionID(String storeName) {
        return this.fService.getNextVersionID(storeName);
    }

    @Override
    public Map<QName, PropertyValue> getNodeProperties(int version, String path) {
        return this.fService.getNodeProperties(version, this.getTenantPath(path));
    }

    @Override
    public Map<QName, PropertyValue> getNodeProperties(AVMNodeDescriptor desc) {
        return this.fService.getNodeProperties(this.getTenantNode(desc));
    }

    @Override
    public PropertyValue getNodeProperty(int version, String path, QName name) {
        return this.fService.getNodeProperty(version, this.getTenantPath(path), name);
    }

    @Override
    public List<Pair<Integer, String>> getPaths(AVMNodeDescriptor desc) {
        return this.getBaseVPaths(this.fService.getPaths(this.getTenantNode(desc)));
    }

    @Override
    public List<Pair<Integer, String>> getPathsInStoreHead(AVMNodeDescriptor desc, String storeName) {
        return this.getBaseVPaths(this.fService.getPathsInStoreHead(this.getTenantNode(desc), this.getTenantStoreName(storeName)));
    }

    @Override
    public AVMStoreDescriptor getStore(String storeName) {
        return this.getBaseStore(this.fService.getStore(this.getTenantStoreName(storeName)));
    }

    @Override
    public Map<QName, PropertyValue> getStoreProperties(String storeName) {
        return this.fService.getStoreProperties(this.getTenantStoreName(storeName));
    }

    @Override
    public PropertyValue getStoreProperty(String storeName, QName name) {
        return this.fService.getStoreProperty(this.getTenantStoreName(storeName), name);
    }

    @Override
    public AVMNodeDescriptor getStoreRoot(int version, String storeName) {
        return this.getBaseNode(this.fService.getStoreRoot(version, this.getTenantStoreName(storeName)));
    }

    @Override
    public List<VersionDescriptor> getStoreVersions(String storeName) {
        return this.fService.getStoreVersions(this.getTenantStoreName(storeName));
    }

    @Override
    public List<VersionDescriptor> getStoreVersions(String storeName, Date from, Date to) {
        return this.fService.getStoreVersions(this.getTenantStoreName(storeName), from, to);
    }

    @Override
    public List<AVMStoreDescriptor> getStores() {
        List<AVMStoreDescriptor> allAvmStores = this.fService.getStores();
        if (this.isTenantServiceEnabled()) {
            ArrayList<AVMStoreDescriptor> convertedValues = new ArrayList<AVMStoreDescriptor>();
            for (AVMStoreDescriptor store : allAvmStores) {
                try {
                    String runAsUser = AuthenticationUtil.getRunAsUser();
                    if (!EqualsHelper.nullSafeEquals((Object)runAsUser, (Object)"System")) {
                        this.tenantService.checkDomain(store.getName());
                        store = this.getBaseStore(store);
                    }
                    convertedValues.add(store);
                }
                catch (RuntimeException re) {}
            }
            return convertedValues;
        }
        return allAvmStores;
    }

    @Override
    public AVMStoreDescriptor getSystemStore() {
        return this.getBaseStore(this.fService.getSystemStore());
    }

    @Override
    public boolean hasAspect(int version, String path, QName aspectName) {
        return this.fService.hasAspect(version, this.getTenantPath(path), aspectName);
    }

    @Override
    public void link(String parentPath, String name, AVMNodeDescriptor toLink) {
        this.fService.link(this.getTenantPath(parentPath), name, this.getTenantNode(toLink));
    }

    @Override
    public AVMNodeDescriptor lookup(int version, String path) {
        return this.getBaseNode(this.fService.lookup(version, this.getTenantPath(path)));
    }

    @Override
    public AVMNodeDescriptor lookup(int version, String path, boolean includeDeleted) {
        return this.getBaseNode(this.fService.lookup(version, this.getTenantPath(path), includeDeleted));
    }

    @Override
    public AVMNodeDescriptor lookup(AVMNodeDescriptor dir, String name) {
        return this.getBaseNode(this.fService.lookup(this.getTenantNode(dir), name));
    }

    @Override
    public AVMNodeDescriptor lookup(AVMNodeDescriptor dir, String name, boolean includeDeleted) {
        return this.getBaseNode(this.fService.lookup(this.getTenantNode(dir), name, includeDeleted));
    }

    @Override
    public void makePrimary(String path) {
        this.fService.makePrimary(this.getTenantPath(path));
    }

    @Override
    public void makeTransparent(String dirPath, String name) {
        this.fService.makeTransparent(this.getTenantPath(dirPath), name);
    }

    @Override
    public void purgeStore(String storeName) {
        this.fService.purgeStore(this.getTenantStoreName(storeName));
    }

    @Override
    public void purgeVersion(int version, String storeName) {
        this.fService.purgeVersion(version, this.getTenantStoreName(storeName));
    }

    @Override
    public Map<QName, PropertyValue> queryStorePropertyKey(String storeName, QName keyPattern) {
        return this.fService.queryStorePropertyKey(this.getTenantStoreName(storeName), keyPattern);
    }

    @Override
    public Map<String, Map<QName, PropertyValue>> queryStoresPropertyKeys(QName keyPattern) {
        return this.fService.queryStoresPropertyKeys(keyPattern);
    }

    @Override
    public void removeAspect(String path, QName aspectName) {
        this.fService.removeAspect(this.getTenantPath(path), aspectName);
    }

    @Override
    public void removeNode(String parent, String name) {
        this.fService.removeNode(this.getTenantPath(parent), name);
    }

    @Override
    public void removeNode(String path) {
        this.fService.removeNode(this.getTenantPath(path));
    }

    @Override
    public void rename(String srcParent, String srcName, String dstParent, String dstName) {
        this.fService.rename(this.getTenantPath(srcParent), srcName, this.getTenantPath(dstParent), dstName);
    }

    @Override
    public void renameStore(String sourceStoreName, String destStoreName) {
        this.fService.renameStore(this.getTenantStoreName(sourceStoreName), this.getTenantStoreName(destStoreName));
    }

    @Override
    public void retargetLayeredDirectory(String path, String target) {
        this.fService.retargetLayeredDirectory(this.getTenantPath(path), target);
    }

    @Override
    public void revert(String path, AVMNodeDescriptor toRevertTo) {
        this.fService.revert(this.getTenantPath(path), this.getTenantNode(toRevertTo));
    }

    @Override
    public void setContentData(String path, ContentData data) {
        this.fService.setContentData(this.getTenantPath(path), data);
    }

    @Override
    public void setEncoding(String path, String encoding) {
        this.fService.setEncoding(this.getTenantPath(path), encoding);
    }

    @Override
    public void setGuid(String path, String guid) {
        this.fService.setGuid(this.getTenantPath(path), guid);
    }

    @Override
    public void setMetaDataFrom(String path, AVMNodeDescriptor from) {
        this.fService.setMetaDataFrom(this.getTenantPath(path), this.getTenantNode(from));
    }

    @Override
    public void setMimeType(String path, String mimeType) {
        this.fService.setMimeType(this.getTenantPath(path), mimeType);
    }

    @Override
    public void setNodeProperties(String path, Map<QName, PropertyValue> properties) {
        this.fService.setNodeProperties(this.getTenantPath(path), properties);
    }

    @Override
    public void setNodeProperty(String path, QName name, PropertyValue value) {
        this.fService.setNodeProperty(this.getTenantPath(path), name, value);
    }

    @Override
    public void setOpacity(String path, boolean opacity) {
        this.fService.setOpacity(this.getTenantPath(path), opacity);
    }

    @Override
    public void setStoreProperties(String storeName, Map<QName, PropertyValue> props) {
        this.fService.setStoreProperties(this.getTenantStoreName(storeName), props);
    }

    @Override
    public void setStoreProperty(String storeName, QName name, PropertyValue value) {
        this.fService.setStoreProperty(this.getTenantStoreName(storeName), name, value);
    }

    @Override
    public void uncover(String dirPath, String name) {
        this.fService.uncover(this.getTenantPath(dirPath), name);
    }

    @Override
    public void createDirectory(String path, String name, List<QName> aspects, Map<QName, PropertyValue> properties) {
        this.fService.createDirectory(this.getTenantPath(path), name, aspects, properties);
    }

    @Override
    public void createFile(String path, String name, InputStream in, List<QName> aspects, Map<QName, PropertyValue> properties) {
        this.fService.createFile(this.getTenantPath(path), name, in, aspects, properties);
    }

    @Override
    public List<VersionDescriptor> getStoreVersionsTo(String name, int version) {
        return this.fService.getStoreVersionsTo(name, version);
    }

    @Override
    public List<VersionDescriptor> getStoreVersionsFrom(String name, int version) {
        return this.fService.getStoreVersionsFrom(name, version);
    }

    @Override
    public List<VersionDescriptor> getStoreVersionsBetween(String name, int from, int to) {
        return this.fService.getStoreVersionsBetween(name, from, to);
    }

    private String getTenantStoreName(String avmStoreName) {
        if (avmStoreName == null || !this.isTenantServiceEnabled()) {
            return avmStoreName;
        }
        return this.tenantService.getName(avmStoreName);
    }

    private String getBaseStoreName(String avmStoreName) {
        if (avmStoreName == null || !this.isTenantServiceEnabled()) {
            return avmStoreName;
        }
        return this.tenantService.getBaseName(avmStoreName);
    }

    private String getTenantPath(String avmPath) {
        if (avmPath == null || !this.isTenantServiceEnabled() || avmPath.equals("UNKNOWN/UNKNOWN")) {
            return avmPath;
        }
        String[] storePath = this.splitPath(avmPath);
        return this.tenantService.getName(storePath[0]) + ':' + storePath[1];
    }

    private String getBasePath(String avmPath) {
        if (avmPath == null || !this.isTenantServiceEnabled() || avmPath.equals("/") || avmPath.equals("UNKNOWN/UNKNOWN")) {
            return avmPath;
        }
        String[] storePath = this.splitPath(avmPath);
        return this.tenantService.getBaseName(storePath[0]) + ':' + storePath[1];
    }

    private Pair<Integer, String> getBaseVPath(Pair<Integer, String> p) {
        if (p == null || !this.isTenantServiceEnabled()) {
            return p;
        }
        return new Pair(p.getFirst(), (Object)this.getBasePath((String)p.getSecond()));
    }

    private List<Pair<Integer, String>> getBaseVPaths(List<Pair<Integer, String>> paths) {
        if (paths == null || !this.isTenantServiceEnabled()) {
            return paths;
        }
        ArrayList<Pair<Integer, String>> convertedPaths = new ArrayList<Pair<Integer, String>>(paths.size());
        for (Pair<Integer, String> path : paths) {
            convertedPaths.add(this.getBaseVPath(path));
        }
        return convertedPaths;
    }

    private List<String> getBasePaths(List<String> paths) {
        if (paths == null || !this.isTenantServiceEnabled()) {
            return paths;
        }
        ArrayList<String> convertedPaths = new ArrayList<String>(paths.size());
        for (String path : paths) {
            convertedPaths.add(this.getBasePath(path));
        }
        return convertedPaths;
    }

    private String[] splitPath(String path) {
        String[] storePath = path.split(":");
        if (storePath.length != 2) {
            throw new AVMBadArgumentException("Invalid Path: " + path);
        }
        return storePath;
    }

    private AVMNodeDescriptor getTenantNode(AVMNodeDescriptor node) {
        if (node == null || !this.isTenantServiceEnabled()) {
            return node;
        }
        return new AVMNodeDescriptor(this.getTenantPath(node.getPath()), node.getName(), node.getType(), node.getCreator(), node.getOwner(), node.getLastModifier(), node.getCreateDate(), node.getModDate(), node.getAccessDate(), node.getId(), node.getGuid(), node.getVersionID(), node.getIndirection(), node.getIndirectionVersion(), node.isPrimary(), node.getLayerID(), node.getOpacity(), node.getLength(), node.getDeletedType());
    }

    private AVMNodeDescriptor getBaseNode(AVMNodeDescriptor node) {
        if (node == null || !this.isTenantServiceEnabled()) {
            return node;
        }
        return new AVMNodeDescriptor(this.getBasePath(node.getPath()), node.getName(), node.getType(), node.getCreator(), node.getOwner(), node.getLastModifier(), node.getCreateDate(), node.getModDate(), node.getAccessDate(), node.getId(), node.getGuid(), node.getVersionID(), node.getIndirection(), node.getIndirectionVersion(), node.isPrimary(), node.getLayerID(), node.getOpacity(), node.getLength(), node.getDeletedType());
    }

    private AVMStoreDescriptor getBaseStore(AVMStoreDescriptor store) {
        if (store == null || !this.isTenantServiceEnabled()) {
            return store;
        }
        return new AVMStoreDescriptor(store.getId(), this.getBaseStoreName(store.getName()), store.getCreator(), store.getCreateDate());
    }

    private SortedMap<String, AVMNodeDescriptor> getBaseNodes(SortedMap<String, AVMNodeDescriptor> nodes) {
        if (nodes == null || !this.isTenantServiceEnabled()) {
            return nodes;
        }
        TreeMap<String, AVMNodeDescriptor> convertedNodes = new TreeMap<String, AVMNodeDescriptor>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, AVMNodeDescriptor> entry : nodes.entrySet()) {
            convertedNodes.put(entry.getKey(), this.getBaseNode(entry.getValue()));
        }
        return convertedNodes;
    }

    private AVMNodeDescriptor[] getBaseNodes(AVMNodeDescriptor[] nodes) {
        if (nodes == null || !this.isTenantServiceEnabled()) {
            return nodes;
        }
        AVMNodeDescriptor[] convertedNodes = new AVMNodeDescriptor[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            convertedNodes[i] = this.getBaseNode(nodes[i]);
        }
        return convertedNodes;
    }

    private List<AVMNodeDescriptor> getBaseNodes(List<AVMNodeDescriptor> nodes) {
        if (nodes == null || !this.isTenantServiceEnabled()) {
            return nodes;
        }
        ArrayList<AVMNodeDescriptor> convertedNodes = new ArrayList<AVMNodeDescriptor>(nodes.size());
        for (AVMNodeDescriptor node : nodes) {
            convertedNodes.add(this.getBaseNode(node));
        }
        return convertedNodes;
    }

    private boolean isTenantServiceEnabled() {
        if (this.enabled == null) {
            this.enabled = this.tenantService.isEnabled();
        }
        return this.enabled;
    }
}

