/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.util.LinkedList;
import java.util.List;
import org.alfresco.repo.avm.AVMDAOs;
import org.alfresco.repo.avm.AVMNode;
import org.alfresco.repo.avm.PlainFileNode;
import org.alfresco.repo.domain.avm.AVMHistoryLinkEntity;
import org.alfresco.repo.domain.avm.AVMMergeLinkEntity;
import org.alfresco.repo.domain.permissions.Acl;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrphanReaper {
    private Log fgLogger = LogFactory.getLog(OrphanReaper.class);
    private TransactionService fTransactionService;
    private long fActiveBaseSleep = 1000L;
    private int fBatchSize = 50;
    private boolean fActive = false;
    private int fQueueLength = 1000;
    private LinkedList<Long> fPurgeQueue;
    private boolean fDone = false;
    private boolean fRunning = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        block17: {
            OrphanReaper orphanReaper;
            block16: {
                OrphanReaper orphanReaper2 = this;
                synchronized (orphanReaper2) {
                    if (this.fRunning) {
                        if (!this.fgLogger.isDebugEnabled()) return;
                        this.fgLogger.debug((Object)"OrphanReaper is already running - just return");
                        return;
                    }
                    this.fRunning = true;
                    if (this.fgLogger.isTraceEnabled()) {
                        this.fgLogger.trace((Object)"Start running OrphanReaper ...");
                    }
                }
                try {
                    do {
                        this.doBatch();
                        if (this.fDone) {
                            if (this.fgLogger.isTraceEnabled()) {
                                this.fgLogger.trace((Object)"OrphanReaper is done - just return");
                            }
                            Object var4_3 = null;
                            orphanReaper = this;
                            break block16;
                        }
                        try {
                            if (this.fgLogger.isTraceEnabled()) {
                                this.fgLogger.trace((Object)("OrphanReaper is not done - sleep for " + this.fActiveBaseSleep + " ms"));
                            }
                            Thread.sleep(this.fActiveBaseSleep);
                        }
                        catch (InterruptedException e) {
                            this.fgLogger.warn((Object)("OrphanReaper was interrupted - do nothing: " + e));
                        }
                    } while (this.fActive);
                    break block17;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    OrphanReaper orphanReaper3 = this;
                    synchronized (orphanReaper3) {
                        this.fRunning = false;
                        if (!this.fgLogger.isTraceEnabled()) throw throwable;
                        this.fgLogger.trace((Object)"... finish running OrphanReaper");
                        throw throwable;
                    }
                }
            }
            synchronized (orphanReaper) {
                this.fRunning = false;
                if (!this.fgLogger.isTraceEnabled()) return;
                this.fgLogger.trace((Object)"... finish running OrphanReaper");
                return;
            }
        }
        Object var4_4 = null;
        OrphanReaper orphanReaper = this;
        synchronized (orphanReaper) {
            this.fRunning = false;
            if (!this.fgLogger.isTraceEnabled()) return;
            this.fgLogger.trace((Object)"... finish running OrphanReaper");
            return;
        }
    }

    public void setActiveBaseSleep(long interval) {
        this.fActiveBaseSleep = interval;
    }

    public void setBatchSize(int size) {
        this.fBatchSize = size;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.fTransactionService = transactionService;
    }

    public void setMaxQueueLength(int queueLength) {
        this.fQueueLength = queueLength;
    }

    public void shutDown() {
        this.fDone = true;
    }

    public void activate() {
        this.fActive = true;
    }

    public boolean isActive() {
        return this.fActive;
    }

    public void doBatch() {
        try {
            if (!this.fTransactionService.isReadOnly()) {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class TxnWork
                implements RetryingTransactionHelper.RetryingTransactionCallback<Object> {
                    TxnWork() {
                    }

                    @Override
                    public Object execute() throws Exception {
                        if (OrphanReaper.this.fgLogger.isTraceEnabled()) {
                            OrphanReaper.this.fgLogger.trace((Object)("Orphan reaper doBatch: batchSize=" + OrphanReaper.this.fBatchSize + ", maxQueueLength=" + OrphanReaper.this.fQueueLength + ", fActiveBaseSleep=" + OrphanReaper.this.fActiveBaseSleep));
                        }
                        if (OrphanReaper.this.fPurgeQueue == null) {
                            List<AVMNode> nodes = AVMDAOs.Instance().fAVMNodeDAO.getOrphans(OrphanReaper.this.fQueueLength);
                            if (nodes.size() == 0) {
                                if (OrphanReaper.this.fgLogger.isTraceEnabled()) {
                                    OrphanReaper.this.fgLogger.trace((Object)"Nothing to purge (set fActive = false)");
                                }
                                OrphanReaper.this.fActive = false;
                                return null;
                            }
                            OrphanReaper.this.fPurgeQueue = new LinkedList();
                            for (AVMNode node : nodes) {
                                OrphanReaper.this.fPurgeQueue.add(node.getId());
                            }
                            if (OrphanReaper.this.fgLogger.isDebugEnabled()) {
                                OrphanReaper.this.fgLogger.debug((Object)("Queue was empty so got more orphans from DB. Orphan queue size = " + OrphanReaper.this.fPurgeQueue.size()));
                            }
                        } else if (OrphanReaper.this.fgLogger.isDebugEnabled()) {
                            OrphanReaper.this.fgLogger.debug((Object)("Queue was not empty. Orphan queue size = " + OrphanReaper.this.fPurgeQueue.size()));
                        }
                        OrphanReaper.this.fActive = true;
                        int reapCnt = 0;
                        long start = System.currentTimeMillis();
                        for (int i = 0; i < OrphanReaper.this.fBatchSize; ++i) {
                            if (OrphanReaper.this.fPurgeQueue.size() == 0) {
                                if (OrphanReaper.this.fgLogger.isTraceEnabled()) {
                                    OrphanReaper.this.fgLogger.trace((Object)("Purge queue is empty (fpurgeQueue size = " + OrphanReaper.this.fPurgeQueue.size() + ")"));
                                }
                                OrphanReaper.this.fPurgeQueue = null;
                                break;
                            }
                            Long nodeId = (Long)OrphanReaper.this.fPurgeQueue.removeFirst();
                            AVMNode node = AVMDAOs.Instance().fAVMNodeDAO.getByID(nodeId);
                            if (node == null) {
                                OrphanReaper.this.fgLogger.warn((Object)("Node [" + nodeId + "] not found - assume multiple reapers ..."));
                                continue;
                            }
                            AVMNode ancestor = null;
                            AVMHistoryLinkEntity hlEntity = AVMDAOs.Instance().newAVMNodeLinksDAO.getHistoryLinkByDescendent(node.getId());
                            if (hlEntity != null) {
                                ancestor = AVMDAOs.Instance().fAVMNodeDAO.getByID(hlEntity.getAncestorNodeId());
                                AVMDAOs.Instance().newAVMNodeLinksDAO.deleteHistoryLink(hlEntity.getAncestorNodeId(), hlEntity.getDescendentNodeId());
                            }
                            AVMNode mergedFrom = null;
                            AVMMergeLinkEntity mlEntity = AVMDAOs.Instance().newAVMNodeLinksDAO.getMergeLinkByTo(node.getId());
                            if (mlEntity != null) {
                                mergedFrom = AVMDAOs.Instance().fAVMNodeDAO.getByID(mlEntity.getMergeFromNodeId());
                                AVMDAOs.Instance().newAVMNodeLinksDAO.deleteMergeLink(mlEntity.getMergeFromNodeId(), mlEntity.getMergeToNodeId());
                            }
                            List<AVMHistoryLinkEntity> hlEntities = AVMDAOs.Instance().newAVMNodeLinksDAO.getHistoryLinksByAncestor(node.getId());
                            for (AVMHistoryLinkEntity link : hlEntities) {
                                AVMNode desc = AVMDAOs.Instance().fAVMNodeDAO.getByID(link.getDescendentNodeId());
                                if (desc != null) {
                                    desc.setAncestor(ancestor);
                                    if (desc.getMergedFrom() == null) {
                                        desc.setMergedFrom(mergedFrom);
                                    }
                                }
                                AVMDAOs.Instance().newAVMNodeLinksDAO.deleteHistoryLink(link.getAncestorNodeId(), link.getDescendentNodeId());
                            }
                            List<AVMMergeLinkEntity> mlEntities = AVMDAOs.Instance().newAVMNodeLinksDAO.getMergeLinksByFrom(node.getId());
                            for (AVMMergeLinkEntity link : mlEntities) {
                                AVMNode mto = AVMDAOs.Instance().fAVMNodeDAO.getByID(link.getMergeToNodeId());
                                if (mto != null) {
                                    mto.setMergedFrom(ancestor);
                                }
                                AVMDAOs.Instance().newAVMNodeLinksDAO.deleteMergeLink(link.getMergeFromNodeId(), link.getMergeToNodeId());
                            }
                            AVMDAOs.Instance().fAVMNodeDAO.deleteProperties(node.getId());
                            AVMDAOs.Instance().fAVMNodeDAO.deleteAspects(node.getId());
                            Acl acl = node.getAcl();
                            node.setAcl(null);
                            if (node.getType() == 2 || node.getType() == 3) {
                                AVMDAOs.Instance().fChildEntryDAO.deleteByParent(node);
                            } else if (node.getType() == 0) {
                                Long contentDataId;
                                PlainFileNode file = (PlainFileNode)node;
                                if (file.isLegacyContentData()) {
                                    ContentData contentData = file.getContentData();
                                    file.setContentData(contentData);
                                }
                                if ((contentDataId = file.getContentDataId()) != null) {
                                    AVMDAOs.Instance().contentDataDAO.deleteContentData(contentDataId);
                                }
                            }
                            AVMDAOs.Instance().fAVMNodeDAO.delete(node);
                            if (OrphanReaper.this.fgLogger.isTraceEnabled()) {
                                OrphanReaper.this.fgLogger.trace((Object)("Deleted Node [" + node.getId() + "]"));
                            }
                            ++reapCnt;
                        }
                        if (OrphanReaper.this.fgLogger.isDebugEnabled()) {
                            OrphanReaper.this.fgLogger.debug((Object)("Reaped " + reapCnt + " nodes in " + (System.currentTimeMillis() - start) + " msecs"));
                        }
                        return null;
                    }
                }
                this.fTransactionService.getRetryingTransactionHelper().doInTransaction(new TxnWork());
            }
        }
        catch (Exception e) {
            this.fgLogger.error((Object)"Garbage collector error", (Throwable)e);
        }
    }
}

