/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.avm.PurgeStoreCallback;
import org.alfresco.repo.transaction.TransactionListenerAdapter;

public class PurgeStoreTxnListener
extends TransactionListenerAdapter {
    private ThreadLocal<List<String>> fPurgedStores = new ThreadLocal();
    private List<PurgeStoreCallback> fCallbacks = new ArrayList<PurgeStoreCallback>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCommit() {
        List<String> created = this.fPurgedStores.get();
        if (created != null) {
            for (String name : created) {
                PurgeStoreTxnListener purgeStoreTxnListener = this;
                synchronized (purgeStoreTxnListener) {
                    for (PurgeStoreCallback cb : this.fCallbacks) {
                        cb.storePurged(name);
                    }
                }
            }
            this.fPurgedStores.set(null);
        }
    }

    public void afterRollback() {
        this.fPurgedStores.set(null);
    }

    public void storePurged(String storeName) {
        List<String> purged = this.fPurgedStores.get();
        if (purged == null) {
            purged = new ArrayList<String>();
            this.fPurgedStores.set(purged);
        }
        purged.add(storeName);
    }

    public synchronized void addCallback(PurgeStoreCallback cb) {
        this.fCallbacks.add(cb);
    }
}

